/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.sts.client;

import java.util.Iterator;
import java.util.LinkedHashMap;

/**
 * Parses distinguished name string into attributeType/attributeValue pairs
 */
public class DNParser {
	private final static char SEP = '=';
	private final static char QUOTE = '"';
	private final static char DELIM = ',';
	private final static char ESCAPE = '\\';

	/**
	 * Parses distinguished name string into attributeType/attributeValue pairs
	 * 
	 * @param dn
	 *            Distinguished name
	 * @return Map with attributeType/attributeValue pairs
	 * @throws Exception
	 */
	public static LinkedHashMap parse(String dn) throws Exception {
		LinkedHashMap dnMap = new LinkedHashMap();
		boolean isKeyProcessed = true;
		boolean startedQuote = false;
		String key = "";
		StringBuffer currentToken = new StringBuffer();
		char current = 0;
		char previous = 0;
		for (int i = 0, size = dn.length(); i < size; i++) {
			previous = current;
			current = dn.charAt(i);
			if (current == SEP) {
				if (isKeyProcessed) {
					key = currentToken.toString();
					currentToken = new StringBuffer();
					isKeyProcessed = false;
				} else {
					if (startedQuote) {
						currentToken.append(current);
					} else
						throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
				}
			} else if (current == ESCAPE) {
				if (previous == ESCAPE) {
					currentToken.append(current);
				}
			} else if (current == QUOTE) {
				if (previous == ESCAPE) {
					currentToken.append(current);
				} else if (!isKeyProcessed) {
					startedQuote = !startedQuote;
					currentToken.append(current);
				} else
					throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
			} else if (current == DELIM) {
				if (previous == ESCAPE) {
					currentToken.append(current);
				} else if (!isKeyProcessed) {
					if (startedQuote) {
						currentToken.append(current);
					} else {
						String value = currentToken.toString();
						dnMap.put(key.trim(), value.trim());
//						Object previousVal = dnMap.put(key.trim(), value.trim());
//						if (previousVal != null)
//							throw new Exception(dn + " DN contains duplicated key " + key);
						isKeyProcessed = true;
						startedQuote = false;
						key = "";
						currentToken = new StringBuffer();
					}
				} else
					throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
			} else {
				currentToken.append(current);
			}
		}
		if (!isKeyProcessed) {
			String value = currentToken.toString();
			Object previousVal = dnMap.put(key.trim(), value.trim());
			if (previousVal != null)
				throw new Exception(dn + " DN contains duplicated key " + key);
		}
		return dnMap;
	}

}
