/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import org.eclipse.higgins.sts.utilities.InvalidRandomParameterException;
import org.eclipse.higgins.sts.utilities.UnsupportedOptionException;

public class X931KeyGenerator {
    private BigInteger xQ1;
    private BigInteger xQ2;
    private BigInteger xP1;
    private BigInteger xP2;
    private BigInteger xP;
    private BigInteger xQ;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger privateExponentP;
    private BigInteger privateExponentQ;
    private BigInteger crtCoefficient;

    private static boolean isProbableX931Prime(BigInteger candidate) {
        if (candidate != null) {
            return candidate.isProbablePrime(100);
        }
        return false;
    }

    public static BigInteger findSmallPrimeSequential(BigInteger startFrom) {
        BigInteger result = startFrom;
        if (startFrom.getLowestSetBit() != 0) {
            result = startFrom.add(BigInteger.ONE);
        }
        BigInteger TWO = new BigInteger("2");
        while (!X931KeyGenerator.isProbableX931Prime(result)) {
            result = result.add(TWO);
        }
        return result;
    }

    public static BigInteger findX931KeyPrime(BigInteger startFrom, BigInteger factorOfPMinus1, BigInteger factorOfPPlus1, BigInteger publicExponent) throws UnsupportedOptionException {
        BigInteger temp;
        BigInteger candidate;
        if (publicExponent.getLowestSetBit() != 0) {
            throw new UnsupportedOptionException();
        }
        BigInteger product = factorOfPMinus1.multiply(factorOfPPlus1);
        BigInteger R = factorOfPPlus1.modInverse(factorOfPMinus1).multiply(factorOfPPlus1);
        if ((R = R.subtract(factorOfPMinus1.modInverse(factorOfPPlus1).multiply(factorOfPMinus1))).signum() == -1) {
            R = R.add(product);
        }
        if ((candidate = startFrom.add(temp = R.subtract(startFrom.mod(product)))).compareTo(startFrom) == -1) {
            candidate = candidate.add(product);
        }
        while (publicExponent.gcd(candidate.subtract(BigInteger.ONE)).compareTo(BigInteger.ONE) != 0 || !X931KeyGenerator.isProbableX931Prime(candidate)) {
            candidate = candidate.add(product);
        }
        return candidate;
    }

    public X931KeyGenerator(byte[] xp1, byte[] xp2, byte[] xq1, byte[] xq2, byte[] xp, byte[] xq) throws InvalidRandomParameterException {
        try {
            this.xQ1 = new BigInteger(1, xq1);
            this.xQ2 = new BigInteger(1, xq2);
            this.xP1 = new BigInteger(1, xp1);
            this.xP2 = new BigInteger(1, xp2);
            this.xP = new BigInteger(1, xp);
            this.xQ = new BigInteger(1, xq);
        }
        catch (Exception e) {
            throw new InvalidRandomParameterException(100);
        }
    }

    public KeyPair GenerateKeyPair(RSAKeyGenParameterSpec params) throws UnsupportedOptionException, InvalidRandomParameterException {
        int keysize = params.getKeysize();
        if (keysize < 1024 || (keysize - 1024) % 256 != 0) {
            throw new UnsupportedOptionException();
        }
        if (this.xP1.bitLength() < 101 || this.xP2.bitLength() < 101 || this.xQ1.bitLength() < 101 || this.xQ2.bitLength() < 101) {
            throw new InvalidRandomParameterException(100);
        }
        if (!(this.xP.testBit(keysize / 2 - 1) && this.xP.testBit(keysize / 2 - 2) && this.xQ.testBit(keysize / 2 - 1) && this.xQ.testBit(keysize / 2 - 2))) {
            throw new InvalidRandomParameterException(100);
        }
        this.publicExponent = params.getPublicExponent();
        if (this.publicExponent.getLowestSetBit() != 0) {
            throw new UnsupportedOptionException();
        }
        this.xP1 = X931KeyGenerator.findSmallPrimeSequential(this.xP1);
        this.xP2 = X931KeyGenerator.findSmallPrimeSequential(this.xP2);
        this.xQ1 = X931KeyGenerator.findSmallPrimeSequential(this.xQ1);
        this.xQ2 = X931KeyGenerator.findSmallPrimeSequential(this.xQ2);
        this.primeP = X931KeyGenerator.findX931KeyPrime(this.xP, this.xP1, this.xP2, this.publicExponent);
        this.primeQ = X931KeyGenerator.findX931KeyPrime(this.xQ, this.xQ1, this.xQ2, this.publicExponent);
        BigInteger diff = this.primeP.subtract(this.primeQ).abs();
        if (diff.bitLength() < keysize / 2 - 100) {
            throw new InvalidRandomParameterException(101);
        }
        if (this.primeP.compareTo(this.primeQ) == -1) {
            BigInteger temp = this.primeP;
            this.primeP = this.primeQ;
            this.primeQ = temp;
        }
        this.modulus = this.primeP.multiply(this.primeQ);
        BigInteger lcmP1Q1 = this.primeP.subtract(BigInteger.ONE).multiply(this.primeQ.subtract(BigInteger.ONE));
        lcmP1Q1 = lcmP1Q1.divide(this.primeP.subtract(BigInteger.ONE).gcd(this.primeQ.subtract(BigInteger.ONE)));
        this.privateExponent = this.publicExponent.modInverse(lcmP1Q1);
        if (this.privateExponent.bitLength() < keysize / 2) {
            throw new InvalidRandomParameterException(102);
        }
        this.privateExponentP = this.privateExponent.mod(this.primeP.subtract(BigInteger.ONE));
        this.privateExponentQ = this.privateExponent.mod(this.primeQ.subtract(BigInteger.ONE));
        this.crtCoefficient = this.primeQ.modInverse(this.primeP);
        X931RSAKeyPair privateKey = new X931RSAKeyPair(this.primeP, this.primeQ, this.modulus, this.publicExponent, this.privateExponent, this.privateExponentP, this.privateExponentQ, this.crtCoefficient);
        return new KeyPair(privateKey, privateKey);
    }

    public static void main(String[] args) {
        byte[] xp1 = new byte[]{26, 25, 22, -35, -78, -101, 78, -73, -21, 103, 50, -31, 40};
        byte[] xp2 = new byte[]{25, 46, -118, -84, 65, -59, 118, -56, 34, -39, 62, -92, 51};
        byte[] xp = new byte[]{-27, 50, -49, 110, 23, -31, -110, -74, -108, -31, 49, 58, 60, -32, 67, 83, 76, -46, 78, 38, 78, 119, 63, 123, -34, -115, -102, 25, 14, -15, -91, -85, -124, 28, 77, 57, 50, -88, 91, 72, -44, 40, -121, 93, -41, 16, 23, 100, -119, -26, -105, 61, -53, -71, -36, 55, -108, 50, -62, 107, 51, -86, 111, -77, -79, -101, 3, -32, 107, -40, -81, -33, -48, 69, 42, -94, -109, -89, 127, -18, 24, -90, -92, 26, -19, 58, -38, -20, -56, -40, -12, -14, 92, 45, -41, -79, 63, -51, -8, -74, -64, -76, -55, 38, 115, -65, -110, 75, 80, -44, -104, -38, 42, 22, -29, 115, -35, 64, 90, -47, 16, -66, -96, 19, 115, 23, -77, 8};
        byte[] xq1 = new byte[]{31, 38, 84, -50, 35, -27, -9, 119, 15, -121, 40, 103, 12};
        byte[] xq2 = new byte[]{29, -122, 126, 100, 6, 93, -18, 62, 121, 85, -14, -21, -57};
        byte[] xq = new byte[]{-46, -35, -71, 39, 87, 96, -56, -86, -49, -60, 106, -42, -61, -41, -113, 7, -120, -47, -121, 51, -42, -80, 36, 4, 62, 4, -82, 112, -25, 23, -108, -64, 35, 26, -53, -83, 40, -4, 15, -63, 55, -40, -49, -88, 72, 116, 117, -108, -10, -18, -115, 93, 49, -116, 105, 98, -89, 10, -76, 113, -70, 67, -101, 18, 39, -18, -22, -3, -22, -73, 90, -63, 25, -41, 33, 120, -70, -12, 104, 91, -109, 29, -15, -56, 126, 35, 15, 51, -21, 18, 12, -33, -25, -90, 24, -92, -116, 99, -78, 6, -98, 98, 97, 1, 82, 117, 44, 17, 57, -112, -94, 26, 85, 31, -31, 127, 111, 113, 28, -24, 18, 25, 126, 28, -100, -27, -34, -90};
        RSAPrivateCrtKey mykey = null;
        try {
            X931KeyGenerator mykeygen = new X931KeyGenerator(xp1, xp2, xq1, xq2, xp, xq);
            mykey = (RSAPrivateCrtKey)mykeygen.GenerateKeyPair(new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F0)).getPrivate();
        }
        catch (UnsupportedOptionException e1) {
            System.out.println(" option is not supported ");
        }
        catch (InvalidRandomParameterException e2) {
            System.out.println(" input random parameter is not valid: reason code is " + e2.getStatusCode());
        }
        System.out.println(" Generated Key (hex values)");
        System.out.println(" P:");
        System.out.println(mykey.getPrimeP().toString(16));
        System.out.println(" Q:");
        System.out.println(mykey.getPrimeQ().toString(16));
        System.out.println(" n ");
        System.out.println(mykey.getModulus().toString(16));
        System.out.println(" e ");
        System.out.println(mykey.getPublicExponent().toString(16));
        System.out.println(" d ");
        System.out.println(mykey.getPrivateExponent().toString(16));
        System.out.println(" dp ");
        System.out.println(mykey.getPrimeExponentP().toString(16));
        System.out.println(" dq ");
        System.out.println(mykey.getPrimeExponentQ().toString(16));
        System.out.println(" coefficient ");
        System.out.println(mykey.getCrtCoefficient().toString(16));
    }

    private class X931RSAKeyPair
    implements RSAPrivateCrtKey,
    RSAPublicKey {
        private static final long serialVersionUID = 1L;
        BigInteger p;
        BigInteger q;
        BigInteger n;
        BigInteger e;
        BigInteger d;
        BigInteger dp;
        BigInteger dq;
        BigInteger c;

        public X931RSAKeyPair(BigInteger p, BigInteger q, BigInteger n, BigInteger e, BigInteger d, BigInteger dp, BigInteger dq, BigInteger c) {
            this.p = p;
            this.q = q;
            this.n = n;
            this.e = e;
            this.d = d;
            this.dp = dp;
            this.dq = dq;
            this.c = c;
        }

        public BigInteger getCrtCoefficient() {
            return this.c;
        }

        public BigInteger getPrimeExponentP() {
            return this.dp;
        }

        public BigInteger getPrimeExponentQ() {
            return this.dq;
        }

        public BigInteger getPrimeP() {
            return this.p;
        }

        public BigInteger getPrimeQ() {
            return this.q;
        }

        public BigInteger getPublicExponent() {
            return this.e;
        }

        public BigInteger getPrivateExponent() {
            return this.d;
        }

        public BigInteger getModulus() {
            return this.n;
        }

        public String getAlgorithm() {
            return "RSA X9.31";
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return null;
        }
    }
}

