/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLHelper {
    private static final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$utilities$XMLHelper == null ? (class$org$eclipse$higgins$sts$utilities$XMLHelper = XMLHelper.class$("org.eclipse.higgins.sts.utilities.XMLHelper")) : class$org$eclipse$higgins$sts$utilities$XMLHelper).getName());
    static /* synthetic */ Class class$org$eclipse$higgins$sts$utilities$XMLHelper;

    public static void maskPasswordForChildren(org.w3c.dom.Element element) {
        NodeList nlist;
        if (element.hasAttribute("password")) {
            try {
                element.setAttribute("password", "xxxxx");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (element.getLocalName().equalsIgnoreCase("password")) {
            XMLHelper.setTextContent(element, "xxxxx");
        }
        if (null != (nlist = element.getChildNodes())) {
            int nlen = nlist.getLength();
            for (int i = 0; i < nlen; ++i) {
                Node childNode = nlist.item(i);
                if (childNode.getNodeType() != 1) continue;
                org.w3c.dom.Element childElem = (org.w3c.dom.Element)childNode;
                XMLHelper.maskPasswordForChildren(childElem);
            }
        }
    }

    public static String htmlEncode(String pText) {
        StringTokenizer tokenizer = new StringTokenizer(pText, "&<>\"", true);
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            return pText;
        }
        StringBuffer buffer = new StringBuffer(pText.length() + tokenCount * 6);
        block6: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1) {
                switch (token.charAt(0)) {
                    case '&': {
                        buffer.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        buffer.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        continue block6;
                    }
                }
                buffer.append(token);
                continue;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    static String[] htmlEncode(String[] strs) {
        String[] result = null;
        if (strs != null) {
            result = new String[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                result[i] = XMLHelper.htmlEncode(strs[i]);
            }
        }
        return result;
    }

    public static String escapedString(String strUnescaped) {
        String strEscapedAmps = strUnescaped.replaceAll("&", "&amp;");
        String strEscapedHash = strEscapedAmps.replaceAll("#", "%23");
        String strResult = strEscapedHash.replaceFirst("%23", "#");
        return strResult;
    }

    public static byte[] toByteArr(String no) {
        byte[] number = new byte[no.length() / 2];
        for (int i = 0; i < no.length(); i += 2) {
            int j = Integer.parseInt(no.substring(i, i + 2), 16);
            number[i / 2] = (byte)(j & 0xFF);
        }
        return number;
    }

    public static void printHex(byte[] b) {
        XMLHelper.printHex(b, b.length);
    }

    public static void printHex(short[] b) {
        XMLHelper.printHex(b, b.length);
    }

    public static void printHex(int[] b) {
        XMLHelper.printHex(b, b.length);
    }

    public static void printHex(String label, byte[] b) {
        XMLHelper.printHex(label, b, b.length);
    }

    public static void printHex(String label, short[] b) {
        XMLHelper.printHex(label, b, b.length);
    }

    public static void printHex(String label, int[] b) {
        XMLHelper.printHex(label, b, b.length);
    }

    public static String toHexF(String label, byte[] b) {
        return XMLHelper.toHexF(label, b, b.length);
    }

    public static String toHexF(String label, short[] b) {
        return XMLHelper.toHexF(label, b, b.length);
    }

    public static String toHexF(String label, int[] b) {
        return XMLHelper.toHexF(label, b, b.length);
    }

    public static String toHexF(int[] b) {
        return XMLHelper.toHexF(b, b.length);
    }

    public static String toHexF(short[] b) {
        return XMLHelper.toHexF(b, b.length);
    }

    public static String toHexF(byte[] b) {
        return XMLHelper.toHexF(b, b.length);
    }

    public static String toHex(byte[] b) {
        return XMLHelper.toHex(b, b.length);
    }

    public static String toHex(short[] b) {
        return XMLHelper.toHex(b, b.length);
    }

    public static String toHex(int[] b) {
        return XMLHelper.toHex(b, b.length);
    }

    public static void printHex(String label, byte[] b, int len) {
        System.out.println(label);
        XMLHelper.printHex(b, len);
    }

    public static void printHex(String label, short[] b, int len) {
        System.out.println(label);
        XMLHelper.printHex(b, len);
    }

    public static void printHex(String label, int[] b, int len) {
        System.out.println(label);
        XMLHelper.printHex(b, len);
    }

    public static void printHex(byte[] b, int len) {
        System.out.print(XMLHelper.toHexF(b, len));
    }

    public static void printHex(short[] b, int len) {
        System.out.print(XMLHelper.toHexF(b, len));
    }

    public static void printHex(int[] b, int len) {
        System.out.print(XMLHelper.toHexF(b, len));
    }

    public static String toHexF(String label, int[] b, int len) {
        return label + "\n" + XMLHelper.toHexF(b, len);
    }

    public static String toHexF(String label, short[] b, int len) {
        return label + "\n" + XMLHelper.toHexF(b, len);
    }

    public static String toHexF(String label, byte[] b, int len) {
        return label + "\n" + XMLHelper.toHexF(b, len);
    }

    public static String toHexF(byte[] b, int len) {
        int i;
        StringBuffer s = new StringBuffer("");
        if (b == null) {
            return "<null>";
        }
        for (i = 0; i < len; ++i) {
            s.append(" " + XMLHelper.toHex(b[i]));
            if (i % 16 == 15) {
                s.append("\n");
                continue;
            }
            if (i % 8 == 7) {
                s.append(" ");
                continue;
            }
            if (i % 4 != 3) continue;
            s.append(" ");
        }
        if (i % 16 != 0) {
            s.append("\n");
        }
        return s.toString();
    }

    public static String toHexF(short[] b, int len) {
        int i;
        StringBuffer s = new StringBuffer("");
        if (b == null) {
            return "<null>";
        }
        for (i = 0; i < len; ++i) {
            s.append(" " + XMLHelper.toHex(b[i]));
            if (i % 16 == 7) {
                s.append("\n");
                continue;
            }
            if (i % 4 != 3) continue;
            s.append(" ");
        }
        if (i % 8 != 0) {
            s.append("\n");
        }
        return s.toString();
    }

    public static String toHexF(int[] b, int len) {
        int i;
        StringBuffer s = new StringBuffer("");
        if (b == null) {
            return "<null>";
        }
        for (i = 0; i < len; ++i) {
            s.append(" " + XMLHelper.toHex(b[i]));
            if (i % 4 != 3) continue;
            s.append("\n");
        }
        if (i % 4 != 0) {
            s.append("\n");
        }
        return s.toString();
    }

    public static String toHex(int[] b, int len) {
        if (b == null) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i < len; ++i) {
            s.append(XMLHelper.toHex(b[i]));
        }
        return s.toString();
    }

    public static String toHex(short[] b, int len) {
        if (b == null) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i < len; ++i) {
            s.append(XMLHelper.toHex(b[i]));
        }
        return s.toString();
    }

    public static String toHex(byte[] b, int len) {
        if (b == null) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i < len; ++i) {
            s.append(XMLHelper.toHex(b[i]));
        }
        return s.toString();
    }

    public static String toHex(byte b) {
        Integer I = new Integer(b << 24 >>> 24);
        int i = I;
        if (i < 16) {
            return "0" + Integer.toString(i, 16);
        }
        return Integer.toString(i, 16);
    }

    public static String toHex(short i) {
        byte[] b = new byte[]{(byte)((i & 0xFF00) >>> 8), (byte)(i & 0xFF)};
        return XMLHelper.toHex(b[0]) + XMLHelper.toHex(b[1]);
    }

    public static String toHex(int i) {
        byte[] b = new byte[]{(byte)((i & 0xFF000000) >>> 24), (byte)((i & 0xFF0000) >>> 16), (byte)((i & 0xFF00) >>> 8), (byte)(i & 0xFF)};
        return XMLHelper.toHex(b[0]) + XMLHelper.toHex(b[1]) + XMLHelper.toHex(b[2]) + XMLHelper.toHex(b[3]);
    }

    public static String stripNewLinesFromString(String strValue) {
        int nCR = strValue.indexOf(13);
        while (-1 != nCR) {
            StringBuffer sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(nCR);
            strValue = sbValue.toString();
            nCR = strValue.indexOf(13);
        }
        int nLF = strValue.indexOf(10);
        while (-1 != nLF) {
            StringBuffer sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(nLF);
            strValue = sbValue.toString();
            nLF = strValue.indexOf(10);
        }
        return strValue;
    }

    public static String stripWhiteSpaceFromString(String strValue) {
        int nCR = strValue.indexOf(13);
        while (-1 != nCR) {
            StringBuffer sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(nCR);
            strValue = sbValue.toString();
            nCR = strValue.indexOf(13);
        }
        int nLF = strValue.indexOf(10);
        while (-1 != nLF) {
            StringBuffer sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(nLF);
            strValue = sbValue.toString();
            nLF = strValue.indexOf(10);
        }
        int nSP = strValue.indexOf(32);
        while (-1 != nSP) {
            StringBuffer sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(nSP);
            strValue = sbValue.toString();
            nSP = strValue.indexOf(32);
        }
        return strValue;
    }

    public static IElement toElement(OMElement omElement) throws Exception {
        Element element = new Element();
        element.set(omElement);
        return element;
    }

    public static IElement toElement(org.w3c.dom.Element domElement) throws Exception {
        Element element = new Element();
        element.set(domElement);
        return element;
    }

    public static org.w3c.dom.Element toDOM(OMElement omElement) throws Exception {
        if (null == omElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            omElement.serialize((OutputStream)outputStream);
        }
        catch (Exception e) {
            ExceptionHelper.Log(log, e);
            return null;
        }
        if (0 == outputStream.size()) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document domDocument = documentBuilder.parse(inputStream);
        return domDocument.getDocumentElement();
    }

    public static String toString(OMElement omElement) throws Exception {
        if (null == omElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        omElement.serialize((OutputStream)outputStream);
        String strElement = null;
        try {
            strElement = outputStream.toString("UTF-8");
            strElement = XMLHelper.StripNamespaceDeclaration(strElement);
        }
        catch (UnsupportedEncodingException uee) {
            ExceptionHelper.Log(log, uee);
            throw uee;
        }
        return strElement;
    }

    public static String StripNamespaceDeclaration(String strElement) {
        boolean bNamespaceDeclaration = strElement.startsWith("<?xml");
        if (!bNamespaceDeclaration) {
            return strElement;
        }
        String strResult = strElement.substring(1);
        int nBegin = strResult.indexOf("<");
        return strResult.substring(nBegin);
    }

    public static OMElement toOM(org.w3c.dom.Element domElement) throws Exception {
        if (null == domElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Properties prop = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer ser = SerializerFactory.getSerializer((Properties)prop);
        ser.setOutputFormat(prop);
        ser.setOutputStream((OutputStream)outputStream);
        DOMSerializer domSerializer = ser.asDOMSerializer();
        domSerializer.serialize((Node)domElement);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static String getTextContent(Text text) {
        return text.getNodeValue();
    }

    public static void setTextContent(Text text, String value) {
        text.setNodeValue(value);
    }

    public static String getTextContent(org.w3c.dom.Element element) {
        NodeList nlChildren = element.getChildNodes();
        for (int i = 0; i < nlChildren.getLength(); ++i) {
            Node nodeChild = nlChildren.item(i);
            if (3 != nodeChild.getNodeType()) continue;
            Text textChild = (Text)nodeChild;
            return textChild.getData();
        }
        return null;
    }

    public static void setTextContent(org.w3c.dom.Element element, String value) {
        NodeList nlChildren = element.getChildNodes();
        for (int i = 0; i < nlChildren.getLength(); ++i) {
            Node nodeChild = nlChildren.item(i);
            if (3 != nodeChild.getNodeType()) continue;
            Text textChild = (Text)nodeChild;
            textChild.setData(value);
            return;
        }
        Text textNode = element.getOwnerDocument().createTextNode(value);
        element.appendChild(textNode);
    }

    public static void stripNewLinesFromElement(org.w3c.dom.Element domElement) {
        if (null == domElement) {
            return;
        }
        domElement.normalize();
        NodeList nlChildren = domElement.getChildNodes();
        for (int i = 0; i < nlChildren.getLength(); ++i) {
            Node nodeChild = nlChildren.item(i);
            if (3 == nodeChild.getNodeType()) {
                Text text = (Text)nodeChild;
                String strContent = XMLHelper.getTextContent(text);
                strContent = XMLHelper.stripNewLinesFromString(strContent);
                XMLHelper.setTextContent(text, strContent);
            }
            if (1 != nodeChild.getNodeType()) continue;
            XMLHelper.stripNewLinesFromElement((org.w3c.dom.Element)nodeChild);
        }
    }

    public static void stripWhiteSpaceFromElement(org.w3c.dom.Element domElement) {
        if (null == domElement) {
            return;
        }
        domElement.normalize();
        NodeList nlChildren = domElement.getChildNodes();
        for (int i = 0; i < nlChildren.getLength(); ++i) {
            Node nodeChild = nlChildren.item(i);
            if (3 == nodeChild.getNodeType()) {
                Text text = (Text)nodeChild;
                String strContent = XMLHelper.getTextContent(text);
                strContent = XMLHelper.stripWhiteSpaceFromString(strContent);
                XMLHelper.setTextContent(text, strContent);
            }
            if (1 != nodeChild.getNodeType()) continue;
            XMLHelper.stripWhiteSpaceFromElement((org.w3c.dom.Element)nodeChild);
        }
    }

    public static String toString(org.w3c.dom.Element domElement) throws IOException {
        if (null == domElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Properties prop = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer ser = SerializerFactory.getSerializer((Properties)prop);
        ser.setOutputFormat(prop);
        ser.setOutputStream((OutputStream)outputStream);
        DOMSerializer domSerializer = ser.asDOMSerializer();
        domSerializer.serialize((Node)domElement);
        String strElement = null;
        try {
            strElement = outputStream.toString("UTF-8");
            strElement = XMLHelper.StripNamespaceDeclaration(strElement);
        }
        catch (UnsupportedEncodingException uee) {
            ExceptionHelper.Log(log, uee);
            throw uee;
        }
        return strElement;
    }

    public static void logElement(org.w3c.dom.Element domElement) throws IOException {
        String strElement = XMLHelper.toString(domElement);
        log.trace(strElement);
    }

    public static org.w3c.dom.Element toDOM(String strElement) throws IOException, Exception {
        if (null == strElement) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strElement.getBytes());
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            ExceptionHelper.Log(log, e);
            throw e;
        }
        Document docElement = null;
        try {
            docElement = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            ExceptionHelper.Log(log, e);
            throw e;
        }
        return docElement.getDocumentElement();
    }

    public static org.w3c.dom.Element reparseElement(org.w3c.dom.Element domElement) throws IOException, Exception {
        if (null == domElement) {
            return null;
        }
        Document docIn = domElement.getOwnerDocument();
        String strElement = XMLHelper.toString(domElement);
        org.w3c.dom.Element domParsed = XMLHelper.toDOM(strElement);
        org.w3c.dom.Element domResult = (org.w3c.dom.Element)docIn.importNode(domParsed, true);
        return domResult;
    }

    public static org.w3c.dom.Element domFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            ExceptionHelper.Log(log, e);
            throw e;
        }
        Document docElement = null;
        try {
            docElement = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            ExceptionHelper.Log(log, e);
            throw e;
        }
        return docElement.getDocumentElement();
    }

    public static org.w3c.dom.Element domFromFile(String strFileName) throws FileNotFoundException, Exception {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(strFileName);
        }
        catch (FileNotFoundException fnfe) {
            ExceptionHelper.Log(log, fnfe);
            throw fnfe;
        }
        return XMLHelper.domFromStream(inputStream);
    }

    public static OMElement omFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static OMElement omFromFile(String strFileName) throws FileNotFoundException, Exception {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(strFileName);
        }
        catch (FileNotFoundException fnfe) {
            ExceptionHelper.Log(log, fnfe);
            throw fnfe;
        }
        return XMLHelper.omFromStream(inputStream);
    }

    public static OMElement toOM(String strElement) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strElement.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

