/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

/**
 * @author mikemci
 *
 */
public class UsernameToken
	implements org.eclipse.higgins.sts.api.IUsernameToken
{
	private String strPassword = null;
	
	private String strUsername = null;
	
	private final java.net.URI uriTokenType = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#getPassword()
	 */
	public String getPassword() {
		// TODO Auto-generated method stub
		return this.strPassword;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#getUsername()
	 */
	public String getUsername() {
		// TODO Auto-generated method stub
		return this.strUsername;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#setPassword()
	 */
	public void setPassword(final String strPassword) {
		// TODO Auto-generated method stub
		this.strPassword = strPassword;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#setUsername()
	 */
	public void setUsername(final String strUsername) {
		// TODO Auto-generated method stub
		this.strUsername = strUsername;
	}

	/**
	 * @return the uriTokenType
	 */
	public java.net.URI getTokenType()
	{
		return this.uriTokenType;
	}

	public org.eclipse.higgins.sts.api.IElement getAsElement() throws Exception
	{
		String strToken = "<wsse:UsernameToken xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\">"
			+ "<wsse:Username>"
			+ this.strUsername 
			+ "</wsse:Username>"
			+ "<wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">"
			+ this.strPassword
			+ "</wsse:Password>"
			+ "</wsse:UsernameToken>";
		org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
		elemToken.set(strToken);
		return elemToken;
	}
}
