/**
 * 
 */
package org.eclipse.higgins.sts.utilities;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;

/**
 * @author mikemci
 *
 */
public class KeyGenHelper
{
	static String strCertificate =
		"-----BEGIN CERTIFICATE-----\n"
		+ "MIIG/TCCBOWgAwIBAgIJAN3IcKUH3duiMA0GCSqGSIb3DQEBBQUAMIGvMQswCQYD"
		+ "VQQGEwJDSDEPMA0GA1UECBMGWnVyaWNoMQ8wDQYDVQQHEwZadXJpY2gxITAfBgNV"
		+ "BAoTGEFiaGlDZXJ0aWZpY2F0ZUF1dGhvcml0eTEVMBMGA1UECxMMRmlyc3RUeXBl"
		+ "IENBMSEwHwYDVQQDExhBYmhpQ2VydGlmaWNhdGVBdXRob3JpdHkxITAfBgkqhkiG"
		+ "9w0BCQEWEmFic0B6dXJpY2guaWJtLmNvbTAeFw0wNjA5MTIwODUyMDdaFw0wNzA5"
		+ "MTIwODUyMDdaMIGvMQswCQYDVQQGEwJDSDEPMA0GA1UECBMGWnVyaWNoMQ8wDQYD"
		+ "VQQHEwZadXJpY2gxITAfBgNVBAoTGEFiaGlDZXJ0aWZpY2F0ZUF1dGhvcml0eTEV"
		+ "MBMGA1UECxMMRmlyc3RUeXBlIENBMSEwHwYDVQQDExhBYmhpQ2VydGlmaWNhdGVB"
		+ "dXRob3JpdHkxITAfBgkqhkiG9w0BCQEWEmFic0B6dXJpY2guaWJtLmNvbTCCAiIw"
		+ "DQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMfmyWITNeZRnyy7Qexu25rlN/3X"
		+ "rjKvyggulRT32B+yp1aFzSFWxqFFaoTyvXDgfxQEQjNUs75Z3hDxev9ekDwtFWEI"
		+ "qheZvlVsf8YL3ITR+7+A51hQrx6UV8Zi6Hz8+EjIXCqkIxs2UF2hL7XOXzKxKl53"
		+ "/5cmKNMlrLj5R5SY6fpj+8sDQ8PIgrWt931xhiGNeEnYO8gG+8ru+PxeiPhE38LJ"
		+ "Jo6ry8jvVJ3j06KJeZgPFIJVpvPbXEVheIN3SqQ5dW9pkNYt/P7rQuLM8MnnwNU2"
		+ "9Nn4yKIt6RsfkPqJGEgRz94/h2/GzBH1iO3dAbS3Lewer/rIoagcoaCu8HAJo07b"
		+ "UPn95LYNbkRideIBDBaEkBAYDtXdtTSdUv1eejTzpMsRWsIypwtJMMA9QuM+Pysy"
		+ "pFfGhLlIscrQ4fK3xf+Erbxn+EzYdUu5ILi7SKBJtzmUyv77e15wlRbhA9zTcGOX"
		+ "x+TdF7VXg8u0LDBLqqJ6IKFrp8vfCvXYqXXmJhHZzNyGhzn2m16g5eWldwBRo2ke"
		+ "1arbfOLwtDSvQwcxV9Edbfr5/8Vlgcb5By1/cB1UMyl8C02OFv/3ynle7/ewn8gr"
		+ "8uijWAUr90PMMKZpPezmR7Ua5F8HbkyGDzPDv2uiEUFJinYbjajkkE8PpthkE6ez"
		+ "erHCebmVqshrqKpZAgMBAAGjggEYMIIBFDAdBgNVHQ4EFgQUmMvEgKmY0cCODIBL"
		+ "0AF8L7w9cGIwgeQGA1UdIwSB3DCB2YAUmMvEgKmY0cCODIBL0AF8L7w9cGKhgbWk"
		+ "gbIwga8xCzAJBgNVBAYTAkNIMQ8wDQYDVQQIEwZadXJpY2gxDzANBgNVBAcTBlp1"
		+ "cmljaDEhMB8GA1UEChMYQWJoaUNlcnRpZmljYXRlQXV0aG9yaXR5MRUwEwYDVQQL"
		+ "EwxGaXJzdFR5cGUgQ0ExITAfBgNVBAMTGEFiaGlDZXJ0aWZpY2F0ZUF1dGhvcml0"
		+ "eTEhMB8GCSqGSIb3DQEJARYSYWJzQHp1cmljaC5pYm0uY29tggkA3chwpQfd26Iw"
		+ "DAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAgEAMYpfTZfm51yvJ680N9X6"
		+ "2YkzKJ+8Q3ecuRo1DVK31NIJZIQscYSzT76agkvypnCo53k6m3Ep2kyP+7kt2lO+"
		+ "CDp+FSwWPiWtYLidh7wVi/nze562r/O3Vu1FxMAsZuzD07OYhnwKMZHIOp5bkH9D"
		+ "i5VtJLXg4hypnmaC43ybcxUMx0ko1W4TLtnH/lnPPt/uSPsym+aZVNiNwbl+Vay5"
		+ "uWj8IGp9jrt4wfml2h9y/kH/TLp4zZ3KxKy+ZOPCgyGCCEBVw25vYLdfnXlNfI/o"
		+ "oVYNAzEDfrbKgBYg9hZAij01sCDb60ms8wy8FupKLOQgDBTu8GmRvVmpH1xHFIaW"
		+ "aEoc2Fvbtoj4iHxYYXpbk19kJ74DlNQPp26UgQ4kJm0ZICY5cKrLeh8L8FZQ4WQA"
		+ "PibnLSUzteIO9dqbzJWW9AD1MlOPYWLLRXed+SVN88/MWeaZCw/QBokPqd/LpAYI"
		+ "TcQzctGykD2Dfy8pLybIyyiv2wFqV177/gp4hsJKKCwaO32JqaKWRlQhA4+J2IaD"
		+ "grgTjN0l6gNnWvprqxfpKWxFMiutti195LzD4zNXSwlmocqnv6TeC0YlH8SUX/vy"
		+ "+oUrU+MuCUAwxcieBpyD2JQExuPMj7R+3Tt1uynlG8uJcrQ1Tjv4SXz0whKK14Au"
		+ "CBAziAEMkgFsqSR/MuY+xuM="
		+ "\n-----END CERTIFICATE-----\n";
	/*
	static String strCertificate =
		"-----BEGIN CERTIFICATE-----\n"
		+"MIIDwTCCAqmgAwIBAgIQeVRoElXn3LxES2LMO/1VhDANBgkqhkiG9w0BAQUFADAU"
		+"MRIwEAYDVQQDEwlBZGF0dW0xMDAwIBcNMDYwNTIzMDIzOTM1WhgPMjEwNjA1MjMw"
		+"MjQ5MTRaMBQxEjAQBgNVBAMTCUFkYXR1bTEwMDCCASIwDQYJKoZIhvcNAQEBBQAD"
		+"ggEPADCCAQoCggEBAKMIEK5kPYqoBwmYyJQnPamYkM5ItS9JpuBfl5Uo6+etUo+w"
		+"JymBFI2UpAYZcasdnZKo1jQixTyNeLVSQst6bnEYKBE7APrUXhGG3SyjvWuktTLR"
		+"/ZAO7Dyxxs5UugXd66Q3n5I2Gu29xn95YyeSo9THuPyaApjBrmpgdTwhkcnD2mBg"
		+"8Y650fp34y4PJ0gsG7i/WIQJWpDqHY0g4wl5IDOcDd1n69rK7NEyYIrcvzpO5dL0"
		+"srXQbBvPSbB8XJTdOOeL9AeT/CRijc077lcIwcCyNMtBf6Ldiei/w+UycOryF31T"
		+"O8/RtnkCxi1ZeOfJ18JCbd5+yQenVVrvxkvGLXcCAwEAAaOCAQswggEHMBMGCSsG"
		+"AQQBgjcUAgQGHgQAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB0G"
		+"A1UdDgQWBBQ4hLJvjtcbm7DZVRK00RS603JKkDCBoAYDVR0fBIGYMIGVMIGSoIGP"
		+"oIGMhkNodHRwOi8vdGhvbi10ZXN0MS5udGRldi5jb3JwLm1pY3Jvc29mdC5jb20v"
		+"Q2VydEVucm9sbC9BZGF0dW0xMDAuY3JshkVmaWxlOi8vXFx0aG9uLXRlc3QxLm50"
		+"ZGV2LmNvcnAubWljcm9zb2Z0LmNvbVxDZXJ0RW5yb2xsXEFkYXR1bTEwMC5jcmww"
		+"EAYJKwYBBAGCNxUBBAMCAQAwDQYJKoZIhvcNAQEFBQADggEBAFGwFjW15Rlj1n0E"
		+"+8xNxyH5yX5nRpT0E+xDyiWie2wNRaq8HAKaHwdK0Hs9D13jAtMRmbApT+GdF+Jw"
		+"2zfIiYPlRGiPJ010OcSs/k9/fwx61X++NppGtsDRupU51qXUSVkP51Ct3JeoIpou"
		+"MC8RB7D3fue5W1tmJg/TbyEF2Oe4Ruc4HB4X5wKsYGcQguEoVeniKu6JkGRRFbDT"
		+"x8LfOp760aDKSZn3p3FUlesQFG2sEgDeIm0F3sQz6xbIc0Uiq1oJQUN/r8wqev59"
		+"fLWVpC8zeamSZXNWDkQSGdRIC2VfotWGcTtWa/3YP04BRgZmcYYED/vExgtzLCvA"
		+"HAloAHE="
		+"\n-----END CERTIFICATE-----\n";
	*/
	
    public KeyGenHelper()
    {
    }

    /*
    public static void main(String args[])
        throws Exception
    {
        KeyGenHelper kgh = new KeyGenHelper();
        kgh.Run();
    }
    */

    static String byteArrayToHexString(byte in[])
    {
        byte ch = 0;
        if(in == null || in.length <= 0)
            return null;
        String pseudo[] = {
            "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", 
            "A", "B", "C", "D", "E", "F"
        };
        StringBuffer out = new StringBuffer(in.length * 2);
        out.append("(");
        for(int i = 0; i < in.length; i++)
        {
            if(i != 0)
                out.append(", ");
            out.append("(byte)0x");
            ch = (byte)(in[i] & 0xf0);
            ch >>>= 4;
            ch &= 0xf;
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xf);
            out.append(pseudo[ch]);
        }

        out.append(")");
        String rslt = new String(out);
        return rslt;
    }

    static public String ppidToFriendly(byte ppid[])
        throws Exception
    {
        System.out.println("PPID Bytes: " + byteArrayToHexString(ppid));
    	MessageDigest mdSha1 = MessageDigest.getInstance("SHA-1");
        byte hashId[] = mdSha1.digest(ppid);
        System.out.println("HashId Bytes: " + byteArrayToHexString(hashId));
        StringBuffer out = new StringBuffer(12);
        byte byteNum[] = new byte[1];
        BigInteger bi32 = new BigInteger("32");
        for(int i = 0; i < 10; i++)
        {
            byteNum[0] = hashId[i];
            BigInteger value = new BigInteger(1, byteNum);
            value = value.mod(bi32);
            if(3 == i || 7 == i)
                out.append("-");
            out.append(pseudo[value.intValue()]);
        }

        return new String(out);
    }

    /*
    static public void Run()
        throws Exception
    {
    	org.eclipse.higgins.sts.
        String strCardId = "urn:uuid:1ac93452-bcb5-4f4d-8a86-1e26c97c032f";

        SSLSecurityProvider.AllowUntrustedSSL();
        SocketFactory sslSocketFactory = SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket();
        socket.connect(endpoint);
        X509Certificate chain[] = socket.getSession().getPeerCertificateChain();
        socket.close();

		final java.io.ByteArrayInputStream streamCertificate = new java.io.ByteArrayInputStream
			(strCertificate.getBytes());
		final java.security.cert.CertificateFactory certificateFactory = java.security.cert.CertificateFactory.getInstance
			("X.509");		
		final java.security.cert.X509Certificate certRP = (java.security.cert.X509Certificate)certificateFactory.generateCertificate
			(streamCertificate);
		java.security.cert.X509Certificate [] chain = new java.security.cert.X509Certificate[1];
		chain[0] = certRP;

        byte rpIdentifier[] = generateRPIdentifier(chain);
        byte ppid[] = generatePPID(strCardId, rpIdentifier);
        System.out.println("PPID: " + Base64.encode(ppid));
        String ppidFriendly = ppidToFriendly(ppid);
        System.out.println("Friendly PPID: " + ppidFriendly);
        KeyPair kp = generateRSAKeyPair(masterKey, rpIdentifier, 2048);
    }
    */

    static public byte[] generatePPID
    	(java.net.URI uriCardId,
    	byte [] rpIdentifier)
        throws Exception
    {
    	MessageDigest mdSha256 = MessageDigest.getInstance("SHA-256");
        byte [] cardId = uriCardId.toString().getBytes("UTF-16LE");
        byte [] canonicalCardId = mdSha256.digest(cardId);
        ByteBuffer bbInput = ByteBuffer.allocate(canonicalCardId.length + rpIdentifier.length);
        bbInput.put(rpIdentifier);
        bbInput.put(canonicalCardId);
        mdSha256.reset();
        return mdSha256.digest(bbInput.array());
    }
    
    static public java.util.Map getOrganizationalIdentifierAttributes
    	(java.security.cert.X509Certificate cert)
    {
    	javax.security.auth.x500.X500Principal principal = cert.getSubjectX500Principal();
    	String strName = principal.getName(javax.security.auth.x500.X500Principal.RFC1779);
    	System.out.println("Name: " + strName);
    	java.util.Map mapDNAttributes = new java.util.Hashtable();
    	StringBuffer sbDN = new StringBuffer(strName);
    	String strAttribute= null;
    	int nPrev = 0;
    	int nNext = sbDN.indexOf(",");
    	while (-1 != nNext)
    	{
    		strAttribute = sbDN.substring(nPrev, nNext);
        	int nEqual = strAttribute.indexOf("=");
        	String strAttributeName = strAttribute.substring(0, nEqual);
        	strAttributeName = strAttributeName.trim();
        	String strAttributeValue = strAttribute.substring(nEqual + 1);
            System.out.println("Adding Attribute: " + strAttributeName + " Value: " + strAttributeValue);
        	mapDNAttributes.put(strAttributeName, strAttributeValue);      		
    		nPrev = nNext + 1;
    		nNext = sbDN.indexOf(",", nPrev);
    	}
    	strAttribute = sbDN.substring(nPrev);
    	int nEqual = strAttribute.indexOf("=");
    	String strAttributeName = strAttribute.substring(0, nEqual);
    	strAttributeName = strAttributeName.trim();
    	String strAttributeValue = strAttribute.substring(nEqual + 1);
        System.out.println("Adding Attribute: " + strAttributeName + " Value: " + strAttributeValue);
    	mapDNAttributes.put(strAttributeName, strAttributeValue);      		
    	return mapDNAttributes;
    }
    
    static public String getOrgIdString
    	(java.util.Map mapOrgIdAttributes)
    {
    	String strValue = (String)mapOrgIdAttributes.get("O");
    	if (null == strValue) strValue = "";
    	String strResult = "|O=\"" + strValue + "\"";
    	strValue = (String)mapOrgIdAttributes.get("L");
    	if (null == strValue) strValue = "";
    	strResult += "|L=\"" + strValue + "\"";
    	strValue = (String)mapOrgIdAttributes.get("S");
    	if (null == strValue) strValue = "";
    	strResult += "|S=\"" + strValue + "\"";
    	strValue = (String)mapOrgIdAttributes.get("C");
    	if (null == strValue) strValue = "";
    	strResult += "|C=\"" + strValue + "\"|";
    	System.out.println("OrgIdString: " + strResult);
    	return strResult;
    }

    static public byte[] generateRPIdentifier
    	(java.security.cert.X509Certificate [] chain)
        throws Exception
    {
        java.security.cert.X509Certificate cert = chain[0];
    	MessageDigest mdSha256 = MessageDigest.getInstance("SHA-256");
    	java.util.Map mapOIAs = getOrganizationalIdentifierAttributes(cert);
    	if (0 == mapOIAs.size()) // case 3
    	{
            java.security.PublicKey pk = cert.getPublicKey();
            RSAPublicKey rsaPk = (RSAPublicKey)pk;
            byte publicKey [] = rsaPk.getEncoded();
            ByteBuffer bbPk = ByteBuffer.allocate(publicKey.length - 22);
            bbPk.put(publicKey, 22, publicKey.length - 22);
            return mdSha256.digest(bbPk.array());
    	}
    	else
    	{
    		String strOrgIdString = getOrgIdString(mapOIAs);
            return mdSha256.digest(strOrgIdString.getBytes("UTF-16LE"));
    	}
    }

    static void copyByteBuffer
    	(ByteBuffer bbSource, 
    	int nSourceOffset,
    	byte bDestination[],
    	int nDestinationOffset,
    	int numberOfBytes)
    {
        int nDestination = nDestinationOffset;
        for(int nSource = nSourceOffset; nSource < numberOfBytes + nSourceOffset; nSource++)
            bDestination[nDestination++] = bbSource.get(nSource);
    }

    static public KeyPair generateRSAKeyPair
    	(org.eclipse.higgins.sts.spi.IBase64Extension base64,
    	byte masterKey[],
    	byte relyingPartyIdentifier[],
    	int nKeyBitLength)
        throws Exception
    {
        int nRounds = 0;
        int nRoundInputByteLength = relyingPartyIdentifier.length + relyingPartyIdentifier.length + 4;
        if(1024 == nKeyBitLength)
            nRounds = 10;
        else
        if(2048 == nKeyBitLength)
            nRounds = 16;
        else
            throw new Exception("Invalid Key Size Requested");
        System.out.println("Section 8.4.1 Step 2 Processing...");
        ByteBuffer bbH[] = new ByteBuffer[nRounds];
        for(int i = 0; i < nRounds; i++)
        {
            ByteBuffer bbInput = ByteBuffer.allocate(nRoundInputByteLength);
            bbInput.put(masterKey);
            bbInput.put(relyingPartyIdentifier);
            bbInput.putInt(i);
        	MessageDigest mdSha1 = MessageDigest.getInstance("SHA-1");
            byte Hn[] = mdSha1.digest(bbInput.array());
            bbH[i] = ByteBuffer.allocate(Hn.length);
            bbH[i].put(Hn);
            System.out.println("H[" + i + "] " + byteArrayToHexString(bbH[i].array()));
        }

        System.out.println("Section 8.4.1 Step 3 Processing...");
        byte Xp1[] = new byte[14];
        copyByteBuffer(bbH[0], 6, Xp1, 0, 14);
        System.out.println("Xp1 " + byteArrayToHexString(Xp1));
        byte Xp2[] = new byte[14];
        copyByteBuffer(bbH[1], 6, Xp2, 0, 14);
        System.out.println("Xp2 " + byteArrayToHexString(Xp2));
        byte Xq1[] = new byte[14];
        copyByteBuffer(bbH[2], 6, Xq1, 0, 14);
        System.out.println("Xq1 " + byteArrayToHexString(Xq1));
        byte Xq2[] = new byte[14];
        copyByteBuffer(bbH[3], 6, Xq2, 0, 14);
        System.out.println("Xq2 " + byteArrayToHexString(Xq2));
        byte Xp[] = (byte[])null;
        byte Xq[] = (byte[])null;
        if(1024 == nKeyBitLength)
        {
            Xp = new byte[64];
            copyByteBuffer(bbH[4], 0, Xp, 0, 20);
            copyByteBuffer(bbH[5], 0, Xp, 20, 20);
            copyByteBuffer(bbH[6], 0, Xp, 40, 20);
            copyByteBuffer(bbH[0], 0, Xp, 60, 4);
            Xq = new byte[64];
            copyByteBuffer(bbH[7], 0, Xq, 0, 20);
            copyByteBuffer(bbH[8], 0, Xq, 20, 20);
            copyByteBuffer(bbH[9], 0, Xq, 40, 20);
            copyByteBuffer(bbH[1], 0, Xq, 60, 4);
        } else
        {
            Xp = new byte[128];
            copyByteBuffer(bbH[4], 0, Xp, 0, 20);
            copyByteBuffer(bbH[5], 0, Xp, 20, 20);
            copyByteBuffer(bbH[6], 0, Xp, 40, 20);
            copyByteBuffer(bbH[0], 0, Xp, 60, 4);
            copyByteBuffer(bbH[10], 0, Xp, 64, 20);
            copyByteBuffer(bbH[11], 0, Xp, 84, 20);
            copyByteBuffer(bbH[12], 0, Xp, 104, 20);
            copyByteBuffer(bbH[2], 0, Xp, 124, 4);
            Xq = new byte[128];
            copyByteBuffer(bbH[7], 0, Xq, 0, 20);
            copyByteBuffer(bbH[8], 0, Xq, 20, 20);
            copyByteBuffer(bbH[9], 0, Xq, 40, 20);
            copyByteBuffer(bbH[1], 0, Xq, 60, 4);
            copyByteBuffer(bbH[13], 0, Xq, 64, 20);
            copyByteBuffer(bbH[14], 0, Xq, 84, 20);
            copyByteBuffer(bbH[15], 0, Xq, 104, 20);
            copyByteBuffer(bbH[3], 0, Xq, 124, 4);
        }
        System.out.println("Xp " + byteArrayToHexString(Xp));
        System.out.println("Xq " + byteArrayToHexString(Xq));
        System.out.println("Section 8.4.1 Step 4 Processing...");
        Xp1[1] |= 0x10;
        Xp2[1] |= 0x10;
        Xq1[1] |= 0x10;
        Xq2[1] |= 0x10;
        System.out.println("Xp1 " + byteArrayToHexString(Xp1));
        System.out.println("Xp2 " + byteArrayToHexString(Xp2));
        System.out.println("Xq1 " + byteArrayToHexString(Xq1));
        System.out.println("Xq2 " + byteArrayToHexString(Xq2));
        System.out.println("Section 8.4.1 Step 5 Processing...");
        Xp[0] |= 0xc0;
        Xq[0] |= 0xc0;
        System.out.println("Xp " + byteArrayToHexString(Xp));
        System.out.println("Xq " + byteArrayToHexString(Xq));
        System.out.println("Section 8.4.1 Step 6 Processing...");
        X931KeyGenerator kpg = new X931KeyGenerator(Xp1, Xp2, Xq1, Xq2, Xp, Xq);
        RSAKeyGenParameterSpec kpgParams = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        KeyPair kp = kpg.GenerateKeyPair(kpgParams);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)kp.getPublic();
        BigInteger biModulus = rsaPublicKey.getModulus();
        String strModulus = base64.encode(biModulus);
        strModulus = XMLHelper.stripNewLinesFromString(strModulus);
        BigInteger biExponent = rsaPublicKey.getPublicExponent();
        String strExponent = base64.encode(biExponent);
        strExponent = XMLHelper.stripNewLinesFromString(strExponent);
        System.out.println("Modulus: " + strModulus);
        System.out.println("Exponent: " + strExponent);
        return kp;
    }

    static private String pseudo[] = {
        "Q", "L", "2", "3", "4", "5", "6", "7", "8", "9", 
        "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", 
        "M", "N", "P", "R", "S", "T", "U", "V", "W", "X", 
        "Y", "Z"
	    };
}
