/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

import java.util.List;

import org.eclipse.higgins.sts.api.ISecurityInformation;

/**
 * @author mikemci
 *
 */
public class SecurityInformation
	implements ISecurityInformation
{
	private java.util.List listSecurityTokens = new java.util.ArrayList();
	
	private org.eclipse.higgins.sts.api.IBinarySecurityToken binarySecurityToken = null;
	
	private org.eclipse.higgins.sts.api.IUsernameToken usernameToken = null;
	
	private org.eclipse.higgins.sts.api.ITimestamp timestamp = null;
	
	private String strModulus = null;
	
	private String strExponent = null;
	
	private String strPPID = null;

	/**
	 * @return the strPPID
	 */
	public String getPrivatePersonalIdentifier() {
		return this.strPPID;
	}

	/**
	 * @param strPPID the strPPID to set
	 */
	public void setPrivatePersonalIdentifier(final String strPPID) {
		this.strPPID = strPPID;
	}

	/**
	 * @return the strExponent
	 */
	public String getExponent() {
		return this.strExponent;
	}

	/**
	 * @param strExponent the strExponent to set
	 */
	public void setExponent(final String strExponent) {
		this.strExponent = strExponent;
	}

	/**
	 * @return the strModulus
	 */
	public String getModulus() {
		return this.strModulus;
	}

	/**
	 * @param strModulus the strModulus to set
	 */
	public void setModulus(final String strModulus) {
		this.strModulus = strModulus;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#getUsernameToken()
	 */
	public org.eclipse.higgins.sts.api.IUsernameToken getUsernameToken()
	{
		// TODO Auto-generated method stub
		return this.usernameToken;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#getTimestamp()
	 */
	public org.eclipse.higgins.sts.api.ITimestamp getTimestamp()
	{
		// TODO Auto-generated method stub
		return this.timestamp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#setUsernameToken()
	 */
	public void setUsernameToken(final org.eclipse.higgins.sts.api.IUsernameToken usernameToken)
	{
		// TODO Auto-generated method stub
		this.usernameToken = usernameToken;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#setTimestamp()
	 */
	public void setTimestamp(final org.eclipse.higgins.sts.api.ITimestamp timestamp) {
		// TODO Auto-generated method stub
		this.timestamp = timestamp;
	}

	public org.eclipse.higgins.sts.api.IBinarySecurityToken getBinarySecurityToken() {
		return this.binarySecurityToken;
	}

	public void setBinarySecurityToken
		(final org.eclipse.higgins.sts.api.IBinarySecurityToken binarySecurityToken) {
		this.binarySecurityToken = binarySecurityToken;
	}

	public void addSecurityToken(final org.eclipse.higgins.sts.api.IElement elemToken)
	{
		listSecurityTokens.add(elemToken);
		
	}

	public List getSecurityTokenList() {
		return listSecurityTokens;
	}
}
