/**
 * 
 */
package org.eclipse.higgins.sts.common;

import java.net.URI;

import org.eclipse.higgins.sts.api.IBinarySecurityToken;

/**
 * @author mikemci
 *
 */
public class BinarySecurityToken implements IBinarySecurityToken
{
	URI uriEncodingType = null;
	
	URI uriValueType = null;
	
	URI uriTokenType = null;
	
	String strValue = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#getEncodingType()
	 */
	public URI getEncodingType()
	{
		return uriEncodingType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#getValueType()
	 */
	public URI getValueType()
	{
		return uriValueType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#setEncodingType(java.net.URI)
	 */
	public void setEncodingType(URI uriEncodingType)
	{
		this.uriEncodingType = uriEncodingType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.IBinarySecurityToken#setValueType(java.net.URI)
	 */
	public void setValueType(URI uriValueType)
	{
		this.uriValueType = uriValueType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISecurityToken#getTokenType()
	 */
	public URI getTokenType()
	{
		return this.uriTokenType;
	}
	
	public void setEncodedValue(String strValue)
	{
		this.strValue = strValue;
	}
	
	public String getEncodedValue()
	{
		return this.strValue;
	}

	public org.eclipse.higgins.sts.api.IElement getAsElement() throws Exception
	{
		String strToken = "<wsse:BinarySecurityToken "
			+ "xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" "
			+ "ValueType=\"" + this.uriValueType.toString() + "\" "
			+ "EncodingType=\"" + this.uriEncodingType.toString() + "\">"
			+ this.strValue
			+ "</wsse:BinarySecurityToken>";
		org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
		elemToken.set(strToken);
		return elemToken;
	}
}
