/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * Wraps commons logging to protect against exceptions when called due to logging turned off
 * 
 * @author mikemci at us dot ibm dot com
 */
public class LogHelper
{
	private org.apache.commons.logging.Log log = null;
	
	public LogHelper
		(final String strClass)
	{
		try
		{
			this.log = org.apache.commons.logging.LogFactory.getLog(strClass);
		}
		catch (final Exception e)
		{
			this.log = null;
		}
	}
	
	public LogHelper
		(final org.apache.commons.logging.Log log)
	{
		this.log = log;
	}

	public org.apache.commons.logging.Log getLog()
	{
		return this.log;
	}
	
	public void trace
		(final Object object)
	{
		if (null != this.log)
		{
			try
			{
				this.log.trace(object);
			}
			catch (final Exception e)
			{
				this.log = null;
			}
		}
	}
	
	public void debug
		(final Object object)
	{
		if (null != this.log)
		{
			try
			{
				this.log.debug(object);
			}
			catch (final Exception e)
			{
				this.log = null;
			}
		}
	}
	
	public void info
		(final Object object)
	{
		if (null != this.log)
		{
			try
			{
				this.log.info(object);
			}
			catch (final Exception e)
			{
				this.log = null;
			}
		}
	}

	public void error
		(final Object object)
	{
		if (null != this.log)
		{
			try
			{
				this.log.error(object);
			}
			catch (final Exception e)
			{
				this.log = null;
			}
		}
	}
	
	public void warn
		(final Object object)
	{
		if (null != this.log)
		{
			try
			{
				this.log.warn(object);
			}
			catch (final Exception e)
			{
				this.log = null;
			}
		}
	}
	
	public void fatal
		(final Object object)
	{
		if (null != this.log)
		{
			try
			{
				this.log.fatal(object);
			}
			catch (final Exception e)
			{
				this.log = null;
			}
		}			
	}
}
