package org.eclipse.higgins.sts.utilities;

import java.security.*;

// Referenced classes of package org.eclipse.higgins.sts.utilities:
//            SSLTrustManagerFactory

public final class SSLSecurityProvider extends Provider
{

    public static void AllowUntrustedSSL()
    {
        if (Security.getProvider("Dummy") == null)
        {
            Security.insertProviderAt
            	(new SSLSecurityProvider(),
            	2);
            Security.setProperty
            	("ssl.TrustManagerFactory.algorithm",
            	SSLTrustManagerFactory.getAlgorithm());
        }
    }

    public SSLSecurityProvider()
    {
        super("Dummy", 1.0D, "");
        AccessController.doPrivileged(new PrivilegedAction() {

            public Object run()
            {
            	put
            		("SSLTrustManagerFactory." + SSLTrustManagerFactory.getAlgorithm(),
            		SSLTrustManagerFactory.class.getName());
            	return null;
            }

        });
    }

    private static final long serialVersionUID = 1L;
}
