/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.common;

import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISAMLToken;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.utilities.DateHelper;

public abstract class SAMLToken
implements ISAMLToken {
    private QName qnameIssueInstant = new QName("IssueInstant");
    private QName qnameIssuer = new QName("Issuer");
    protected OMElement omAssertion = null;
    protected OMElement omAdvice = null;
    protected OMElement omAttributeStatement = null;
    protected OMElement omAuthenticationStatement = null;
    protected OMElement omAuthorizationDecisionStatement = null;
    protected OMElement omConditions = null;
    protected OMElement omSignature = null;
    protected OMElement omStatement = null;
    protected OMElement omSubjectStatement = null;
    private URI uriSAMLAssertion = URI.create("urn:oasis:names:tc:SAML:1.0:assertion");
    private QName qnameAdvice = new QName(this.uriSAMLAssertion.toString(), "Advice");
    private QName qnameAttributeStatement = new QName(this.uriSAMLAssertion.toString(), "AttributeStatement");
    private QName qnameAuthenticationStatement = new QName(this.uriSAMLAssertion.toString(), "AuthenticationStatement");
    private QName qnameAuthorizationDecisionStatement = new QName(this.uriSAMLAssertion.toString(), "AuthorizationDecisionStatement");
    private QName qnameConditions = new QName(this.uriSAMLAssertion.toString(), "Conditions");
    private QName qnameSignature = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    private QName qnameStatement = new QName(this.uriSAMLAssertion.toString(), "Statement");
    private QName qnameSubjectStatement = new QName(this.uriSAMLAssertion.toString(), "SubjectStatement");
    static /* synthetic */ Class class$0;

    protected abstract void createAssertion();

    public IElement getAdvice() throws Exception {
        Element elemAdvice = null;
        if (this.omAdvice != null) {
            elemAdvice = new Element();
            elemAdvice.set(this.omAdvice);
        }
        return elemAdvice;
    }

    public IElement getAttributeStatement() throws Exception {
        Element elemAttributeStatement = null;
        if (this.omAttributeStatement != null) {
            elemAttributeStatement = new Element();
            elemAttributeStatement.set(this.omAttributeStatement);
        }
        return elemAttributeStatement;
    }

    public IElement getAuthenticationStatement() throws Exception {
        Element elemAuthenticationStatement = null;
        if (this.omAuthenticationStatement != null) {
            elemAuthenticationStatement = new Element();
            elemAuthenticationStatement.set(this.omAuthenticationStatement);
        }
        return elemAuthenticationStatement;
    }

    public IElement getAuthorizationDecisionStatement() throws Exception {
        Element elemAuthorizationDecisionStatement = null;
        if (this.omAuthorizationDecisionStatement != null) {
            elemAuthorizationDecisionStatement = new Element();
            elemAuthorizationDecisionStatement.set(this.omAuthorizationDecisionStatement);
        }
        return elemAuthorizationDecisionStatement;
    }

    public IElement getConditions() throws Exception {
        Element elemConditions = null;
        if (this.omConditions != null) {
            elemConditions = new Element();
            elemConditions.set(this.omConditions);
        }
        return elemConditions;
    }

    public Date getIssueInstant() {
        Date dtIssueInstant = null;
        if (this.omAssertion != null) {
            String strIssueInstant = this.omAssertion.getAttributeValue(this.qnameIssueInstant);
            dtIssueInstant = DateHelper.getDateFromIso8601(strIssueInstant);
        }
        return dtIssueInstant;
    }

    public String getIssuer() {
        String strIssuer = null;
        if (this.omAssertion != null) {
            strIssuer = this.omAssertion.getAttributeValue(this.qnameIssuer);
        }
        return strIssuer;
    }

    public IElement getSignature() throws Exception {
        Element elemSignature = null;
        if (this.omSignature != null) {
            elemSignature = new Element();
            elemSignature.set(this.omSignature);
        }
        return elemSignature;
    }

    public IElement getStatement() throws Exception {
        Element elemStatement = null;
        if (this.omStatement != null) {
            elemStatement = new Element();
            elemStatement.set(this.omStatement);
        }
        return elemStatement;
    }

    public IElement getSubjectStatement() throws Exception {
        Element elemSubjectStatement = null;
        if (this.omSubjectStatement != null) {
            elemSubjectStatement = new Element();
            elemSubjectStatement.set(this.omSubjectStatement);
        }
        return elemSubjectStatement;
    }

    public void setAdvice(IElement elemAdvice) throws Exception {
        Class<?> clazz;
        if (this.omAdvice != null) {
            this.omAdvice.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omAdvice = (OMElement)elemAdvice.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omAdvice);
    }

    public void setAttributeStatement(IElement elemAttributeStatement) throws Exception {
        Class<?> clazz;
        if (this.omAttributeStatement != null) {
            this.omAttributeStatement.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omAttributeStatement = (OMElement)elemAttributeStatement.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omAttributeStatement);
    }

    public void setAuthenticationStatement(IElement elemAuthenticationStatement) throws Exception {
        Class<?> clazz;
        if (this.omAuthenticationStatement != null) {
            this.omAuthenticationStatement.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omAuthenticationStatement = (OMElement)elemAuthenticationStatement.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omAuthenticationStatement);
    }

    public void setAuthorizationDecisionStatement(IElement elemAuthorizationDecisionStatement) throws Exception {
        Class<?> clazz;
        if (this.omAuthorizationDecisionStatement != null) {
            this.omAuthorizationDecisionStatement.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omAuthorizationDecisionStatement = (OMElement)elemAuthorizationDecisionStatement.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omAuthorizationDecisionStatement);
    }

    public void setConditions(IElement elemConditions) throws Exception {
        Class<?> clazz;
        if (this.omConditions != null) {
            this.omConditions.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omConditions = (OMElement)elemConditions.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omConditions);
    }

    public void setIssueInstant(Date dtIssueInstant) {
        this.createAssertion();
        OMAttribute omIssueInstant = this.omAssertion.getAttribute(this.qnameIssueInstant);
        if (omIssueInstant == null) {
            omIssueInstant = this.omAssertion.addAttribute("IssueInstant", DateHelper.getIso8601Date(dtIssueInstant), null);
        } else {
            omIssueInstant.setAttributeValue(DateHelper.getIso8601Date(dtIssueInstant));
        }
    }

    public void setIssuer(String strIssuer) {
        this.createAssertion();
        OMAttribute omIssuer = this.omAssertion.getAttribute(this.qnameIssuer);
        if (omIssuer == null) {
            omIssuer = this.omAssertion.addAttribute("Issuer", strIssuer, null);
        } else {
            omIssuer.setAttributeValue(strIssuer);
        }
    }

    public void setSignature(IElement elemSignature) throws Exception {
        Class<?> clazz;
        if (this.omSignature != null) {
            this.omSignature.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omSignature = (OMElement)elemSignature.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omSignature);
    }

    public void setStatement(IElement elemStatement) throws Exception {
        Class<?> clazz;
        if (this.omStatement != null) {
            this.omStatement.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omStatement = (OMElement)elemStatement.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omStatement);
    }

    public void setSubjectStatement(IElement elemSubjectStatement) throws Exception {
        Class<?> clazz;
        if (this.omSubjectStatement != null) {
            this.omSubjectStatement.detach();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omSubjectStatement = (OMElement)elemSubjectStatement.getAs((Class)clazz);
        this.omAssertion.addChild((OMNode)this.omSubjectStatement);
    }

    public void fromElement(IElement element) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omAssertion = (OMElement)element.getAs((Class)clazz);
        if (this.omAssertion != null) {
            this.omAdvice = this.omAssertion.getFirstChildWithName(this.qnameAdvice);
            this.omAttributeStatement = this.omAssertion.getFirstChildWithName(this.qnameAttributeStatement);
            this.omAuthenticationStatement = this.omAssertion.getFirstChildWithName(this.qnameAuthenticationStatement);
            this.omAuthorizationDecisionStatement = this.omAssertion.getFirstChildWithName(this.qnameAuthorizationDecisionStatement);
            this.omConditions = this.omAssertion.getFirstChildWithName(this.qnameConditions);
            this.omSignature = this.omAssertion.getFirstChildWithName(this.qnameSignature);
            this.omStatement = this.omAssertion.getFirstChildWithName(this.qnameStatement);
            this.omSubjectStatement = this.omAssertion.getFirstChildWithName(this.qnameSubjectStatement);
        }
    }

    public IElement toElement() throws Exception {
        Element elemToken = new Element();
        elemToken.set(this.omAssertion);
        return elemToken;
    }
}

