/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.common;

import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ITimestamp;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.utilities.DateHelper;

public class Timestamp
implements ITimestamp {
    private OMElement omTimestamp = null;
    private OMElement omCreated = null;
    private OMElement omExpires = null;
    private URI uriWSSUtility = URI.create("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    private QName qnameCreated = new QName(this.uriWSSUtility.toString(), "Created");
    private QName qnameExpires = new QName(this.uriWSSUtility.toString(), "Expires");
    private QName qnameId = new QName(this.uriWSSUtility.toString(), "Id");
    private final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private final OMNamespace omWSSUtilityNamespace = this.omFactory.createOMNamespace(this.uriWSSUtility.toString(), "wsu");
    static /* synthetic */ Class class$0;

    private void createTimestamp() {
        if (this.omTimestamp == null) {
            this.omTimestamp = this.omFactory.createOMElement("Timestamp", this.omWSSUtilityNamespace);
        }
    }

    private void createCreated() {
        this.createTimestamp();
        if (this.omCreated == null) {
            this.omCreated = this.omFactory.createOMElement("Created", this.omWSSUtilityNamespace, (OMContainer)this.omTimestamp);
        }
    }

    private void createExpires() {
        this.createTimestamp();
        if (this.omExpires == null) {
            this.omExpires = this.omFactory.createOMElement("Expires", this.omWSSUtilityNamespace, (OMContainer)this.omTimestamp);
        }
    }

    public Date getCreated() {
        Date dtCreated = null;
        if (this.omCreated != null) {
            String strCreated = this.omCreated.getText();
            dtCreated = DateHelper.getDateFromIso8601(strCreated);
        }
        return dtCreated;
    }

    public Date getExpires() {
        Date dtExpires = null;
        if (this.omExpires != null) {
            String strExpires = this.omExpires.getText();
            dtExpires = DateHelper.getDateFromIso8601(strExpires);
        }
        return dtExpires;
    }

    public void setCreated(Date dtCreated) {
        this.createCreated();
        this.omCreated.setText(DateHelper.getIso8601Date(dtCreated));
    }

    public void setExpires(Date dtExpires) {
        this.createExpires();
        this.omExpires.setText(DateHelper.getIso8601Date(dtExpires));
    }

    public void fromElement(IElement element) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omTimestamp = (OMElement)element.getAs((Class)clazz);
        if (this.omTimestamp != null) {
            this.omCreated = this.omTimestamp.getFirstChildWithName(this.qnameCreated);
            this.omExpires = this.omTimestamp.getFirstChildWithName(this.qnameExpires);
            if (this.omTimestamp.getAttribute(this.qnameId) != null) {
                this.setId(this.omTimestamp.getAttributeValue(this.qnameId));
            }
        }
    }

    public IElement toElement() throws Exception {
        Element elemTimestamp = new Element();
        elemTimestamp.set(this.omTimestamp);
        return elemTimestamp;
    }

    public String getId() {
        return this.omTimestamp.getAttributeValue(this.qnameId);
    }

    public void setId(String strId) {
        this.omTimestamp.declareNamespace(this.omWSSUtilityNamespace);
        this.omTimestamp.addAttribute("Id", strId, this.omWSSUtilityNamespace);
    }
}

