/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.common;

import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IUsernameToken;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.utilities.DateHelper;

public class UsernameToken
implements IUsernameToken {
    private OMElement omUsernameToken = null;
    private OMElement omUsername = null;
    private OMElement omPassword = null;
    private OMElement omNonce = null;
    private OMElement omCreated = null;
    private URI uriWSSExtension = URI.create("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    private URI uriWSSUtility = URI.create("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    private QName qnameUsername = new QName(this.uriWSSExtension.toString(), "Username");
    private QName qnamePassword = new QName(this.uriWSSExtension.toString(), "Password");
    private QName qnameNonce = new QName(this.uriWSSExtension.toString(), "Nonce");
    private QName qnameCreated = new QName(this.uriWSSUtility.toString(), "Created");
    private final URI uriTokenType = URI.create("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
    private final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private final OMNamespace omWSSExtensionNamespace = this.omFactory.createOMNamespace(this.uriWSSExtension.toString(), "wsse");
    private final OMNamespace omWSSUtilityNamespace = this.omFactory.createOMNamespace(this.uriWSSUtility.toString(), "wsu");
    static /* synthetic */ Class class$0;

    private void createUsernameToken() {
        if (this.omUsernameToken == null) {
            this.omUsernameToken = this.omFactory.createOMElement("UsernameToken", this.omWSSExtensionNamespace);
        }
    }

    private void createUsername() {
        this.createUsernameToken();
        if (this.omUsername == null) {
            this.omUsername = this.omFactory.createOMElement("Username", this.omWSSExtensionNamespace, (OMContainer)this.omUsernameToken);
        }
    }

    private void createPassword() {
        this.createUsernameToken();
        if (this.omPassword == null) {
            this.omPassword = this.omFactory.createOMElement("Password", this.omWSSExtensionNamespace, (OMContainer)this.omUsernameToken);
            this.omPassword.addAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText", null);
        }
    }

    private void createNonce() {
        this.createUsernameToken();
        if (this.omNonce == null) {
            this.omNonce = this.omFactory.createOMElement("Nonce", this.omWSSExtensionNamespace, (OMContainer)this.omUsernameToken);
            this.omNonce.addAttribute("Encoding", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", null);
        }
    }

    private void createCreated() {
        this.createUsernameToken();
        if (this.omCreated == null) {
            this.omCreated = this.omFactory.createOMElement("Created", this.omWSSUtilityNamespace, (OMContainer)this.omUsernameToken);
        }
    }

    public String getUsername() {
        String strUsername = null;
        if (this.omUsername != null) {
            strUsername = this.omUsername.getText();
        }
        return strUsername;
    }

    public String getPassword() {
        String strPassword = null;
        if (this.omPassword != null) {
            strPassword = this.omPassword.getText();
        }
        return strPassword;
    }

    public String getNonce() {
        String strNonce = null;
        if (this.omNonce != null) {
            strNonce = this.omNonce.getText();
        }
        return strNonce;
    }

    public Date getCreated() {
        Date dtCreated = null;
        if (this.omCreated != null) {
            String strCreated = this.omCreated.getText();
            dtCreated = DateHelper.getDateFromIso8601(strCreated);
        }
        return dtCreated;
    }

    public URI getTokenType() {
        return this.uriTokenType;
    }

    public void setUsername(String strUsername) {
        this.createUsername();
        this.omUsername.setText(strUsername);
    }

    public void setPassword(String strPassword) {
        this.createPassword();
        this.omPassword.setText(strPassword);
    }

    public void setNonce(String strNonce) {
        this.createNonce();
        this.omNonce.setText(strNonce);
    }

    public void setCreated(Date dtCreated) {
        this.createCreated();
        this.omCreated.setText(DateHelper.getIso8601Date(dtCreated));
    }

    public IElement toElement() throws Exception {
        Element elemToken = new Element();
        elemToken.set(this.omUsernameToken);
        return elemToken;
    }

    public void fromElement(IElement element) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axiom.om.OMElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.omUsernameToken = (OMElement)element.getAs((Class)clazz);
        if (this.omUsernameToken != null) {
            this.omUsername = this.omUsernameToken.getFirstChildWithName(this.qnameUsername);
            this.omPassword = this.omUsernameToken.getFirstChildWithName(this.qnamePassword);
            this.omNonce = this.omUsernameToken.getFirstChildWithName(this.qnameNonce);
            this.omCreated = this.omUsernameToken.getFirstChildWithName(this.qnameCreated);
        }
    }
}

