/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * @author mikemci
 *
 */
public class Configuration implements org.eclipse.higgins.configuration.api.IConfigurationHandler
{
	public static org.eclipse.higgins.configuration.xml.ConfigurationHandler handler = new org.eclipse.higgins.configuration.xml.ConfigurationHandler();

	/***
	 * Set pathname to directory that contains configuration files.
	 */
	public void setConfigurationBase(String str)
	{
		handler.setConfigurationBase(str);
	}
	
	public void setFileName(String strFile)
	{
		handler.setFileName(strFile);
	}
	
	/***
	 * Use properties in mapConfigurationSettings to read/create configuration map.
	 * Should be implemented as synchronized. 
	 * @return TRUE if configuration is successful, FALSE otherwise.
	 */
	public synchronized boolean configure(java.util.Map mapConfigurationSettings)
		throws Exception
	{
		//bar
		// should really be doing this in doPrivileged block
		if (mapConfigurationSettings == null) { // we need to know SOMETHING
			String configS = System.getProperty("org.eclipse.higgins.sts.conf");
			if (configS != null) {
				handler.setConfigurationBase(configS);
				String configFileS = System.getProperty("org.eclipse.higgins.sts.conf.file");
				if (configFileS != null)
					handler.setFileName(configFileS);
			}	
		}
		//bar
		return handler.configure(mapConfigurationSettings);
	}
	
	/***
	 * Return settings created by configure call, or null if not yet configured.
	 */
	public java.util.Map getSettings()
		throws Exception
	{
		return handler.getSettings();
	}
}
