/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateHelper {
    public static final String COMPLETE_DATE_HOURS_MINUTES_SECS_MSECS_Z = "yyyy-MM-dd'T'HH':'mm':'ss'.'S'Z'";

    public static String getIso8601Date(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(COMPLETE_DATE_HOURS_MINUTES_SECS_MSECS_Z);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    public static String getIso8601Date() {
        return DateHelper.getIso8601Date(null);
    }

    public static Date getDateFromIso8601(String iso8601) {
        Date result = null;
        if (iso8601 == null || iso8601.length() < 4) {
            return result;
        }
        int len = iso8601.length();
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        String timeZone = null;
        if (len == 4) {
            year = DateHelper.parseToInt(iso8601.substring(0, 4), 0);
        } else if (len == 7) {
            year = DateHelper.parseToInt(iso8601.substring(0, 4), 0);
            month = DateHelper.parseToInt(iso8601.substring(5, 7), 0);
        } else if (len == 10) {
            year = DateHelper.parseToInt(iso8601.substring(0, 4), 0);
            month = DateHelper.parseToInt(iso8601.substring(5, 7), 0);
            day = DateHelper.parseToInt(iso8601.substring(8, 10), 0);
        } else if (len > 15) {
            year = DateHelper.parseToInt(iso8601.substring(0, 4), 0);
            month = DateHelper.parseToInt(iso8601.substring(5, 7), 0);
            day = DateHelper.parseToInt(iso8601.substring(8, 10), 0);
            hour = DateHelper.parseToInt(iso8601.substring(11, 13), 0);
            minute = DateHelper.parseToInt(iso8601.substring(14, 16), 0);
            if (iso8601.charAt(16) == ':') {
                second = DateHelper.parseToInt(iso8601.substring(17, 19), 0);
                timeZone = iso8601.substring(19, len);
            } else {
                timeZone = iso8601.substring(16, len);
            }
            millis = DateHelper.parseOutMillisFromTimeZone(timeZone);
            timeZone = DateHelper.trimTimeZone(timeZone);
        }
        month = Math.max(0, month - 1);
        day = Math.max(1, day);
        if (timeZone == null) {
            int offset = TimeZone.getDefault().getRawOffset();
            timeZone = DateHelper.convertOffSetToTimeZone(offset);
        } else {
            timeZone = timeZone.equals("Z") ? "GMT+00:00" : "GMT" + timeZone;
        }
        return DateHelper.makeDate(year, month, day, hour, minute, second, millis, timeZone);
    }

    private static String convertOffSetToTimeZone(int offset) {
        StringBuffer result = new StringBuffer();
        result.append("GMT");
        boolean isPositive = true;
        if (offset < 0) {
            isPositive = false;
        }
        if (isPositive) {
            result.append("+");
        } else {
            result.append("-");
            offset *= -1;
        }
        int hour = offset / 3600000;
        int minutes = offset / 216000000;
        result.append(DateHelper.padder(hour, 2));
        result.append(":");
        result.append(DateHelper.padder(minutes, 2));
        return result.toString();
    }

    private static String padder(int value, int pads) {
        String v = Integer.toString(value);
        int numZeros = pads - v.length();
        StringBuffer result = new StringBuffer();
        if (numZeros > 0) {
            int i = 0;
            while (i < numZeros) {
                result.append("0");
                ++i;
            }
        }
        result.append(v);
        return result.toString();
    }

    private static String trimTimeZone(String timeZone) {
        if (timeZone == null) {
            return null;
        }
        int beginIndex = 0;
        int len = timeZone.length();
        int i = 0;
        while (i < timeZone.length()) {
            beginIndex = i;
            char c = timeZone.charAt(i);
            if (c == '+' || c == '-' || i > 4 || DateHelper.isAlphaChar(c)) break;
            ++i;
        }
        return timeZone.substring(beginIndex, len);
    }

    private static int parseOutMillisFromTimeZone(String timeZone) {
        if (timeZone == null || !timeZone.startsWith(".") || timeZone.length() < 4) {
            return 0;
        }
        StringBuffer millis = new StringBuffer();
        int i = 1;
        while (i < timeZone.length()) {
            char c = timeZone.charAt(i);
            if (c == '+' || c == '-' || i > 4 || DateHelper.isAlphaChar(c)) break;
            millis.append(c);
            ++i;
        }
        return DateHelper.parseToInt(millis.toString(), 0);
    }

    private static boolean isAlphaChar(char c) {
        return c > '@' && c < '[';
    }

    public static Date makeDate(int year, int month, int day, int hour, int minute, int sec, int msec, String timeZone) {
        Calendar cal;
        if (timeZone != null) {
            TimeZone tzone = TimeZone.getTimeZone(timeZone);
            cal = Calendar.getInstance(tzone);
        } else {
            cal = Calendar.getInstance();
        }
        cal.set(year, month, day, hour, minute, sec);
        cal.set(14, msec);
        return cal.getTime();
    }

    private static int parseToInt(String token, int def) {
        if (token == null) {
            return def;
        }
        try {
            return Integer.parseInt(token, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public static void main(String[] args) {
        String s = "1997";
        System.out.println(s);
        Date d = DateHelper.getDateFromIso8601(s);
        System.out.println(d + "\n");
        s = "1997-07";
        System.out.println(s);
        d = DateHelper.getDateFromIso8601(s);
        System.out.println(d + "\n");
        s = "1997-07-16";
        System.out.println(s);
        d = DateHelper.getDateFromIso8601(s);
        System.out.println(d + "\n");
        s = "1997-07-16T19:20-05:00";
        System.out.println(s);
        d = DateHelper.getDateFromIso8601(s);
        System.out.println(d + "\n");
        s = "1997-07-16T19:20:30-05:00";
        System.out.println(s);
        d = DateHelper.getDateFromIso8601(s);
        System.out.println(d + "\n");
        s = "2007-03-26T19:36:28.4375Z";
        System.out.println(s);
        d = DateHelper.getDateFromIso8601(s);
        System.out.println(d + "\n");
        Date date = new Date();
        s = DateHelper.getIso8601Date(date);
        System.out.println("Our ISO8601: " + s);
        System.out.println(DateHelper.getDateFromIso8601(s) + "\n");
        s = DateHelper.getIso8601Date();
        System.out.println("Our ISO8601: " + s);
        System.out.println(DateHelper.getDateFromIso8601(s));
    }
}

