/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class Element implements org.eclipse.higgins.sts.api.IElement
{
	/**
	 * The contained element object
	 */
	private Object objectElement = null;

	/**
	 * Gets the Class of the contained element object
	 * 
	 * @see org.eclipse.higgins.sts.api.IObjectContainer#getObjectClass
	 */
	public java.lang.Class getObjectClass()
	{
		if (null == this.objectElement) {
			return null;
		}
		return this.objectElement.getClass();
	}
	
	/**
	 * Gets the List of the element Classes supported by the underlying implementation
	 * 
	 * @see org.eclipse.higgins.sts.api.IObjectContainer#getSupportedClasses
	 */
	public java.util.List getSupportedClasses()
	{
		final java.util.List result = new java.util.ArrayList();
		result.add(String.class);
		result.add(org.w3c.dom.Element.class);
		result.add(org.apache.axiom.om.OMElement.class);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.xml.IElement#get()
	 */
	public Object get()
	{
		return this.objectElement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.xml.IElement#getAs(java.lang.Class)
	 */
	public Object getAs
		(final Class classElement)
		throws Exception
	{
		if (null == this.objectElement) {
			return null;
		}
		if (classElement.isInstance(this.objectElement))
		{
			return this.objectElement;
		}
		final Object resultElement = null;
		try
		{
			if (String.class.isInstance(this.objectElement))
			{
				final String strElement = (String)this.objectElement;
				if ((classElement.equals
					(org.w3c.dom.Element.class)))
				{
					return XMLHelper.toDOM
						(strElement);
				}
				else if ((classElement.equals
					(org.apache.axiom.om.OMElement.class)))
				{
					return XMLHelper.toOM
						(strElement);
				}
			}
			else if (org.w3c.dom.Element.class.isInstance(this.objectElement))
			{
				final org.w3c.dom.Element domElement = (org.w3c.dom.Element)this.objectElement;
				if (classElement.equals
					(String.class))
				{
					return XMLHelper.toString
						(domElement);
				}
				else if ((classElement.equals
					(org.apache.axiom.om.OMElement.class)))
				{
					return XMLHelper.toOM
						(domElement);				
				}
			}
			else if (org.apache.axiom.om.OMElement.class.isInstance(this.objectElement))
			{
				final org.apache.axiom.om.OMElement omElement = (org.apache.axiom.om.OMElement)this.objectElement;
				if (classElement.equals
					(String.class))
				{
					return XMLHelper.toString
						(omElement);
				}
				else if ((classElement.equals
					(org.w3c.dom.Element.class)))
				{
					return XMLHelper.toDOM
						(omElement);				
				}
			}		
			else
			{
				throw new Exception
					(classElement.getName());			
			}
		}
		catch (final Exception e)
		{
			return null;
		}
		return resultElement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.xml.IElement#set(java.lang.Object)
	 */
	public void set
		(final Object objectElement)
		throws Exception
	{
		if (null != objectElement)
		{
			if (!((String.class.isInstance(objectElement))
				|| (org.w3c.dom.Element.class.isInstance(objectElement))
				|| (org.apache.axiom.om.OMElement.class.isInstance(objectElement))))
			{
				String errMsg = MsgHelper.getString(MsgHelper.unsupported_ielement_set, "Element", "set", objectElement.getClass().getName());
				throw new Exception(errMsg);
			}
		}
		this.objectElement = objectElement;
	}

}
