/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.common;

import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISAMLToken;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.utilities.DateHelper;

public abstract class SAMLToken
implements ISAMLToken {
    private QName qnameIssueInstant = new QName("IssueInstant");
    private QName qnameIssuer = new QName("Issuer");
    protected OMElement omAssertion = null;
    protected OMElement omAdvice = null;
    protected OMElement omAttributeStatement = null;
    protected OMElement omAuthenticationStatement = null;
    protected OMElement omAuthorizationDecisionStatement = null;
    protected OMElement omConditions = null;
    protected OMElement omSignature = null;
    protected OMElement omStatement = null;
    protected OMElement omSubjectStatement = null;
    private URI uriSAMLAssertion = URI.create("urn:oasis:names:tc:SAML:1.0:assertion");
    private QName qnameAdvice = new QName(this.uriSAMLAssertion.toString(), "Advice");
    private QName qnameAttributeStatement = new QName(this.uriSAMLAssertion.toString(), "AttributeStatement");
    private QName qnameAuthenticationStatement = new QName(this.uriSAMLAssertion.toString(), "AuthenticationStatement");
    private QName qnameAuthorizationDecisionStatement = new QName(this.uriSAMLAssertion.toString(), "AuthorizationDecisionStatement");
    private QName qnameConditions = new QName(this.uriSAMLAssertion.toString(), "Conditions");
    private QName qnameSignature = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    private QName qnameStatement = new QName(this.uriSAMLAssertion.toString(), "Statement");
    private QName qnameSubjectStatement = new QName(this.uriSAMLAssertion.toString(), "SubjectStatement");
    static /* synthetic */ Class class$org$apache$axiom$om$OMElement;

    protected abstract void createAssertion();

    public IElement getAdvice() throws Exception {
        Element elemAdvice = null;
        if (null != this.omAdvice) {
            elemAdvice = new Element();
            elemAdvice.set(this.omAdvice);
        }
        return elemAdvice;
    }

    public IElement getAttributeStatement() throws Exception {
        Element elemAttributeStatement = null;
        if (null != this.omAttributeStatement) {
            elemAttributeStatement = new Element();
            elemAttributeStatement.set(this.omAttributeStatement);
        }
        return elemAttributeStatement;
    }

    public IElement getAuthenticationStatement() throws Exception {
        Element elemAuthenticationStatement = null;
        if (null != this.omAuthenticationStatement) {
            elemAuthenticationStatement = new Element();
            elemAuthenticationStatement.set(this.omAuthenticationStatement);
        }
        return elemAuthenticationStatement;
    }

    public IElement getAuthorizationDecisionStatement() throws Exception {
        Element elemAuthorizationDecisionStatement = null;
        if (null != this.omAuthorizationDecisionStatement) {
            elemAuthorizationDecisionStatement = new Element();
            elemAuthorizationDecisionStatement.set(this.omAuthorizationDecisionStatement);
        }
        return elemAuthorizationDecisionStatement;
    }

    public IElement getConditions() throws Exception {
        Element elemConditions = null;
        if (null != this.omConditions) {
            elemConditions = new Element();
            elemConditions.set(this.omConditions);
        }
        return elemConditions;
    }

    public Date getIssueInstant() {
        Date dtIssueInstant = null;
        if (null != this.omAssertion) {
            String strIssueInstant = this.omAssertion.getAttributeValue(this.qnameIssueInstant);
            dtIssueInstant = DateHelper.getDateFromIso8601(strIssueInstant);
        }
        return dtIssueInstant;
    }

    public String getIssuer() {
        String strIssuer = null;
        if (null != this.omAssertion) {
            strIssuer = this.omAssertion.getAttributeValue(this.qnameIssuer);
        }
        return strIssuer;
    }

    public IElement getSignature() throws Exception {
        Element elemSignature = null;
        if (null != this.omSignature) {
            elemSignature = new Element();
            elemSignature.set(this.omSignature);
        }
        return elemSignature;
    }

    public IElement getStatement() throws Exception {
        Element elemStatement = null;
        if (null != this.omStatement) {
            elemStatement = new Element();
            elemStatement.set(this.omStatement);
        }
        return elemStatement;
    }

    public IElement getSubjectStatement() throws Exception {
        Element elemSubjectStatement = null;
        if (null != this.omSubjectStatement) {
            elemSubjectStatement = new Element();
            elemSubjectStatement.set(this.omSubjectStatement);
        }
        return elemSubjectStatement;
    }

    public void setAdvice(IElement elemAdvice) throws Exception {
        if (null != this.omAdvice) {
            this.omAdvice.detach();
        }
        this.omAdvice = (OMElement)elemAdvice.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omAdvice);
    }

    public void setAttributeStatement(IElement elemAttributeStatement) throws Exception {
        if (null != this.omAttributeStatement) {
            this.omAttributeStatement.detach();
        }
        this.omAttributeStatement = (OMElement)elemAttributeStatement.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omAttributeStatement);
    }

    public void setAuthenticationStatement(IElement elemAuthenticationStatement) throws Exception {
        if (null != this.omAuthenticationStatement) {
            this.omAuthenticationStatement.detach();
        }
        this.omAuthenticationStatement = (OMElement)elemAuthenticationStatement.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omAuthenticationStatement);
    }

    public void setAuthorizationDecisionStatement(IElement elemAuthorizationDecisionStatement) throws Exception {
        if (null != this.omAuthorizationDecisionStatement) {
            this.omAuthorizationDecisionStatement.detach();
        }
        this.omAuthorizationDecisionStatement = (OMElement)elemAuthorizationDecisionStatement.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omAuthorizationDecisionStatement);
    }

    public void setConditions(IElement elemConditions) throws Exception {
        if (null != this.omConditions) {
            this.omConditions.detach();
        }
        this.omConditions = (OMElement)elemConditions.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omConditions);
    }

    public void setIssueInstant(Date dtIssueInstant) {
        this.createAssertion();
        OMAttribute omIssueInstant = this.omAssertion.getAttribute(this.qnameIssueInstant);
        if (null == omIssueInstant) {
            omIssueInstant = this.omAssertion.addAttribute("IssueInstant", DateHelper.getIso8601Date(dtIssueInstant), null);
        } else {
            omIssueInstant.setAttributeValue(DateHelper.getIso8601Date(dtIssueInstant));
        }
    }

    public void setIssuer(String strIssuer) {
        this.createAssertion();
        OMAttribute omIssuer = this.omAssertion.getAttribute(this.qnameIssuer);
        if (null == omIssuer) {
            omIssuer = this.omAssertion.addAttribute("Issuer", strIssuer, null);
        } else {
            omIssuer.setAttributeValue(strIssuer);
        }
    }

    public void setSignature(IElement elemSignature) throws Exception {
        if (null != this.omSignature) {
            this.omSignature.detach();
        }
        this.omSignature = (OMElement)elemSignature.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omSignature);
    }

    public void setStatement(IElement elemStatement) throws Exception {
        if (null != this.omStatement) {
            this.omStatement.detach();
        }
        this.omStatement = (OMElement)elemStatement.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omStatement);
    }

    public void setSubjectStatement(IElement elemSubjectStatement) throws Exception {
        if (null != this.omSubjectStatement) {
            this.omSubjectStatement.detach();
        }
        this.omSubjectStatement = (OMElement)elemSubjectStatement.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        this.omAssertion.addChild((OMNode)this.omSubjectStatement);
    }

    public void fromElement(IElement element) throws Exception {
        this.omAssertion = (OMElement)element.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SAMLToken.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
        if (null != this.omAssertion) {
            this.omAdvice = this.omAssertion.getFirstChildWithName(this.qnameAdvice);
            this.omAttributeStatement = this.omAssertion.getFirstChildWithName(this.qnameAttributeStatement);
            this.omAuthenticationStatement = this.omAssertion.getFirstChildWithName(this.qnameAuthenticationStatement);
            this.omAuthorizationDecisionStatement = this.omAssertion.getFirstChildWithName(this.qnameAuthorizationDecisionStatement);
            this.omConditions = this.omAssertion.getFirstChildWithName(this.qnameConditions);
            this.omSignature = this.omAssertion.getFirstChildWithName(this.qnameSignature);
            this.omStatement = this.omAssertion.getFirstChildWithName(this.qnameStatement);
            this.omSubjectStatement = this.omAssertion.getFirstChildWithName(this.qnameSubjectStatement);
        }
    }

    public IElement toElement() throws Exception {
        Element elemToken = new Element();
        elemToken.set(this.omAssertion);
        return elemToken;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

