/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class CertificateHelper {
    private static final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$utilities$CertificateHelper == null ? (class$org$eclipse$higgins$sts$utilities$CertificateHelper = CertificateHelper.class$("org.eclipse.higgins.sts.utilities.CertificateHelper")) : class$org$eclipse$higgins$sts$utilities$CertificateHelper).getName());
    private static CertificateFactory certificateFactory = null;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$utilities$CertificateHelper;

    public static X509Certificate fromString(String cert) {
        try {
            if (null == certificateFactory) {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            String strCertificate = "-----BEGIN CERTIFICATE-----\n" + cert + "\n-----END CERTIFICATE-----\n";
            ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strCertificate.getBytes("UTF-8"));
            return (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
        }
        catch (Exception ex) {
            ExceptionHelper.Log(log, ex);
            return null;
        }
    }

    public static X509Certificate findLeafFromCertificates(List listCerts) {
        int iCert;
        if (0 == listCerts.size()) {
            return null;
        }
        if (1 == listCerts.size()) {
            return (X509Certificate)listCerts.get(0);
        }
        HashMap<String, String> issuerMap = new HashMap<String, String>();
        ArrayList<String> subjectList = new ArrayList<String>();
        for (iCert = 0; iCert < listCerts.size(); ++iCert) {
            X509Certificate x509Certificate = (X509Certificate)listCerts.get(iCert);
            Principal subjectDN = x509Certificate.getSubjectDN();
            String strSubject = subjectDN.getName();
            Principal issuerDN = x509Certificate.getIssuerDN();
            String strIssuer = issuerDN.getName();
            issuerMap.put(strIssuer, strSubject);
            subjectList.add(strSubject);
        }
        for (iCert = 0; iCert < subjectList.size(); ++iCert) {
            String strSubject = (String)subjectList.get(iCert);
            if (null != issuerMap.get(strSubject)) continue;
            log.trace("Found LEaf Certificate for Subject: " + strSubject);
            return (X509Certificate)listCerts.get(iCert);
        }
        return null;
    }

    public static X509Certificate findLeafFromEncodedCertificates(List listEncodedCerts) {
        if (0 == listEncodedCerts.size()) {
            return null;
        }
        if (1 == listEncodedCerts.size()) {
            return CertificateHelper.fromString((String)listEncodedCerts.get(0));
        }
        ArrayList<X509Certificate> listCerts = new ArrayList<X509Certificate>();
        for (int iCert = 0; iCert < listEncodedCerts.size(); ++iCert) {
            listCerts.add(CertificateHelper.fromString((String)listEncodedCerts.get(iCert)));
        }
        return CertificateHelper.findLeafFromCertificates(listCerts);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

