/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class CertificateHelper {
    private static final LogHelper log;
    private static CertificateFactory certificateFactory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.utilities.CertificateHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new LogHelper(clazz.getName());
        certificateFactory = null;
    }

    public static X509Certificate fromString(String cert) {
        try {
            if (certificateFactory == null) {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            String strCertificate = "-----BEGIN CERTIFICATE-----\n" + cert + "\n-----END CERTIFICATE-----\n";
            ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strCertificate.getBytes("UTF-8"));
            return (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
        }
        catch (Exception ex) {
            ExceptionHelper.Log(log, ex);
            return null;
        }
    }

    public static X509Certificate findLeafFromCertificates(List listCerts) {
        if (listCerts.size() == 0) {
            return null;
        }
        if (1 == listCerts.size()) {
            return (X509Certificate)listCerts.get(0);
        }
        HashMap<String, String> issuerMap = new HashMap<String, String>();
        ArrayList<String> subjectList = new ArrayList<String>();
        int iCert = 0;
        while (iCert < listCerts.size()) {
            X509Certificate x509Certificate = (X509Certificate)listCerts.get(iCert);
            Principal subjectDN = x509Certificate.getSubjectDN();
            String strSubject = subjectDN.getName();
            Principal issuerDN = x509Certificate.getIssuerDN();
            String strIssuer = issuerDN.getName();
            issuerMap.put(strIssuer, strSubject);
            subjectList.add(strSubject);
            ++iCert;
        }
        iCert = 0;
        while (iCert < subjectList.size()) {
            String strSubject = (String)subjectList.get(iCert);
            if (issuerMap.get(strSubject) == null) {
                log.trace("Found LEaf Certificate for Subject: " + strSubject);
                return (X509Certificate)listCerts.get(iCert);
            }
            ++iCert;
        }
        return null;
    }

    public static X509Certificate findLeafFromEncodedCertificates(List listEncodedCerts) {
        if (listEncodedCerts.size() == 0) {
            return null;
        }
        if (1 == listEncodedCerts.size()) {
            return CertificateHelper.fromString((String)listEncodedCerts.get(0));
        }
        ArrayList<X509Certificate> listCerts = new ArrayList<X509Certificate>();
        int iCert = 0;
        while (iCert < listEncodedCerts.size()) {
            listCerts.add(CertificateHelper.fromString((String)listEncodedCerts.get(iCert)));
            ++iCert;
        }
        return CertificateHelper.findLeafFromCertificates(listCerts);
    }
}

