/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial design and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

import java.util.Date;

import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISAMLToken;

/**
 * @author mikemci
 *
 */
public abstract class SAMLToken implements ISAMLToken
{
	private javax.xml.namespace.QName qnameIssueInstant = new javax.xml.namespace.QName
		("IssueInstant");

	private javax.xml.namespace.QName qnameIssuer = new javax.xml.namespace.QName
		("Issuer");
	
	protected org.apache.axiom.om.OMElement omAssertion = null;

	protected org.apache.axiom.om.OMElement omAdvice = null;

	protected org.apache.axiom.om.OMElement omAttributeStatement = null;

	protected org.apache.axiom.om.OMElement omAuthenticationStatement = null;

	protected org.apache.axiom.om.OMElement omAuthorizationDecisionStatement = null;
	
	protected org.apache.axiom.om.OMElement omConditions = null;

	protected org.apache.axiom.om.OMElement omSignature = null;

	protected org.apache.axiom.om.OMElement omStatement = null;

	protected org.apache.axiom.om.OMElement omSubjectStatement = null;
	
	private java.net.URI uriSAMLAssertion = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:assertion");
	
	private javax.xml.namespace.QName qnameAdvice = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "Advice");
	
	private javax.xml.namespace.QName qnameAttributeStatement = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "AttributeStatement");

	private javax.xml.namespace.QName qnameAuthenticationStatement = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "AuthenticationStatement");
	
	private javax.xml.namespace.QName qnameAuthorizationDecisionStatement = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "AuthorizationDecisionStatement");
	
	private javax.xml.namespace.QName qnameConditions = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "Conditions");
	
	private javax.xml.namespace.QName qnameSignature = new javax.xml.namespace.QName
		("http://www.w3.org/2000/09/xmldsig#", "Signature");
	
	private javax.xml.namespace.QName qnameStatement = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "Statement");
	
	private javax.xml.namespace.QName qnameSubjectStatement = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "SubjectStatement");
	
	abstract protected void createAssertion();
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getAdvice()
	 */
	public IElement getAdvice() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemAdvice = null;
		if (null != omAdvice)
		{
			elemAdvice = new org.eclipse.higgins.sts.common.Element();
			elemAdvice.set(omAdvice);
		}
		return elemAdvice;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getAttributeStatement()
	 */
	public IElement getAttributeStatement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemAttributeStatement = null;
		if (null != omAttributeStatement)
		{
			elemAttributeStatement = new org.eclipse.higgins.sts.common.Element();
			elemAttributeStatement.set(omAttributeStatement);
		}
		return elemAttributeStatement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getAuthenticationStatement()
	 */
	public IElement getAuthenticationStatement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemAuthenticationStatement = null;
		if (null != omAuthenticationStatement)
		{
			elemAuthenticationStatement = new org.eclipse.higgins.sts.common.Element();
			elemAuthenticationStatement.set(omAuthenticationStatement);
		}
		return elemAuthenticationStatement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getAuthorizationDecisionStatement()
	 */
	public IElement getAuthorizationDecisionStatement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemAuthorizationDecisionStatement = null;
		if (null != omAuthorizationDecisionStatement)
		{
			elemAuthorizationDecisionStatement = new org.eclipse.higgins.sts.common.Element();
			elemAuthorizationDecisionStatement.set(omAuthorizationDecisionStatement);
		}
		return elemAuthorizationDecisionStatement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getConditions()
	 */
	public IElement getConditions() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemConditions = null;
		if (null != omConditions)
		{
			elemConditions = new org.eclipse.higgins.sts.common.Element();
			elemConditions.set(omConditions);
		}
		return elemConditions;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getIssueInstant()
	 */
	public Date getIssueInstant()
	{
		Date dtIssueInstant = null;
		if (null != omAssertion)
		{
			String strIssueInstant = omAssertion.getAttributeValue(qnameIssueInstant);
			dtIssueInstant = org.eclipse.higgins.sts.utilities.DateHelper.getDateFromIso8601(strIssueInstant);
		}
		return dtIssueInstant;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getIssuer()
	 */
	public String getIssuer()
	{
		String strIssuer = null;
		if (null != omAssertion)
			strIssuer = omAssertion.getAttributeValue(qnameIssuer);
		return strIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getSignature()
	 */
	public IElement getSignature() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemSignature = null;
		if (null != omSignature)
		{
			elemSignature = new org.eclipse.higgins.sts.common.Element();
			elemSignature.set(omSignature);
		}
		return elemSignature;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getStatement()
	 */
	public IElement getStatement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemStatement = null;
		if (null != omStatement)
		{
			elemStatement = new org.eclipse.higgins.sts.common.Element();
			elemStatement.set(omStatement);
		}
		return elemStatement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#getSubjectStatement()
	 */
	public IElement getSubjectStatement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemSubjectStatement = null;
		if (null != omSubjectStatement)
		{
			elemSubjectStatement = new org.eclipse.higgins.sts.common.Element();
			elemSubjectStatement.set(omSubjectStatement);
		}
		return elemSubjectStatement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setAdvice(org.eclipse.higgins.sts.api.IElement)
	 */
	public void setAdvice(IElement elemAdvice) throws Exception
	{
		if (null != omAdvice)
			omAdvice.detach();
		omAdvice = (org.apache.axiom.om.OMElement)elemAdvice.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omAdvice);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setAttributeStatement(org.eclipse.higgins.sts.api.IAttributeStatement)
	 */
	public void setAttributeStatement(IElement elemAttributeStatement) throws Exception
	{
		if (null != omAttributeStatement)
			omAttributeStatement.detach();
		omAttributeStatement = (org.apache.axiom.om.OMElement)elemAttributeStatement.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omAttributeStatement);		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setAuthenticationStatement(org.eclipse.higgins.sts.api.IElement)
	 */
	public void setAuthenticationStatement(IElement elemAuthenticationStatement) throws Exception
	{
		if (null != omAuthenticationStatement)
			omAuthenticationStatement.detach();
		omAuthenticationStatement = (org.apache.axiom.om.OMElement)elemAuthenticationStatement.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omAuthenticationStatement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setAuthorizationDecisionStatement(org.eclipse.higgins.sts.api.IElement)
	 */
	public void setAuthorizationDecisionStatement(IElement elemAuthorizationDecisionStatement) throws Exception
	{
		if (null != omAuthorizationDecisionStatement)
			omAuthorizationDecisionStatement.detach();
		omAuthorizationDecisionStatement = (org.apache.axiom.om.OMElement)elemAuthorizationDecisionStatement.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omAuthorizationDecisionStatement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setConditions(org.eclipse.higgins.sts.api.IElement)
	 */
	public void setConditions(IElement elemConditions) throws Exception
	{
		if (null != omConditions)
			omConditions.detach();
		omConditions = (org.apache.axiom.om.OMElement)elemConditions.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omConditions);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setIssueInstant(java.util.Date)
	 */
	public void setIssueInstant(Date dtIssueInstant)
	{
		createAssertion();
		org.apache.axiom.om.OMAttribute omIssueInstant = omAssertion.getAttribute(qnameIssueInstant);
		if (null == omIssueInstant)
			omIssueInstant = omAssertion.addAttribute("IssueInstant", org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dtIssueInstant), null);
		else
			omIssueInstant.setAttributeValue(org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dtIssueInstant));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setIssuer(java.lang.String)
	 */
	public void setIssuer(String strIssuer)
	{
		createAssertion();
		org.apache.axiom.om.OMAttribute omIssuer = omAssertion.getAttribute(qnameIssuer);
		if (null == omIssuer)
			omIssuer = omAssertion.addAttribute("Issuer", strIssuer, null);
		else
			omIssuer.setAttributeValue(strIssuer);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setSignature(org.eclipse.higgins.sts.api.ISignature)
	 */
	public void setSignature(IElement elemSignature) throws Exception
	{
		if (null != omSignature)
			omSignature.detach();
		omSignature = (org.apache.axiom.om.OMElement)elemSignature.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omSignature);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setStatement(org.eclipse.higgins.sts.api.IElement)
	 */
	public void setStatement(IElement elemStatement) throws Exception
	{
		if (null != omStatement)
			omStatement.detach();
		omStatement = (org.apache.axiom.om.OMElement)elemStatement.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omStatement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISAMLToken#setSubjectStatement(org.eclipse.higgins.sts.api.IElement)
	 */
	public void setSubjectStatement(IElement elemSubjectStatement) throws Exception
	{
		if (null != omSubjectStatement)
			omSubjectStatement.detach();
		omSubjectStatement = (org.apache.axiom.om.OMElement)elemSubjectStatement.getAs
			(org.apache.axiom.om.OMElement.class);
		omAssertion.addChild(omSubjectStatement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISecurityElement#fromElement(org.eclipse.higgins.sts.api.IElement)
	 */
	public void fromElement(IElement element) throws Exception
	{
		omAssertion = (org.apache.axiom.om.OMElement)element.getAs(org.apache.axiom.om.OMElement.class);
		if (null != omAssertion)
		{
			omAdvice = omAssertion.getFirstChildWithName(qnameAdvice);
			omAttributeStatement = omAssertion.getFirstChildWithName(qnameAttributeStatement);
			omAuthenticationStatement = omAssertion.getFirstChildWithName(qnameAuthenticationStatement);
			omAuthorizationDecisionStatement = omAssertion.getFirstChildWithName(qnameAuthorizationDecisionStatement);
			omConditions = omAssertion.getFirstChildWithName(qnameConditions);
			omSignature = omAssertion.getFirstChildWithName(qnameSignature);
			omStatement = omAssertion.getFirstChildWithName(qnameStatement);
			omSubjectStatement = omAssertion.getFirstChildWithName(qnameSubjectStatement);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ISecurityElement#toElement()
	 */
	public IElement toElement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
		elemToken.set(omAssertion);
		return elemToken;
	}

}
