/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.api.IAddressingInformation;
import org.eclipse.higgins.sts.api.IEndpointReference;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class AddressingInformation
	implements IAddressingInformation
{
	/**
	 * The Namespace URI
	 */
	java.net.URI uriNamespace = null;
	
	/**
	 * The Action URI
	 */
	java.net.URI uriAction = null;
	
	/**
	 * The FaultTo EndpointReference
	 */
	IEndpointReference eprFaultTo = null;
	
	/**
	 * The ReplyTo EndpointReference
	 */
	IEndpointReference eprReplyTo = null;
	
	/**
	 * The From EndpointReference
	 */
	IEndpointReference eprFrom = null;
	
	/**
	 * The MessageID URI
	 */
	java.net.URI uriMessageID = null;
	
	/**
	 * The RelatesTo URI
	 */
	java.net.URI uriRelatesTo = null;
	
	/**
	 * The To URI
	 */
	java.net.URI uriTo = null;
	
	/**
	 * The RelatesTo RelationshipType URI
	 */
	java.net.URI uriRelatesToRelationshipType = null;

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getAction()
	 */
	public java.net.URI getAction()
	{
		return this.uriAction;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getFaultTo()
	 */
	public IEndpointReference getFaultTo()
	{
		return this.eprFaultTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getFrom()
	 */
	public IEndpointReference getFrom()
	{
		return this.eprFrom;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getMessageID()
	 */
	public java.net.URI getMessageID()
	{
		return this.uriMessageID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setMessageID(java.net.URI)
	 */
	public void setMessageID(final java.net.URI uriMessageID)
	{
		this.uriMessageID = uriMessageID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getNamespace()
	 */
	public java.net.URI getNamespace()
	{
		return this.uriNamespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getRelatesToRelationshipType()
	 */
	public java.net.URI getRelatesToRelationshipType()
	{
		return this.uriRelatesToRelationshipType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getRelatesTo()
	 */
	public java.net.URI getRelatesTo()
	{
		return this.uriRelatesTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getReplyTo()
	 */
	public IEndpointReference getReplyTo()
	{
		return this.eprReplyTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#getTo()
	 */
	public java.net.URI getTo()
	{
		return this.uriTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setAction(java.net.URI)
	 */
	public void setAction(final java.net.URI uriAction)
	{
		this.uriAction = uriAction;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setNamespaceURI(java.lang.String)
	 */
	public void setNamespace(final java.net.URI uriNamespace)
	{
		this.uriNamespace = uriNamespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setFaultTo(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setFaultTo(final IEndpointReference eprFaultTo)
	{
		this.eprFaultTo = eprFaultTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setFrom(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setFrom(final IEndpointReference eprFrom)
	{
		this.eprFrom = eprFrom;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setRelatesToRelationshipType(java.net.URI)
	 */
	public void setRelatesToRelationshipType(final java.net.URI uriRelatesToRelationshipType)
	{
		this.uriRelatesToRelationshipType = uriRelatesToRelationshipType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setRelatesTo(java.net.URI)
	 */
	public void setRelatesTo(final java.net.URI uriRelatesTo)
	{
		this.uriRelatesTo = uriRelatesTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setReplyTo(org.eclipse.higgins.sts.IEndpointReference)
	 */
	public void setReplyTo(final IEndpointReference eprReplyTo)
	{
		this.eprReplyTo = eprReplyTo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAddressingInformation#setTo(java.net.URI)
	 */
	public void setTo(final java.net.URI uriTo)
	{
		this.uriTo = uriTo;
	}

}
