/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.net.URI;

import org.eclipse.higgins.sts.api.IConstants;

/**
 * Defines a set of constants for namespaces and other URI values.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Decide whether some subset of these values should be configurable since they may change as specifications are revised
public class Constants implements IConstants
{
	static private final java.net.URI uriIdentityNamespace = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2005/05/identity");

	/**
	 * Namespace URI used for InfoCard/CardSpace defined claims
	 */
	static private final java.net.URI uriIdentityClaimsNamespace = java.net.URI.create
		(Constants.uriIdentityNamespace + "/claims");
	
	/**
	 * Namespace URI used for InfoCard/CardSpace extensions to 
	 */
	static private final java.net.URI uriAddressingIdentityNamespace = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2006/02/addressingidentity");
	
	/**
	 * Namespace URI for SAML 1.0 Assertions
	 */
	static private final java.net.URI uriSAML10AssertionNamespace = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:assertion");
	
	static private final java.net.URI uriSAML10ProtocolNamespace = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:protocol");

	static private final java.net.URI uriSAML10ConfirmationMethodBearer = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:cm:bearer");
	
	static private final java.net.URI uriSAML10ConfirmationMethodHolderOfKey = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
	
	/**
	 * Namespace URI for SAML 2.0 
	 */
	static private final java.net.URI uriSAML20AssertionNamespace = java.net.URI.create
		("urn:oasis:names:tc:SAML:2.0:assertion");
	
	static private final java.net.URI uriSAML20ProtocolNamespace = java.net.URI.create
		("urn:oasis:names:tc:SAML:2.0:protocol");

	static private final java.net.URI uriSAML20ConfirmationMethodBearer = java.net.URI.create
		("urn:oasis:names:tc:SAML:2.0:cm:bearer");
	
	static private final java.net.URI uriSAML20ConfirmationMethodHolderOfKey = java.net.URI.create
		("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");

	static private final java.net.URI uriSAML20StatusCodeSuccess = java.net.URI.create
		("urn:oasis:names:tc:SAML:2.0:status:Success");
	
	/**
	 * Namespace URI for Web Services Addressing 1.0 - Core W3C Recommendation 9 May 2006
	 */
	static private final java.net.URI uriWSAddressingNamespace = java.net.URI.create
		("http://www.w3.org/2005/08/addressing");

	/**
	 * Core Namespace URI for Web Services Security: SOAP Message Security 1.0 (WS-Security 2004) OASIS Standard 200401, March 2004
	 */
	static private final java.net.URI uriWSSecurityNamespace = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
	
	/**
	 * Utility Namespace URI for Web Services Security: SOAP Message Security 1.0 (WS-Security 2004) OASIS Standard 200401, March 2004
	 */
	static private final java.net.URI uriWSSecurityUtilityNamespace = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
	
	/**
	 * Namespace URI for Web Services Trust Language (WS-Trust) February 2005
	 */
	static private final java.net.URI uriWSTrustNamespace = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2005/02/trust");
	
	/**
	 * Namespace URI for Web Services Security Policy Language (WS-SecurityPolicy) July 2005 Version 1.1
	 */
	static private final java.net.URI uriWSSecurityPolicyNamespace = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy");

	/**
	 * Namespace URI for Web Services Policy Language (WS-Policy) September 2004
	 */
	static private final java.net.URI uriWSPolicyNamespace = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2004/09/policy");

	/**
	 * Namespace URI for XML-Signature Syntax and Processing W3C Recommendation 12 February 2002 
	 */
	static private final java.net.URI uriXMLSignatureNamespace = java.net.URI.create
		("http://www.w3.org/2000/09/xmldsig#");

	/**
	 * Namespace URI for XML Encryption Syntax and Processing W3C Recommendation 10 December 2002
	 */
	static private final java.net.URI uriXMLEncryptionNamespace = java.net.URI.create
		("http://www.w3.org/2001/04/xmlenc#");

	/**
	 * Token Issuer URI for Self Issued Tokens
	 */
	static private final java.net.URI uriIssuerSelf = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self");
	
	/**
	 * Request Type URI for Issue (RequestSecurityToken)
	 */
	static private final java.net.URI uriIssueRequestType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/Issue");
	
	/**
	 * WS-Addressing Action URI for Issue Request
	 */
	static private final java.net.URI uriIssueRequestAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RST/Issue");
	
	/**
	 * WS-Addressing Action URI for Issue Response
	 */	
	static private final java.net.URI uriIssueResponseAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RSTR/Issue");
	
	/**
	 * Request Type URI for Renew (RequestSecurityToken)
	 */
	static private final java.net.URI uriRenewRequestType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/Renew");
	
	/**
	 * WS-Addressing Action URI for Renew Request
	 */
	static private final java.net.URI uriRenewRequestAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RST/Renew");
	
	/**
	 * WS-Addressing Action URI for Renew Response
	 */	
	static private final java.net.URI uriRenewResponseAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RSTR/Renew");
	
	/**
	 * Request Type URI for Cancel (RequestSecurityToken)
	 */
	static private final java.net.URI uriCancelRequestType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/Cancel");
	
	/**
	 * WS-Addressing Action URI for Cancel Request
	 */
	static private final java.net.URI uriCancelRequestAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RST/Cancel");
	
	/**
	 * WS-Addressing Action URI for Cancel Response
	 */	
	static private final java.net.URI uriCancelResponseAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RSTR/Cancel");
	
	/**
	 * Request Type URI for Validate (RequestSecurityToken)
	 */
	static private final java.net.URI uriValidateRequestType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/Validate");
	
	/**
	 * WS-Addressing Action URI for Validate Request
	 */
	static private final java.net.URI uriValidateRequestAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RST/Validate");
	
	/**
	 * WS-Addressing Action URI for Validate Response
	 */	
	static private final java.net.URI uriValidateResponseAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RSTR/Validate");
	
	/**
	 * Request Type URI for Key Exchange (RequestSecurityToken)
	 */
	static private final java.net.URI uriKeyExchangeRequestType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/KET");
	
	/**
	 * WS-Addressing Action URI for Key Exchange Request
	 */
	static private final java.net.URI uriKeyExchangeRequestAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RST/KET");
	
	/**
	 * WS-Addressing Action URI for Key Exchange Response
	 */	
	static private final java.net.URI uriKeyExchangeResponseAction = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RSTR/KET");
	
	/**
	 * Token Type URI for Status (Validate)
	 */
	static private final java.net.URI uriStatusTokenType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/RSTR/Status");
	
	/**
	 * Status Code URI for Valid
	 */
	static private final java.net.URI uriValidStatusCode = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/status/valid");
	
	/**
	 * Status Code URI for Invalid
	 */
	static private final java.net.URI uriInvalidStatusCode = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/status/invalid");
	
	/**
	 * Computed Key URI for PSHA1 Algorithm
	 */
	static private final java.net.URI uriPSHA1ComputedKey = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/CK/PSHA1");
	/**
	 * Computed Key URI for HASH Algorithm
	 */
	static private final java.net.URI uriHashComputedKey = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/CK/HASH");
	/**
	 * Binary Secret Type URI for Asymmetric Key
	 */
	static private final java.net.URI uriAsymmetricKeyBinarySecretType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/AsymmetricKey");
	/**
	 * Binary Secret Type URI for Asymmetric Key
	 */
	static private final java.net.URI uriSymmetricKeyBinarySecretType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/SymmetricKey");
	
	/**
	 * Binary Secret Type URI for Asymmetric Key
	 */
	static private final java.net.URI uriNonceBinarySecretType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/Nonce");
	
	/**
	 * Key Type URI for Public Key
	 */
	static private final java.net.URI uriAsymmetricKeyType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/PublicKey");
	
	/**
	 * Key Type URI for Symmetric Key
	 */
	static private final java.net.URI uriSymmetricKeyType = java.net.URI.create
		(Constants.uriWSTrustNamespace.toString() + "/SymmetricKey");
	
	static private final java.net.URI uriNoProofKey = java.net.URI.create
		(Constants.uriIdentityNamespace.toString() + "/NoProofKey");
	
	/**
	 * SOAP Fault Code for request was invalid or malformed
	 */
	static private final String InvalidRequestFaultCode = "InvalidRequest";
	
	/**
	 * SOAP Fault Code for Authentication failed
	 */
	static private final String FailedAuthenticationFaultCode = "FailedAuthentication";
	
	/**
	 * SOAP Fault Code for specified request failed
	 */
	static private final String RequestFailedFaultCode = "RequestFailed";
	
	/**
	 * SOAP Fault Code for Security token has been revoked
	 */
	static private final String InvalidSecurityTokenFaultCode = "InvalidSecurityToken";
	
	/**
	 * SOAP Fault Code for Insufficient Digest Elements
	 */
	static private final String AuthenticationBadElementsFaultCode = "AuthenticationBadElements";
	
	/**
	 * SOAP Fault Code for specified RequestSecurityToken is not understood
	 */
	static private final String BadRequestFaultCode = "BadRequest";
	
	/**
	 * SOAP Fault Code for request data is out-of-date
	 */
	static private final String ExpiredDataFaultCode = "ExpiredData";
	
	/**
	 * SOAP Fault Code for requested time range is invalid or unsupported
	 */
	static private final String InvalidTimeRangeFaultCode = "InvalidTimeRange";
	
	/**
	 * SOAP Fault Code for request scope is invalid or unsupported
	 */
	static private final String InvalidScopeFaultCode = "InvalidScope";
	
	/**
	 * SOAP Fault Code for renewable security token has expired
	 */
	static private final String RenewNeededFaultCode = "RenewNeeded";
	
	/**
	 * SOAP Fault Code for requested renewal failed
	 */
	static private final String UnableToRenewFaultCode = "UnableToRenew";
	
	/**
	 * @return the uriSAML20TokenType
	 */
	public java.net.URI getSAML20TokenType() {
		return Constants.uriSAML20TokenType;
	}

	/**
	 * @return the uriSAML20AssertionNamespace
	 */
	public java.net.URI getSAML20AssertionNamespace() {
		return Constants.uriSAML20AssertionNamespace;
	}
	
	/**
	 * @return the uriSAML20ProtocolNamespace
	 */
	public java.net.URI getSAML20ProtocolNamespace() {
		return Constants.uriSAML20ProtocolNamespace;
	}


	/**
	 * @return the uriAddressingIdentityNamespace
	 */
	public java.net.URI getAddressingIdentityNamespace() {
		return Constants.uriAddressingIdentityNamespace;
	}

	/**
	 * @return the uriNoProofKey
	 */
	public java.net.URI getNoProofKeyKeyType() {
		return Constants.uriNoProofKey;
	}

	/**
	 * @return the uriIdentityClaimsNamespace
	 */
	public java.net.URI getIdentityClaimsNamespace() {
		return Constants.uriIdentityClaimsNamespace;
	}
	
	public java.net.URI getIdentityClaimPrivatePersonalIdentifier()
	{
		return java.net.URI.create(Constants.uriIdentityClaimsNamespace.toString() + "/privatepersonalidentifier");
	}

	/**
	 * @return the uriIdentityNamespace
	 */
	public java.net.URI getIdentityNamespace() {
		return Constants.uriIdentityNamespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getAsymmetricKeyBinarySecretType()
	 */
	public java.net.URI getAsymmetricKeyBinarySecretType()
	{
		return Constants.uriAsymmetricKeyBinarySecretType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getAsymmetricType()
	 */
	public java.net.URI getAsymmetricKeyType()
	{
		return Constants.uriAsymmetricKeyType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getAuthenticationBadElementsFaultCode()
	 */
	public String getAuthenticationBadElementsFaultCode()
	{
		return Constants.AuthenticationBadElementsFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getBadRequestFaultCode()
	 */
	public String getBadRequestFaultCode()
	{
		return Constants.BadRequestFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getCancelRequestAction()
	 */
	public java.net.URI getCancelRequestAction()
	{
		return Constants.uriCancelRequestAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getCancelRequestType()
	 */
	public java.net.URI getCancelRequestType()
	{
		return Constants.uriCancelRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getCancelResponseAction()
	 */
	public java.net.URI getCancelResponseAction()
	{
		return Constants.uriCancelResponseAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getExpiredDataFaultCode()
	 */
	public String getExpiredDataFaultCode()
	{
		return Constants.ExpiredDataFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getFailedAuthenticationFaultCode()
	 */
	public String getFailedAuthenticationFaultCode()
	{
		return Constants.FailedAuthenticationFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getHashComputedKey()
	 */
	public java.net.URI getHashComputedKey()
	{
		return Constants.uriHashComputedKey;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getInvalidRequestFaultCode()
	 */
	public String getInvalidRequestFaultCode()
	{
		return Constants.InvalidRequestFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getInvalidScopeFaultCode()
	 */
	public String getInvalidScopeFaultCode()
	{
		return Constants.InvalidScopeFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getInvalidSecurityTokenFaultCode()
	 */
	public String getInvalidSecurityTokenFaultCode()
	{
		return Constants.InvalidSecurityTokenFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getInvalidStatusCode()
	 */
	public java.net.URI getInvalidStatusCode()
	{
		return Constants.uriInvalidStatusCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getInvalidTimeRangeFaultCode()
	 */
	public String getInvalidTimeRangeFaultCode()
	{
		return Constants.InvalidTimeRangeFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getIssueRequestAction()
	 */
	public java.net.URI getIssueRequestAction()
	{
		return Constants.uriIssueRequestAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getIssueRequestType()
	 */
	public java.net.URI getIssueRequestType()
	{
		return Constants.uriIssueRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getIssueResponseAction()
	 */
	public java.net.URI getIssueResponseAction()
	{
		return Constants.uriIssueResponseAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getIssuerSelf()
	 */
	public java.net.URI getIssuerSelf()
	{
		return Constants.uriIssuerSelf;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getKeyExchangeRequestAction()
	 */
	public java.net.URI getKeyExchangeRequestAction()
	{
		return Constants.uriKeyExchangeRequestAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getKeyExchangeRequestTypeURI()
	 */
	public java.net.URI getKeyExchangeRequestType()
	{
		return Constants.uriKeyExchangeRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getKeyExchangeResponseAction()
	 */
	public java.net.URI getKeyExchangeResponseAction()
	{
		return Constants.uriKeyExchangeResponseAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getNonceBinarySecretType()
	 */
	public java.net.URI getNonceBinarySecretType()
	{
		return Constants.uriNonceBinarySecretType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getPSHA1ComputedKey()
	 */
	public java.net.URI getPSHA1ComputedKey()
	{
		return Constants.uriPSHA1ComputedKey;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getRenewNeededFaultCode()
	 */
	public String getRenewNeededFaultCode()
	{
		return Constants.RenewNeededFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getRenewRequestAction()
	 */
	public java.net.URI getRenewRequestAction()
	{
		return Constants.uriRenewRequestAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getRenewRequestType()
	 */
	public java.net.URI getRenewRequestType()
	{
		return Constants.uriRenewRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getRenewResponseAction()
	 */
	public java.net.URI getRenewResponseAction()
	{
		return Constants.uriRenewResponseAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getRequestFailedFaultCode()
	 */
	public String getRequestFailedFaultCode()
	{
		return Constants.RequestFailedFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getStatusTokenType()
	 */
	public java.net.URI getStatusTokenType()
	{
		return Constants.uriStatusTokenType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getSymmetricKeyBinarySecretTypeURI()
	 */
	public java.net.URI getSymmetricKeyBinarySecretType()
	{
		return Constants.uriSymmetricKeyBinarySecretType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getSymmetricKeyTypeURI()
	 */
	public java.net.URI getSymmetricKeyType()
	{
		return Constants.uriSymmetricKeyType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getUnableToRenewFaultCode()
	 */
	public String getUnableToRenewFaultCode()
	{
		return Constants.UnableToRenewFaultCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getValidateRequestAction()
	 */
	public java.net.URI getValidateRequestAction()
	{
		return Constants.uriValidateRequestAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getValidateRequestType()
	 */
	public java.net.URI getValidateRequestType()
	{
		return Constants.uriValidateRequestType;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getValidateResponseAction()
	 */
	public java.net.URI getValidateResponseAction()
	{
		return Constants.uriValidateResponseAction;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getValidStatusCode()
	 */
	public java.net.URI getValidStatusCode()
	{
		return Constants.uriValidStatusCode;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getWSAddressingNamespace()
	 */
	public java.net.URI getWSAddressingNamespace()
	{
		return Constants.uriWSAddressingNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getWSSecurityNamespace()
	 */
	public java.net.URI getWSSecurityNamespace()
	{
		return Constants.uriWSSecurityNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getWSSecurityPolicyNamespace()
	 */
	public java.net.URI getWSSecurityPolicyNamespace()
	{
		return Constants.uriWSSecurityPolicyNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getWSPolicyNamespace()
	 */
	public java.net.URI getWSPolicyNamespace()
	{
		return Constants.uriWSPolicyNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getWSSecurityUtilityNamespace()
	 */
	public java.net.URI getWSSecurityUtilityNamespace()
	{
		return Constants.uriWSSecurityUtilityNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getWSTrustNamespace()
	 */
	public java.net.URI getWSTrustNamespace()
	{
		return Constants.uriWSTrustNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getXMLEncryptionNamespace()
	 */
	public java.net.URI getXMLEncryptionNamespace()
	{
		return Constants.uriXMLEncryptionNamespace;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.impl.IConstants#getXMLSignatureNamespace()
	 */
	public java.net.URI getXMLSignatureNamespace()
	{
		return Constants.uriXMLSignatureNamespace;
	}

	/**
	 * Token Type URI for SAML 1.0 Assertions
	 */
	static private final java.net.URI uriSAML10TokenType = java.net.URI.create
		("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
	
	/**
	 * Token Type URI for SAML 2.0 Assertions
	 */
	static private final java.net.URI uriSAML20TokenType = java.net.URI.create
		("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
	
	public URI getSAML10AssertionNamespace()
	{
		return Constants.uriSAML10AssertionNamespace;
	}
	
	public URI getSAML10ProtocolNamespace()
	{
		return Constants.uriSAML10ProtocolNamespace;
	}
	
	public URI getSAML10TokenType()
	{
		return Constants.uriSAML10TokenType;
	}

	/**
	 * @return the uriSAML10ConfirmationMethodBearer
	 */
	public java.net.URI getSAML10ConfirmationMethodBearer()
	{
		return Constants.uriSAML10ConfirmationMethodBearer;
	}

	/**
	 * @return the uriSAML10ConfirmationMethodHolderOfKey
	 */
	public java.net.URI getSAML10ConfirmationMethodHolderOfKey()
	{
		return Constants.uriSAML10ConfirmationMethodHolderOfKey;
	}
	
	/**
	 * @return the uriSAML20ConfirmationMethodBearer
	 */
	public java.net.URI getSAML20ConfirmationMethodBearer()
	{
		return Constants.uriSAML20ConfirmationMethodBearer;
	}

	/**
	 * @return the uriSAML20ConfirmationMethodHolderOfKey
	 */
	public java.net.URI getSAML20ConfirmationMethodHolderOfKey()
	{
		return Constants.uriSAML20ConfirmationMethodHolderOfKey;
	}
	
	public java.net.URI getSAML20StatusCodeSuccess()
	{
		return Constants.uriSAML20StatusCodeSuccess;
	}
}
