/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

import java.util.List;

import org.eclipse.higgins.sts.api.IEndpointReference;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class EndpointReference implements IEndpointReference
{
	java.net.URI uriAddress = null;
	
	java.util.List listAnyOtherElements = new java.util.ArrayList();

	java.util.List listMetadataElements = new java.util.ArrayList();

	java.util.List listReferenceParametersElements = new java.util.ArrayList();
	
	String strIdentityCertificate = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IEndpointReference#getAddress()
	 */
	public java.net.URI getAddress()
	{
		return this.uriAddress;
	}
	
	public String getIdentityCertificate()
	{
		return this.strIdentityCertificate;
	}
	
	public void setIdentityCertificate(String strIdentityCertificate)
	{
		this.strIdentityCertificate = strIdentityCertificate;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IEndpointReference#getAnyOtherElements()
	 */
	public List getAnyOtherElements()
	{
		return this.listAnyOtherElements;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IEndpointReference#getMetadataElements()
	 */
	public List getMetadataElements()
	{
		return this.listMetadataElements;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IEndpointReference#getReferenceParametersElements()
	 */
	public List getReferenceParametersElements()
	{
		return this.listReferenceParametersElements;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IEndpointReference#setAddress(java.lang.String)
	 */
	public void setAddress(final java.net.URI uriAddress)
	{
		this.uriAddress = uriAddress;
	}
}
