/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

import org.eclipse.higgins.sts.api.IInformationCardReference;

/**
 * @author mikemci
 *
 */
public class InformationCardReference implements IInformationCardReference
{
	java.net.URI uriCardId = null;
	
	String strCardVersion = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IInformationCardReference#getCardId()
	 */
	public java.net.URI getCardId() {
		// TODO Auto-generated method stub
		return this.uriCardId;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IInformationCardReference#getCardVersion()
	 */
	public String getCardVersion() {
		// TODO Auto-generated method stub
		return this.strCardVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IInformationCardReference#setCardId(java.net.URI)
	 */
	public void setCardId(java.net.URI uriCardId) {
		// TODO Auto-generated method stub
		uriCardId = uriCardId.normalize();
		uriCardId = java.net.URI.create
	   		(uriCardId.toString().replaceFirst("%3F", "?"));
		this.uriCardId = uriCardId;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IInformationCardReference#setCardVersion(java.lang.String)
	 */
	public void setCardVersion(final String strCardVersion) {
		// TODO Auto-generated method stub
		this.strCardVersion = strCardVersion;
	}

}
