/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.common;

/**
 * Encapsulates values associated with the STS Request (RequestSecurityToken[Collection])
 * 
 * @author mikemci at us dot ibm dot com
 */
public class Message implements org.eclipse.higgins.sts.api.IMessage
{
	/**
	 * WS-Addressing Information
	 */
	private org.eclipse.higgins.sts.api.IAddressingInformation addressingInformation = null;
	
	/**
	 * WS-Security Information
	 */
	private org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = null;
	
	/**
	 * SOAP Message (original/raw)
	 */
	private org.eclipse.higgins.sts.api.IElement messageInformation = null;

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISTSRequest#getAddressingInformation()
	 */
	public org.eclipse.higgins.sts.api.IAddressingInformation getAddressingInformation()
	{
		return this.addressingInformation;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISTSRequest#getSecurityInformation()
	 */
	public org.eclipse.higgins.sts.api.ISecurityInformation getSecurityInformation()
	{
		return this.securityInformation;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISTSRequest#setAddressingInformation(org.eclipse.higgins.sts.IAddressingInformation)
	 */
	public void setAddressingInformation
		(final org.eclipse.higgins.sts.api.IAddressingInformation addressingInformation)
	{
		this.addressingInformation = addressingInformation;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISTSRequest#setSecurityInformation(org.eclipse.higgins.sts.ISecurityInformation)
	 */
	public void setSecurityInformation
		(final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation)
	{
		this.securityInformation = securityInformation;
	}

	public org.eclipse.higgins.sts.api.IElement getMessage()
	{
		return this.messageInformation;
	}

	public void setMessage
		(final org.eclipse.higgins.sts.api.IElement messageInformation)
	{
		this.messageInformation = messageInformation;
	}
}