/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

import java.util.List;

import org.eclipse.higgins.sts.api.ISecurityInformation;

/**
 * @author mikemci
 *
 */
public class SecurityInformation
	implements ISecurityInformation
{
	private java.util.List listSecurityElements = new java.util.ArrayList();
	
	private java.security.Key authenticationKey = null;
	
	public void setAuthenticationKey(java.security.Key authenticationKey)
	{
		this.authenticationKey = authenticationKey;
	}
	
	public java.security.Key getAuthenticationKey()
	{
		return authenticationKey;
	}
	
	public void addSecurityElement(final org.eclipse.higgins.sts.api.ISecurityElement element)
	{
		listSecurityElements.add(element);
	}

	public List getSecurityElementList() {
		return listSecurityElements;
	}
	
	public org.eclipse.higgins.sts.api.ISecurityElement getFirst(java.lang.Class cls)
	{
		for (int i = 0; i < listSecurityElements.size(); ++i)
		{
			org.eclipse.higgins.sts.api.ISecurityElement element = (org.eclipse.higgins.sts.api.ISecurityElement)listSecurityElements.get(i);
			if (cls.isInstance(element))
				return element;
		}
		return null;
	}
	
	public java.util.List getList(java.lang.Class cls)
	{
		java.util.List list = new java.util.ArrayList();
		for (int i = 0; i < listSecurityElements.size(); ++i)
		{
			org.eclipse.higgins.sts.api.ISecurityElement element = (org.eclipse.higgins.sts.api.ISecurityElement)listSecurityElements.get(i);
			if (cls.isInstance(element))
				list.add(element);
		}
		return list;
	}
}
