/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.common;

import java.util.Date;

/**
 * @author mikemci
 *
 */
public class UsernameToken
	implements org.eclipse.higgins.sts.api.IUsernameToken
{
	private org.apache.axiom.om.OMElement omUsernameToken = null;

	private org.apache.axiom.om.OMElement omUsername = null;

	private org.apache.axiom.om.OMElement omPassword = null;

	private org.apache.axiom.om.OMElement omNonce = null;

	private org.apache.axiom.om.OMElement omCreated = null;

	private java.net.URI uriWSSExtension = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
	
	private java.net.URI uriWSSUtility = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
	
	private javax.xml.namespace.QName qnameUsername = new javax.xml.namespace.QName
		(uriWSSExtension.toString(), "Username");
	
	private javax.xml.namespace.QName qnamePassword = new javax.xml.namespace.QName
		(uriWSSExtension.toString(), "Password");

	private javax.xml.namespace.QName qnameNonce = new javax.xml.namespace.QName
		(uriWSSExtension.toString(), "Nonce");

	private javax.xml.namespace.QName qnameCreated = new javax.xml.namespace.QName
		(uriWSSUtility.toString(), "Created");

	private final java.net.URI uriTokenType = java.net.URI.create
		("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
	
	private final org.apache.axiom.om.OMFactory omFactory = org.apache.axiom.om.OMAbstractFactory.getOMFactory();
	
	private final org.apache.axiom.om.OMNamespace omWSSExtensionNamespace = omFactory.createOMNamespace
		(uriWSSExtension.toString(),
		"wsse");
	
	private final org.apache.axiom.om.OMNamespace omWSSUtilityNamespace = omFactory.createOMNamespace
		(uriWSSUtility.toString(),
		"wsu");

	private void createUsernameToken()
	{
		if (null == omUsernameToken)
			omUsernameToken = omFactory.createOMElement("UsernameToken", omWSSExtensionNamespace);
	}
	
	private void createUsername()
	{
		createUsernameToken();
		if (null == omUsername)
			omUsername = omFactory.createOMElement("Username", omWSSExtensionNamespace, omUsernameToken);
	}
	
	private void createPassword()
	{
		createUsernameToken();
		if (null == omPassword)
		{
			omPassword = omFactory.createOMElement("Password", omWSSExtensionNamespace, omUsernameToken);
			omPassword.addAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText", null);
		}
	}
	
	private void createNonce()
	{
		createUsernameToken();
		if (null == omNonce)
		{
			omNonce = omFactory.createOMElement("Nonce", omWSSExtensionNamespace, omUsernameToken);
			omNonce.addAttribute("Encoding", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", null);
		}
	}
	
	private void createCreated()
	{
		createUsernameToken();
		if (null == omCreated)
			omCreated = omFactory.createOMElement("Created", omWSSUtilityNamespace, omUsernameToken);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#getUsername()
	 */
	public String getUsername()
	{
		String strUsername = null;
		if (null != omUsername)
			strUsername = omUsername.getText();
		return strUsername;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#getPassword()
	 */
	public String getPassword()
	{
		String strPassword = null;
		if (null != omPassword)
			strPassword = omPassword.getText();
		return strPassword;
	}
	
	/**
	 * @return the strNonce
	 */
	public String getNonce()
	{
		String strNonce = null;
		if (null != omNonce)
			strNonce = omNonce.getText();
		return strNonce;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ITimestamp#getCreated()
	 */
	public Date getCreated()
	{
		Date dtCreated = null;
		if (null != omCreated)
		{
			String strCreated = omCreated.getText();
			dtCreated = org.eclipse.higgins.sts.utilities.DateHelper.getDateFromIso8601(strCreated);
		}
		return dtCreated;
	}
	
	/**
	 * @return the uriTokenType
	 */
	public java.net.URI getTokenType()
	{
		return this.uriTokenType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#setUsername()
	 */
	public void setUsername(final String strUsername)
	{
		createUsername();
		omUsername.setText(strUsername);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityInformation#setPassword()
	 */
	public void setPassword(final String strPassword)
	{
		createPassword();
		omPassword.setText(strPassword);
	}
	
	/**
	 * @param strNonce the strNonce to set
	 */
	public void setNonce(String strNonce)
	{
		createNonce();
		omNonce.setText(strNonce);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.api.ITimestamp#setCreated(java.util.Date)
	 */
	public void setCreated(Date dtCreated)
	{
		createCreated();
		omCreated.setText(org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date(dtCreated));
	}

	public org.eclipse.higgins.sts.api.IElement toElement() throws Exception
	{
		org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
		elemToken.set(omUsernameToken);
		return elemToken;
	}
	
	public void fromElement(org.eclipse.higgins.sts.api.IElement element) throws Exception
	{
		omUsernameToken = (org.apache.axiom.om.OMElement)element.getAs(org.apache.axiom.om.OMElement.class);
		if (null != omUsernameToken)
		{
			omUsername = omUsernameToken.getFirstChildWithName(qnameUsername);
			omPassword = omUsernameToken.getFirstChildWithName(qnamePassword);
			omNonce = omUsernameToken.getFirstChildWithName(qnameNonce);
			omCreated = omUsernameToken.getFirstChildWithName(qnameCreated);
		}
	}
}
