/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * @author mikemci at us dot ibm dot com
 */
public class DateHelper2
{
	private static final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(DateHelper2.class.getName());

	public static String toString(final java.util.Date date)
	{
		final java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat
			("yyyy-MM-dd'T'HH:mm:ss'Z'");
		final java.util.TimeZone tz = java.util.TimeZone.getTimeZone
			("UTC");
		final java.text.FieldPosition fieldPosition = new java.text.FieldPosition(0);
		dateFormat.setTimeZone(tz);
		final StringBuffer strDateBuffer = new StringBuffer();
		final StringBuffer strDate = dateFormat.format
			(date, strDateBuffer, fieldPosition);
		return strDate.toString();
	}
	
	public static java.util.Date toDate(final String strDate)
	{
		final java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat
			("yyyy-MM-dd'T'HH:mm:ss'Z'");
		final java.util.TimeZone tz = java.util.TimeZone.getTimeZone
			("UTC");
		final java.text.ParsePosition parsePosition = new java.text.ParsePosition(0);
		dateFormat.setTimeZone(tz);		
		try
		{
			final java.util.Date date = dateFormat.parse
				(strDate.trim(),
				parsePosition);
			if (null == date)
			{
				DateHelper2.log.trace("toDate returning null");
			}
			return date;
		}
		catch (final Exception e)
		{
	    	org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(DateHelper2.log,
				e);	
		}
		return null;
	}
}
