/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class ExceptionHelper {
    public static void Log(LogHelper log, Exception exception) {
        if (exception instanceof InvocationTargetException) {
            InvocationTargetException outer = (InvocationTargetException)exception;
            Throwable nested = outer.getCause();
            String errMsg = MsgHelper.getString((String)"invocationtargetexception_cause", (Object)nested);
            log.error(errMsg);
            ExceptionHelper.Log(log, nested);
        } else {
            String strMessage = exception.getLocalizedMessage();
            if (strMessage != null) {
                String errMsg = MsgHelper.getString((String)"request_failed_with_exception", (Object)strMessage);
                log.error(errMsg);
            }
            log.error(exception);
            StackTraceElement[] ste = exception.getStackTrace();
            int i = 0;
            while (i < ste.length) {
                String strLine = MsgHelper.getString((String)"stacktraceelement_format_msg", (Object)ste[i].getClassName(), (Object)ste[i].getMethodName(), (Object)ste[i].getFileName(), (Object)String.valueOf(ste[i].getLineNumber()));
                log.error(strLine);
                ++i;
            }
        }
    }

    public static void Log(LogHelper log, Throwable throwable) {
        if (throwable == null) {
            String errMsg = MsgHelper.getString((String)"log_throwable_is_null");
            log.error(errMsg);
        } else if (throwable instanceof InvocationTargetException) {
            InvocationTargetException outer = (InvocationTargetException)throwable;
            Throwable nested = outer.getCause();
            String errMsg = MsgHelper.getString((String)"invocationtargetexception_cause", (Object)nested);
            log.error(errMsg);
            ExceptionHelper.Log(log, nested);
        } else {
            String strMessage = throwable.getLocalizedMessage();
            if (strMessage != null) {
                log.error(strMessage);
            }
            String errMsg = MsgHelper.getString((String)"request_failed_with_exception", (Object)throwable);
            log.error(errMsg);
            StackTraceElement[] ste = throwable.getStackTrace();
            int i = 0;
            while (i < ste.length) {
                String strLine = String.valueOf(ste[i].getClassName()) + "::" + ste[i].getMethodName() + " " + ste[i].getFileName() + ":" + ste[i].getLineNumber();
                log.error(strLine);
                ++i;
            }
        }
    }
}

