/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.utilities;

/**
 * @author mikemci
 *
 */
public class CertificateHelper
{
	static private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(CertificateHelper.class.getName());

	static private java.security.cert.CertificateFactory certificateFactory = null;
	
	static public java.security.cert.X509Certificate fromString(String cert)
	{
		try
		{
			if (null == certificateFactory)
				certificateFactory = java.security.cert.CertificateFactory.getInstance
					("X.509");
			final String strCertificate = "-----BEGIN CERTIFICATE-----\n"
				+ cert
				+ "\n-----END CERTIFICATE-----\n";
			final java.io.ByteArrayInputStream streamCertificate = new java.io.ByteArrayInputStream
				(strCertificate.getBytes("UTF-8"));
			return (java.security.cert.X509Certificate)certificateFactory.generateCertificate
				(streamCertificate);
		}
		catch (Exception ex)
		{
			ExceptionHelper.Log(log, ex);
		}
		return null;
	}
	
	/* From Daniel adapted by Mike */
	public static java.security.cert.X509Certificate findLeafFromCertificates(java.util.List listCerts)
	{
		if (0 == listCerts.size())
			return null;
		if (1 == listCerts.size())
			return (java.security.cert.X509Certificate)listCerts.get(0);

		// Find the leaf certificate (the one that no other certificate points to as its issuer
		java.util.HashMap issuerMap = new java.util.HashMap();
		java.util.ArrayList subjectList = new java.util.ArrayList();
	
		for (int iCert = 0; iCert < listCerts.size(); iCert++)
		{
			java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)listCerts.get(iCert);
			java.security.Principal	subjectDN = x509Certificate.getSubjectDN();
			String strSubject = subjectDN.getName();
			java.security.Principal	issuerDN = x509Certificate.getIssuerDN();
			String strIssuer = issuerDN.getName();
			issuerMap.put(strIssuer, strSubject);
			subjectList.add(strSubject);
		}
		for (int iCert = 0; iCert < subjectList.size(); iCert++)
		{
			String strSubject = (String)subjectList.get(iCert);
			if (null == issuerMap.get(strSubject))
			{
				log.trace("Found LEaf Certificate for Subject: " + strSubject);
				return (java.security.cert.X509Certificate)listCerts.get(iCert);
			}
		}
		return null;
	}
	
	public static java.security.cert.X509Certificate findLeafFromEncodedCertificates(java.util.List listEncodedCerts)
	{
		if (0 == listEncodedCerts.size())
			return null;
		if (1 == listEncodedCerts.size())
			return fromString((String)listEncodedCerts.get(0));
		java.util.List listCerts = new java.util.ArrayList();
		for (int iCert = 0; iCert < listEncodedCerts.size(); iCert++)
			listCerts.add(fromString((String)listEncodedCerts.get(iCert)));
		return findLeafFromCertificates(listCerts);
	}
}
