/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.informationcardgenerator;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.higgins.sts.informationcardgenerator.InfoCardException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class InfoCard {
    private X509Certificate m_certificateSigner = null;
    private X509Certificate m_certificateMEX = null;
    private String m_strCertificateMEX = null;
    private String m_strCertificateSigner = null;
    private PrivateKey m_privateKeySigner = null;
    private DocumentBuilder m_documentBuilder = null;
    private Document m_docCard = null;
    private Element m_elemCard = null;
    private Element m_elemCardRef = null;
    private Element m_elemCardTokenServiceList = null;
    private Element m_elemCardSupportedTokenTypeList = null;
    private Element m_elemCardSupportedClaimTypeList = null;
    private static final String strCardIssuerTag = "Issuer";
    private static final String strTimeIssuedTag = "TimeIssued";
    private static final String strTimeExpiresTag = "TimeExpires";
    private static final String strPrivacyNoticeTag = "PrivacyNotice";
    private static final String strRequireAppliesToTag = "RequireAppliesTo";
    private static final String strCardRefTag = "InformationCardReference";
    private static final String strCardNameTag = "CardName";
    private static final String strCardVersionTag = "CardVersion";
    private static final String strCardIdTag = "CardId";
    private static final String strCardImageTag = "CardImage";
    private static final String strUserCredentialTag = "UserCredential";
    private static final String strTokenTypeTag = "TokenType";

    private void _init(PrivateKey privateKeySigner, X509Certificate certificateSigner, X509Certificate certificateMEX) throws InfoCardException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.m_documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to allocate a document builder");
        }
        this.m_docCard = this.m_documentBuilder.newDocument();
        try {
            Init.init();
            Constants.setSignatureSpecNSprefix((String)"");
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to initialize security subsystem");
        }
        this.m_privateKeySigner = privateKeySigner;
        this.m_certificateSigner = certificateSigner;
        this.m_certificateMEX = certificateMEX;
        try {
            this.m_strCertificateSigner = Base64.encode((byte[])this.m_certificateSigner.getEncoded(), (int)0);
            this.m_strCertificateSigner = InfoCard.stripNewLinesFromString(this.m_strCertificateSigner);
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to encode certificate");
        }
        try {
            this.m_strCertificateMEX = Base64.encode((byte[])this.m_certificateMEX.getEncoded(), (int)0);
            this.m_strCertificateMEX = InfoCard.stripNewLinesFromString(this.m_strCertificateMEX);
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to encode certificate");
        }
        this.m_elemCard = this.m_docCard.createElement("ic:InformationCard");
        this.m_elemCard.setAttribute("xmlns:ic", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        this.m_elemCard.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        this.m_elemCard.setAttribute("xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.m_elemCard.setAttribute("xml:lang", "en-us");
        this.m_elemCardRef = this.m_docCard.createElement("ic:InformationCardReference");
        this.m_elemCard.appendChild(this.m_elemCardRef);
        this.m_elemCard.appendChild(this.m_docCard.createElement("ic:CardName"));
        this.m_elemCard.appendChild(this.m_docCard.createElement("ic:CardImage"));
        this.m_elemCard.appendChild(this.m_docCard.createElement("ic:Issuer"));
        this.m_elemCard.appendChild(this.m_docCard.createElement("ic:TimeIssued"));
        this.m_elemCard.appendChild(this.m_docCard.createElement("ic:TimeExpires"));
        this.m_elemCardTokenServiceList = this.m_docCard.createElement("ic:TokenServiceList");
        this.m_elemCard.appendChild(this.m_elemCardTokenServiceList);
        this.m_elemCardSupportedTokenTypeList = this.m_docCard.createElement("ic:SupportedTokenTypeList");
        this.m_elemCard.appendChild(this.m_elemCardSupportedTokenTypeList);
        this.m_elemCardSupportedClaimTypeList = this.m_docCard.createElement("ic:SupportedClaimTypeList");
        this.m_elemCard.appendChild(this.m_elemCardSupportedClaimTypeList);
    }

    public InfoCard(PrivateKey privateKeySigner, X509Certificate certificateSigner, X509Certificate certificateMEX) throws InfoCardException {
        this._init(privateKeySigner, certificateSigner, certificateMEX);
    }

    public InfoCard(String strSignerKeystoreType, String strSignerKeystoreFile, String strSignerKeystorePassword, String strSignerCertificateAlias, String strSignerKeyAlias, String strSignerKeyPassword, String strMEXKeystoreType, String strMEXKeystoreFile, String strMEXKeystorePassword, String strMEXCertificateAlias) throws InfoCardException {
        X509Certificate certificateMEX;
        X509Certificate certificateSigner;
        PrivateKey privateKeySigner;
        KeyStore ksSigner = this.loadKeyStore(strSignerKeystoreType, strSignerKeystoreFile, strSignerKeystorePassword);
        try {
            privateKeySigner = (PrivateKey)ksSigner.getKey(strSignerKeyAlias, strSignerKeyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to retrieve private key");
        }
        try {
            certificateSigner = (X509Certificate)ksSigner.getCertificate(strSignerCertificateAlias);
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to retrieve certificate");
        }
        KeyStore ksMEX = this.loadKeyStore(strMEXKeystoreType, strMEXKeystoreFile, strMEXKeystorePassword);
        try {
            certificateMEX = (X509Certificate)ksMEX.getCertificate(strMEXCertificateAlias);
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to retrieve certificate");
        }
        this._init(privateKeySigner, certificateSigner, certificateMEX);
    }

    public static void createInfoCard(String strSignerKeystoreType, String strSignerKeystoreFile, String strSignerKeystorePassword, String strSignerCertificateAlias, String strSignerKeyAlias, String strSignerKeyPassword, String strMEXKeystoreType, String strMEXKeystoreFile, String strMEXKeystorePassword, String strMEXCertificateAlias, String strCardId, String strCardVersion, String strCardName, String strCardExpiration, String strCardImageFileName, String strIssuerURI, String strSTSEndpointReference, String strMEXEndpointReference, String strUsername, String[] strClaims, String strCardFileName) throws InfoCardException {
        InfoCard infoCard = new InfoCard(strSignerKeystoreType, strSignerKeystoreFile, strSignerKeystorePassword, strSignerCertificateAlias, strSignerKeyAlias, strSignerKeyPassword, strMEXKeystoreType, strMEXKeystoreFile, strMEXKeystorePassword, strMEXCertificateAlias);
        infoCard.setCardReference(strCardId, strCardVersion);
        infoCard.setIssuerURI(strIssuerURI);
        infoCard.setCardName(strCardName);
        infoCard.setCardExpiration(new Integer(strCardExpiration).intValue());
        Element elemUserCredential = infoCard.buildUsernamePasswordCredential(strUsername, null);
        infoCard.addTokenServiceRef(strSTSEndpointReference, strMEXEndpointReference, elemUserCredential);
        if (strCardImageFileName != null) {
            infoCard.setCardImage(strCardImageFileName);
        }
        if (strClaims != null) {
            for (int idx = 0; idx < strClaims.length; ++idx) {
                infoCard.addSupportedClaim(strClaims[idx], strClaims[idx], strClaims[idx]);
            }
        }
        infoCard.toFile(strCardFileName);
    }

    public void setCardReference(String strCardId, String strCardVersion) {
        Element elemCardRef = this.m_docCard.createElement("ic:InformationCardReference");
        Element elemCardId = this.m_docCard.createElement("ic:CardId");
        elemCardId.appendChild(this.m_docCard.createTextNode(strCardId));
        elemCardRef.appendChild(elemCardId);
        Element elemCardVer = this.m_docCard.createElement("ic:CardVersion");
        elemCardVer.appendChild(this.m_docCard.createTextNode(strCardVersion));
        elemCardRef.appendChild(elemCardVer);
        if (this.m_elemCardRef != null) {
            this.m_elemCard.replaceChild(elemCardRef, this.m_elemCardRef);
            this.m_elemCardRef = elemCardRef;
        } else {
            this.m_elemCardRef = elemCardRef;
            this.m_elemCard.appendChild(this.m_elemCardRef);
        }
    }

    public void setCardName(String strCardName) {
        this.updateChildElement(this.m_elemCard, "ic", strCardNameTag, strCardName);
    }

    public void setCardExpiration(long lExpireGMTTime) {
        if (lExpireGMTTime == 0L) {
            this.updateChildElement(this.m_elemCard, "ic", strTimeExpiresTag, "9999-12-31T23:59:59.9999999Z");
        } else {
            this.updateChildElement(this.m_elemCard, "ic", strTimeExpiresTag, this.getDateString(lExpireGMTTime));
        }
    }

    public void setCardExpiration(String sExpireTime) {
        if (sExpireTime == null || sExpireTime == "") {
            this.updateChildElement(this.m_elemCard, "ic", strTimeExpiresTag, "9999-12-31T23:59:59.9999999Z");
        } else {
            this.updateChildElement(this.m_elemCard, "ic", strTimeExpiresTag, sExpireTime);
        }
    }

    public void addTokenServiceRef(String stsURI, String mexURI, Element elemUserCredential) throws InfoCardException {
        Element elemTokenService = this.m_docCard.createElement("ic:TokenService");
        this.m_elemCardTokenServiceList.appendChild(elemTokenService);
        Element elemEndpointRef = this.m_docCard.createElement("wsa:EndpointReference");
        elemEndpointRef.setAttribute("xmlns:wsa", "http://www.w3.org/2005/08/addressing");
        elemTokenService.appendChild(elemEndpointRef);
        Element elemAddress = this.m_docCard.createElement("wsa:Address");
        elemAddress.appendChild(this.m_docCard.createTextNode(stsURI));
        elemEndpointRef.appendChild(elemAddress);
        Element elemWsaMetadata = this.m_docCard.createElement("wsa:Metadata");
        elemEndpointRef.appendChild(elemWsaMetadata);
        Element elemMexMetadata = this.m_docCard.createElement("mex:Metadata");
        elemMexMetadata.setAttribute("xmlns:mex", "http://schemas.xmlsoap.org/ws/2004/09/mex");
        elemWsaMetadata.appendChild(elemMexMetadata);
        Element elemMetadataSection = this.m_docCard.createElement("mex:MetadataSection");
        elemMexMetadata.appendChild(elemMetadataSection);
        Element elemMetadataReference = this.m_docCard.createElement("mex:MetadataReference");
        elemMetadataSection.appendChild(elemMetadataReference);
        Element elemMexAddress = this.m_docCard.createElement("wsa:Address");
        elemMexAddress.appendChild(this.m_docCard.createTextNode(mexURI));
        elemMetadataReference.appendChild(elemMexAddress);
        Element elemIdentity = this.m_docCard.createElement("wsai:Identity");
        elemIdentity.setAttribute("xmlns:wsai", "http://schemas.xmlsoap.org/ws/2006/02/addressingidentity");
        elemEndpointRef.appendChild(elemIdentity);
        Element elemKeyInfo = this.m_docCard.createElement("dsig:KeyInfo");
        elemKeyInfo.setAttribute("xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
        elemIdentity.appendChild(elemKeyInfo);
        Element elemX509Data = this.m_docCard.createElement("dsig:X509Data");
        elemKeyInfo.appendChild(elemX509Data);
        Element elemX509Certificate = this.m_docCard.createElement("dsig:X509Certificate");
        elemX509Certificate.appendChild(this.m_docCard.createTextNode(this.m_strCertificateMEX));
        elemX509Data.appendChild(elemX509Certificate);
        elemTokenService.appendChild(elemUserCredential);
    }

    public void addSupportedClaim(String strClaimURI, String strClaimDisplayTag, String strClaimDescription) {
        Element elemClaimType = this.m_docCard.createElement("ic:SupportedClaimType");
        elemClaimType.setAttribute("Uri", strClaimURI);
        this.m_elemCardSupportedClaimTypeList.appendChild(elemClaimType);
        if (strClaimDisplayTag != null) {
            Element elemDisplayTag = this.m_docCard.createElement("ic:DisplayTag");
            elemDisplayTag.appendChild(this.m_docCard.createTextNode(strClaimDisplayTag));
            elemClaimType.appendChild(elemDisplayTag);
        }
        if (strClaimDescription != null) {
            Element elemDescription = this.m_docCard.createElement("ic:Description");
            elemDescription.appendChild(this.m_docCard.createTextNode(strClaimDescription));
            elemClaimType.appendChild(elemDescription);
        }
    }

    public void addSupportedTokenType(String strTokenTypeURI) {
        Element elemTokenType = this.m_docCard.createElement("trust:TokenType");
        elemTokenType.setAttribute("xmlns:trust", "http://schemas.xmlsoap.org/ws/2005/02/trust");
        elemTokenType.appendChild(this.m_docCard.createTextNode(strTokenTypeURI));
        this.m_elemCardSupportedTokenTypeList.appendChild(elemTokenType);
    }

    public Element buildUsernamePasswordCredential(String strUserName, String strHint) {
        if (strHint == null) {
            strHint = "Enter your username and password";
        }
        Element elemUserCredential = this.m_docCard.createElement("ic:UserCredential");
        Element elemCredentialHint = this.m_docCard.createElement("ic:DisplayCredentialHint");
        elemCredentialHint.appendChild(this.m_docCard.createTextNode(strHint));
        elemUserCredential.appendChild(elemCredentialHint);
        Element elemUsernamePasswordCredential = this.m_docCard.createElement("ic:UsernamePasswordCredential");
        elemUserCredential.appendChild(elemUsernamePasswordCredential);
        Element elemUsername = this.m_docCard.createElement("ic:Username");
        elemUsername.appendChild(this.m_docCard.createTextNode(strUserName));
        elemUsernamePasswordCredential.appendChild(elemUsername);
        return elemUserCredential;
    }

    public Element buildSelfIssuedCredential(String strPPID) {
        Element elemUserCredential = this.m_docCard.createElement("ic:UserCredential");
        Element elemSelfIssuedCredential = this.m_docCard.createElement("ic:SelfIssuedCredential");
        elemUserCredential.appendChild(elemSelfIssuedCredential);
        Element elemPrivatePersonalIdentifier = this.m_docCard.createElement("ic:PrivatePersonalIdentifier");
        elemPrivatePersonalIdentifier.appendChild(this.m_docCard.createTextNode(strPPID));
        elemSelfIssuedCredential.appendChild(elemPrivatePersonalIdentifier);
        return elemUserCredential;
    }

    public Element buildX509CertificateCredential(String strCertThumbprint, String strHint) {
        Element elemUserCredential = this.m_docCard.createElement("ic:UserCredential");
        if (strHint != null && !strHint.trim().equals("")) {
            Element elemCredentialHint = this.m_docCard.createElement("ic:DisplayCredentialHint");
            elemCredentialHint.appendChild(this.m_docCard.createTextNode(strHint));
            elemUserCredential.appendChild(elemCredentialHint);
        }
        Element elemX509V3Credential = this.m_docCard.createElement("ic:X509V3Credential");
        elemUserCredential.appendChild(elemX509V3Credential);
        Element elemX509Data = this.m_docCard.createElement("ds:X509Data");
        elemX509V3Credential.appendChild(elemX509Data);
        Element elemKeyIdentifier = this.m_docCard.createElement("wsse:KeyIdentifier");
        elemX509Data.appendChild(elemKeyIdentifier);
        elemKeyIdentifier.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis200401-wss-soap-message-security-1.0#Base64Binary");
        elemKeyIdentifier.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-message-security-1.1#ThumbprintSHA1");
        elemKeyIdentifier.appendChild(this.m_docCard.createTextNode(strCertThumbprint));
        return elemUserCredential;
    }

    public void setCardImage(String strImageFileName) throws InfoCardException {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image tmpImage = toolkit.getImage(strImageFileName);
            tmpImage = new ImageIcon(tmpImage).getImage();
            this.setCardImage(tmpImage);
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to render card image");
        }
    }

    public void setCardImage(Image image) throws InfoCardException {
        String strCardImage;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image cardPicture = image.getScaledInstance(200, 150, 1);
            cardPicture = new ImageIcon(cardPicture).getImage();
            ByteArrayOutputStream imageBufferStream = new ByteArrayOutputStream();
            BufferedImage bi = new BufferedImage(cardPicture.getWidth(null), cardPicture.getHeight(null), 1);
            Graphics bg = bi.getGraphics();
            bg.drawImage(cardPicture, 0, 0, null);
            bg.dispose();
            ImageIO.write((RenderedImage)bi, "PNG", imageBufferStream);
            strCardImage = Base64.encode((byte[])imageBufferStream.toByteArray(), (int)0);
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to render card image");
        }
        try {
            Element elemCardImage = this.m_docCard.createElement("ic:CardImage");
            elemCardImage.setAttribute("MimeType", "image/png");
            elemCardImage.appendChild(this.m_docCard.createTextNode(strCardImage));
            Element elemOldCardImage = this.getFirstChildElement(this.m_elemCard, "ic", strCardImageTag);
            if (elemOldCardImage != null) {
                this.m_elemCard.replaceChild(elemCardImage, elemOldCardImage);
            } else {
                this.m_elemCard.appendChild(elemCardImage);
            }
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to set card image");
        }
    }

    public void setCardImage(String strBase64EncodedImage, String strMimeType) throws InfoCardException {
        try {
            Element elemCardImage = this.m_docCard.createElement("ic:CardImage");
            elemCardImage.setAttribute("MimeType", strMimeType);
            elemCardImage.appendChild(this.m_docCard.createTextNode(strBase64EncodedImage));
            Element elemOldCardImage = this.getFirstChildElement(this.m_elemCard, "ic", strCardImageTag);
            if (elemOldCardImage != null) {
                this.m_elemCard.replaceChild(elemCardImage, elemOldCardImage);
            } else {
                this.m_elemCard.appendChild(elemCardImage);
            }
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to set card image");
        }
    }

    public void setIssuerURI(String strValue) {
        this.updateChildElement(this.m_elemCard, "ic", strCardIssuerTag, strValue);
    }

    public void setPrivacyNoticeURI(String strValue) {
        this.updateChildElement(this.m_elemCard, "ic", strPrivacyNoticeTag, strValue);
    }

    public void setRequiresAppliesTo() {
        this.updateChildElement(this.m_elemCard, "ic", strRequireAppliesToTag, null);
    }

    public void setCardID(String strValue) {
        this.updateChildElement(this.m_elemCardRef, "ic", strCardIdTag, strValue);
    }

    public void setCardVersion(int iValue) {
        this.updateChildElement(this.m_elemCardRef, "ic", strCardVersionTag, new Integer(iValue).toString());
    }

    public void setCardVersion(String strValue) {
        this.setCardVersion(new Integer(strValue));
    }

    public String toXML() throws InfoCardException {
        Element elemSignedCard;
        String strSignedCard = null;
        String strId = "IC01";
        this.updateChildElement(this.m_elemCard, "ic", strTimeIssuedTag, this.getDateString(0L));
        this.validateCard();
        try {
            XMLSignature xmlSignature;
            if (this.getFirstChildElement(this.m_elemCardSupportedTokenTypeList, "ic", strTokenTypeTag) == null) {
                this.addSupportedTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                this.addSupportedTokenType("urn:oasis:names:tc:SAML:1.0:assertion");
            }
            Document docSignedCard = this.m_documentBuilder.newDocument();
            Element reparsedCard = this.reparseElement(this.m_elemCard);
            Element elemCardImage = this.getFirstChildElement(reparsedCard, "ic", strCardImageTag);
            if (elemCardImage != null && this.getFirstChildTextNode(elemCardImage) == null) {
                reparsedCard.removeChild(elemCardImage);
            }
            try {
                xmlSignature = new XMLSignature(docSignedCard, "", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
            }
            catch (Exception e) {
                throw new InfoCardException("Error creating XMLSignature: " + e.getMessage());
            }
            ObjectContainer objectContainer = new ObjectContainer(docSignedCard);
            objectContainer.appendChild(docSignedCard.importNode(reparsedCard, true));
            objectContainer.setId(strId);
            xmlSignature.appendObject(objectContainer);
            Transforms transforms = new Transforms(docSignedCard);
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            xmlSignature.addDocument("#" + strId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            xmlSignature.addKeyInfo(this.m_certificateSigner);
            xmlSignature.sign((Key)this.m_privateKeySigner);
            elemSignedCard = xmlSignature.getElement();
        }
        catch (Exception e) {
            throw new InfoCardException("Error signing card: " + e.getMessage());
        }
        try {
            strSignedCard = this.serializeToString(elemSignedCard);
            int iIndex = strSignedCard.indexOf("</Signature>");
            if (iIndex != -1) {
                StringBuffer sbValue = new StringBuffer(strSignedCard);
                --iIndex;
                while (sbValue.charAt(iIndex) == '\n' || sbValue.charAt(iIndex) == '\r') {
                    sbValue.deleteCharAt(iIndex);
                    --iIndex;
                }
                strSignedCard = sbValue.toString();
            }
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to serialize card");
        }
        return strSignedCard;
    }

    public Element reparseElement(Element domElement) throws InfoCardException {
        if (domElement == null) {
            return null;
        }
        String strElement = this.serializeToString(domElement);
        return this.toDOM(strElement);
    }

    public Element toDOM(String strElement) throws InfoCardException {
        Document docElement = null;
        if (strElement == null) {
            return null;
        }
        try {
            docElement = this.m_documentBuilder.parse(new ByteArrayInputStream(strElement.getBytes()));
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to create document");
        }
        return docElement.getDocumentElement();
    }

    public void toFile(String strFileName) throws InfoCardException {
        try {
            String strOutCard = this.toXML();
            FileOutputStream crdOutFile = new FileOutputStream(strFileName);
            crdOutFile.write(strOutCard.getBytes(), 0, strOutCard.length());
            crdOutFile.flush();
            crdOutFile.close();
        }
        catch (Exception e) {
            throw new InfoCardException("Error writing card to file: " + e.getMessage());
        }
    }

    private void verifyFile(String strFileName) throws Exception {
        String strCard = null;
        String strId = "IC01";
        FileInputStream crdInFile = new FileInputStream(strFileName);
        byte[] crdBuffer = new byte[crdInFile.available()];
        crdInFile.read(crdBuffer);
        crdInFile.close();
        strCard = new String(crdBuffer, 0, crdBuffer.length, "UTF-8");
        Element domParsed = this.toDOM(strCard);
        XMLSignature xmlSignature = new XMLSignature(domParsed, "");
        if (!xmlSignature.checkSignatureValue(this.m_certificateSigner)) {
            throw new InfoCardException("Signature verification failed for " + strFileName);
        }
    }

    private Element getFirstChildElement(Element elemParent, String strPrefix, String strChildTag) {
        Element elemChild = null;
        for (Node nodeChild = elemParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            if (nodeChild instanceof Element) {
                elemChild = (Element)nodeChild;
                if (strChildTag == null || elemChild.getNodeName().equals(strPrefix + ":" + strChildTag)) break;
            }
            elemChild = null;
        }
        return elemChild;
    }

    private Text getFirstChildTextNode(Element elemParent) {
        Text textChild = null;
        for (Node nodeChild = elemParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            if (!(nodeChild instanceof Text)) continue;
            textChild = (Text)nodeChild;
            break;
        }
        return textChild;
    }

    private void updateChildElement(Element elemParent, String strPrefix, String strChildTag, String strChildValue) {
        Element elemChild = this.getFirstChildElement(elemParent, strPrefix, strChildTag);
        if (elemChild == null) {
            elemChild = this.m_docCard.createElement(strPrefix + ":" + strChildTag);
            elemParent.appendChild(elemChild);
        } else {
            Text textChild = this.getFirstChildTextNode(elemChild);
            if (textChild != null) {
                elemChild.removeChild(textChild);
            }
        }
        if (strChildValue != null) {
            elemChild.appendChild(this.m_docCard.createTextNode(strChildValue));
        }
    }

    private String getDateString(long lGMTDate) {
        StringBuffer strDateTime = new StringBuffer();
        Date date = lGMTDate == 0L ? new Date() : new Date(lGMTDate);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        strDateTime.append(dateFormat.format(date));
        strDateTime.append("T");
        strDateTime.append(timeFormat.format(date));
        strDateTime.append("Z");
        return strDateTime.toString();
    }

    public KeyStore loadKeyStore(String strStoreType, String strFile, String strPassword) throws InfoCardException {
        KeyStore keyStore;
        try {
            FileInputStream storeFile = new FileInputStream(strFile);
            keyStore = KeyStore.getInstance(strStoreType);
            keyStore.load(storeFile, strPassword.toCharArray());
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to load key store");
        }
        return keyStore;
    }

    public void validateCard() throws InfoCardException {
        if (this.m_elemCardRef == null) {
            throw new InfoCardException("Missing InformationCardReference");
        }
        Element elemTmp = this.getFirstChildElement(this.m_elemCardRef, "ic", strCardIdTag);
        if (elemTmp == null) {
            throw new InfoCardException("Missing CardId");
        }
        try {
            new URI(this.getTextValue(elemTmp));
        }
        catch (Exception e) {
            throw new InfoCardException("Invalid CardId: " + this.getTextValue(elemTmp));
        }
        elemTmp = this.getFirstChildElement(this.m_elemCardRef, "ic", strCardVersionTag);
        if (elemTmp == null) {
            throw new InfoCardException("Missing CardVersion");
        }
        try {
            new Integer(this.getTextValue(elemTmp));
        }
        catch (Exception e) {
            throw new InfoCardException("Invalid CardVersion");
        }
        elemTmp = this.getFirstChildElement(this.m_elemCard, "ic", strCardNameTag);
        if (elemTmp == null) {
            throw new InfoCardException("Missing CardName");
        }
        if (this.getTextValue(elemTmp) == null || this.getTextValue(elemTmp).equals("")) {
            throw new InfoCardException("Invalid CardName");
        }
        elemTmp = this.getFirstChildElement(this.m_elemCard, "ic", strCardIssuerTag);
        if (elemTmp == null) {
            throw new InfoCardException("Missing Issuer URI");
        }
        try {
            new URI(this.getTextValue(elemTmp));
        }
        catch (Exception e) {
            throw new InfoCardException("Invalid Issuer");
        }
        elemTmp = this.getFirstChildElement(this.m_elemCard, "ic", strTimeIssuedTag);
        if (elemTmp == null) {
            throw new InfoCardException("Missing TimeIssued");
        }
        elemTmp = this.getFirstChildElement(this.m_elemCard, "ic", strTimeExpiresTag);
        if (elemTmp == null) {
            throw new InfoCardException("Missing TimeExpires");
        }
    }

    private String getTextValue(Element elemParent) {
        Node nodeChild;
        for (nodeChild = elemParent.getFirstChild(); nodeChild != null && !(nodeChild instanceof Text); nodeChild = nodeChild.getNextSibling()) {
        }
        return nodeChild == null ? null : nodeChild.getNodeValue();
    }

    private String serializeToString(Element elemRoot) throws InfoCardException {
        String strOutput;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setLineWidth(0);
            outputFormat.setIndenting(false);
            outputFormat.setPreserveSpace(true);
            outputFormat.setOmitXMLDeclaration(true);
            XMLSerializer xmlSerializer = new XMLSerializer((OutputStream)outputStream, outputFormat);
            xmlSerializer.setNamespaces(true);
            xmlSerializer.serialize(elemRoot);
            strOutput = outputStream.toString("UTF-8");
        }
        catch (Exception e) {
            throw new InfoCardException("Unable to serialize XML");
        }
        return strOutput;
    }

    public static String stripNewLinesFromString(String strValue) {
        StringBuffer sbValue;
        int iIndex = strValue.indexOf(13);
        while (iIndex != -1) {
            sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(iIndex);
            strValue = sbValue.toString();
            iIndex = strValue.indexOf(13);
        }
        iIndex = strValue.indexOf(10);
        while (iIndex != -1) {
            sbValue = new StringBuffer(strValue);
            sbValue.deleteCharAt(iIndex);
            strValue = sbValue.toString();
            iIndex = strValue.indexOf(10);
        }
        return strValue;
    }
}

