/**
 * 
 */
package org.eclipse.higgins.sts.server.mapper.appliesto;

import java.util.Map;

import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.spi.IExtensionMapper;

/**
 * @author mikemci
 *
 */
public class AppliesToMapper
	implements IExtensionMapper
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(AppliesToMapper.class.getName());

	boolean bInitialized = false;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.IExtensionMapper#configure(java.lang.String, java.util.Map)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
	{
		this.bInitialized = true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.IExtensionMapper#getConfiguration(org.eclipse.higgins.sts.ISTSRequest, java.util.Map, org.eclipse.higgins.sts.IConstants)
	 */
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.mapper.appliesto.IExtensionMapper#getConfiguration(java.util.Map, java.lang.String, java.util.Map, java.util.Map, org.eclipse.higgins.sts.api.IConstants, org.eclipse.higgins.sts.api.ISTSRequest)
	 */
	public String getConfiguration
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request)
	{
		this.log.trace("AppliesToMapper::getConfiguration");
		if (!this.bInitialized)
		{
			this.log.error("Not Initialized");
			return null;
		}
		final java.util.Map mapAppliesTo = (java.util.Map)mapComponentSettings.get("AppliesToMap");
		if (null == mapAppliesTo) {
			return null;
		}
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
		final org.eclipse.higgins.sts.api.IAppliesTo appliesToRequest = RST.getAppliesTo();
		if (appliesToRequest != null)
		{
			final org.eclipse.higgins.sts.api.IEndpointReference eprAppliesTo = appliesToRequest.getEndpointReference();
			final java.net.URI uriAppliesTo = eprAppliesTo.getAddress();
			this.log.trace("AppliesTo: " + uriAppliesTo.toString() + "(" + uriAppliesTo.hashCode() + ")");
			AppliesToMapping mapping = (AppliesToMapping)mapAppliesTo.get(uriAppliesTo);
			if (null == mapping)
			{
				this.log.trace("No Mapping Found - trying wildcard mapping");
				final java.net.URI uriWildcard = java.net.URI.create("urn:any");
				mapping = (AppliesToMapping)mapAppliesTo.get(uriWildcard);
			}
			if (null != mapping)
			{
				final java.net.URI uriTokenType = mapping.getTokenType();
				if (null != uriTokenType) {
					RST.setTokenType(uriTokenType);
				}
				final java.net.URI uriIssuer = mapping.getIssuer();
				if (null != uriIssuer)
				{
					final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = new org.eclipse.higgins.sts.common.EndpointReference();
					eprIssuer.setAddress(uriIssuer);
					RST.setIssuer(eprIssuer);
				}
			}
		}
		return null;
	}
}
