/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.appliesto;

/**
 * Used for mapping RequestSecurityToken values to the appropriate extension.
 * 
 * @author mikemci at us dot ibm dot com
 *
 */
public class AppliesToMapping
{
	private java.net.URI uriTokenType = null;
	private java.net.URI uriIssuer = null;
	
	public AppliesToMapping
		(final java.net.URI uriTokenType,
		final java.net.URI uriIssuer)
	{
		this.uriTokenType = uriTokenType;
		this.uriIssuer = uriIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAppliesToMapping#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1; //super.hashCode();
		result = PRIME * result + ((this.uriIssuer == null) ? 0 : this.uriIssuer.hashCode());
		result = PRIME * result + ((this.uriTokenType == null) ? 0 : this.uriTokenType.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAppliesToMapping#equals(java.lang.Object)
	 */
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (this.getClass() != obj.getClass()) {
			return false;
		}
		final AppliesToMapping other = (AppliesToMapping) obj;
		if (this.uriIssuer == null) {
			if (other.uriIssuer != null) {
				return false;
			}
		} else if (!this.uriIssuer.equals(other.uriIssuer)) {
			return false;
		}
		if (this.uriTokenType == null) {
			if (other.uriTokenType != null) {
				return false;
			}
		} else if (!this.uriTokenType.equals(other.uriTokenType)) {
			return false;
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAppliesToMapping#getIssuer()
	 */
	public java.net.URI getIssuer()
	{
		return this.uriIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAppliesToMapping#setIssuer(java.net.URI)
	 */
	public void setIssuer
		(final java.net.URI uriIssuer)
	{
		this.uriIssuer = uriIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAppliesToMapping#getTokenType()
	 */
	public java.net.URI getTokenType()
	{
		return this.uriTokenType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IAppliesToMapping#setTokenType(java.net.URI)
	 */
	public void setTokenType
		(final java.net.URI uriTokenType)
	{
		this.uriTokenType = uriTokenType;
	}
}
