/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.appliesto;

import java.util.Map;

import org.eclipse.higgins.configuration.xml.ISettingHandler;

/**
 * @author mikemci
 *
 */
public class AppliesToMappingHandler implements ISettingHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(AppliesToMappingHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.binding.axis1x.configuration.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(final String strName,
		final String strConfigurationBase,
		final Map mapSettingHandlers,
		final Map mapSettings,
		final Object objectParent,
		final org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{
		this.log.trace("Setting Name: " + strName + " *Begin AppliesToMapping*");
		final ISettingHandler handlerMap = (ISettingHandler)mapSettingHandlers.get
			("htf:map");
		if (null == handlerMap)
		{
			this.log.error("SettingHandler not found for type: htf:map");
			throw new Exception("SettingHandler not found for type: htf:map");
		}
		final Map mapExtensionMapKeySettings = (Map)handlerMap.getSetting
			(strName,
			strConfigurationBase,
			mapSettingHandlers,
			mapSettings,
			objectParent,
			omSetting);
		final java.net.URI uriTokenType = (java.net.URI)mapExtensionMapKeySettings.get
			("TokenType");
		if (null != uriTokenType) {
			this.log.trace("TokenType Value: " + uriTokenType.toString() + " HashCode: " + uriTokenType.hashCode());
		}
		final java.net.URI uriIssuer = (java.net.URI)mapExtensionMapKeySettings.get
			("Issuer");
		if (null != uriIssuer) {
			this.log.trace("Issuer Value: " + uriIssuer.toString() + " HashCode: " + uriIssuer.hashCode());
		}
		final Object objectResult = new AppliesToMapping
			(uriTokenType,
			uriIssuer);
		this.log.trace("Setting Name: " + strName + " *End AppliesToMapping*");
		return objectResult;

	}
}
