/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.appliesto;

import java.util.Map;
import org.eclipse.higgins.configuration.xml.ISettingHandler;

/**
 * @author mikemci
 *
 */
public class AppliesToMapHandler implements ISettingHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(AppliesToMapHandler.class.getName());
	
	private final javax.xml.namespace.QName qnameName = new javax.xml.namespace.QName
		(null,
		"Name");


	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.binding.axis1x.configuration.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{	
		this.log.trace("Setting Name: " + strName + " *Begin AppliesToMap*");
		final ISettingHandler handlerMap = (ISettingHandler)mapSettingHandlers.get
			("htf:map");
		if (null == handlerMap)
		{
			this.log.error("SettingHandler not found for type: htf:map");
			throw new Exception("SettingHandler not found for type: htf:map");
		}
		final Map mapResult = new java.util.Hashtable();
		final java.util.Iterator iterChildren = omSetting.getChildElements();
		while (iterChildren.hasNext())
		{
			final org.apache.axiom.om.OMElement omChild = (org.apache.axiom.om.OMElement)iterChildren.next();
			final String strSettingName = omChild.getAttributeValue(this.qnameName);
			final Object objectValue = handlerMap.getSetting
				(strSettingName,
				strConfigurationBase,
				mapSettingHandlers,
				mapSettingsGlobal,
				omSetting,
				omChild);
			final Map mapValue = (Map)objectValue;
			final Object objectAppliesTo = mapValue.get("AppliesTo");
			final Object objectAppliesToMapping = mapValue.get("AppliesToMapping");
			mapResult.put(objectAppliesTo, objectAppliesToMapping);
		}
		this.log.trace("Setting Name: " + strName + " *End AppliesToMap*");
		return mapResult;
	}
}
