/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.mapper.extension;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IAddressingInformation;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.server.mapper.extension.ExtensionMappingKey;
import org.eclipse.higgins.sts.spi.IExtensionMapper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class ExtensionMapper
implements IExtensionMapper {
    private final LogHelper log;
    boolean bInitialized;
    static /* synthetic */ Class class$0;

    public ExtensionMapper() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.mapper.extension.ExtensionMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.bInitialized = false;
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.bInitialized = true;
    }

    public String getConfiguration(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request) {
        this.log.trace((Object)"ExtensionMapper::getConfiguration");
        if (!this.bInitialized) {
            String errMsg = MsgHelper.getString((String)"not_initialized");
            this.log.error((Object)errMsg);
            return null;
        }
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        URI uriRequestTokenType = RST.getTokenType();
        URI uriRequestType = RST.getRequestType();
        IAddressingInformation requestAddressingInformation = request.getAddressingInformation();
        URI uriRequestAction = null;
        if (requestAddressingInformation != null) {
            uriRequestAction = requestAddressingInformation.getAction();
        }
        IEndpointReference eprRequestIssuer = RST.getIssuer();
        URI uriRequestIssuer = null;
        if (eprRequestIssuer != null) {
            uriRequestIssuer = eprRequestIssuer.getAddress();
        }
        if (uriRequestAction != null) {
            this.log.trace((Object)("Action: " + uriRequestAction.toString()));
        }
        String strRequestType = null;
        if (uriRequestType != null) {
            strRequestType = uriRequestType.toString();
            this.log.trace((Object)("RequestType: " + strRequestType));
        }
        if (uriRequestTokenType != null) {
            this.log.trace((Object)("TokenType: " + uriRequestTokenType.toString()));
        }
        if (uriRequestIssuer != null) {
            this.log.trace((Object)("Issuer: " + uriRequestIssuer.toString() + "(" + uriRequestIssuer.hashCode() + ")"));
        }
        ExtensionMappingKey key = new ExtensionMappingKey(uriRequestAction, uriRequestTokenType, uriRequestType, uriRequestIssuer);
        if (uriRequestAction != null) {
            this.log.trace((Object)("Action: " + uriRequestAction.toString() + "(" + uriRequestAction.hashCode() + ")"));
        } else {
            this.log.trace((Object)"Action: (null)");
        }
        if (uriRequestTokenType != null) {
            this.log.trace((Object)(" TokenType: " + uriRequestTokenType.toString() + "(" + uriRequestTokenType.hashCode() + ")"));
        } else {
            this.log.trace((Object)" TokenType: (null)");
        }
        if (uriRequestIssuer != null) {
            this.log.trace((Object)(" Issuer: " + uriRequestIssuer.toString() + "(" + uriRequestIssuer.hashCode() + ")"));
        } else {
            this.log.trace((Object)" Issuer: (null)");
        }
        if (uriRequestType != null) {
            this.log.trace((Object)(" RequestType: " + uriRequestType.toString() + "(" + uriRequestType.hashCode() + ")"));
        } else {
            this.log.trace((Object)" RequestType: (null)");
        }
        this.log.trace((Object)(" Hashcode: " + key.hashCode()));
        Map mapExtensionMap = (Map)mapComponentSettings.get("ExtensionMap");
        String strExtensionConfiguration = (String)mapExtensionMap.get(key);
        return strExtensionConfiguration;
    }
}

