/**
 * 
 */
package org.eclipse.higgins.sts.server.mapper.extension;

import java.util.Map;

import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.spi.IExtensionMapper;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * @author mikemci
 *
 */
public class ExtensionMapper
	implements IExtensionMapper
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ExtensionMapper.class.getName());

	boolean bInitialized = false;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.IExtensionMapper#configure(java.lang.String, java.util.Map)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
	{
		this.bInitialized = true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.IExtensionMapper#getConfiguration(org.eclipse.higgins.sts.ISTSRequest, java.util.Map, org.eclipse.higgins.sts.IConstants)
	 */
	public String getConfiguration
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request)
	{
		this.log.trace("ExtensionMapper::getConfiguration");

		if (!this.bInitialized)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);
			this.log.error(errMsg);
			return null;
		}

		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
		final java.net.URI uriRequestTokenType = RST.getTokenType();
		final java.net.URI uriRequestType = RST.getRequestType();
		final org.eclipse.higgins.sts.api.IAddressingInformation requestAddressingInformation = request.getAddressingInformation();
		java.net.URI uriRequestAction = null;
		if (null != requestAddressingInformation)
		{
			uriRequestAction = requestAddressingInformation.getAction();
		}
		final org.eclipse.higgins.sts.api.IEndpointReference eprRequestIssuer = RST.getIssuer();
		java.net.URI uriRequestIssuer = null;
		if (null != eprRequestIssuer)
		{
			uriRequestIssuer = eprRequestIssuer.getAddress();
		}
		if (null != uriRequestAction)
		{
			this.log.trace("Action: " + uriRequestAction.toString());
		}
		String strRequestType = null;
		if (uriRequestType != null)
		{
			strRequestType = uriRequestType.toString();
			this.log.trace("RequestType: " + strRequestType);
		}
		if (null != uriRequestTokenType)
		{
			this.log.trace("TokenType: " + uriRequestTokenType.toString());
		}

		if (null != uriRequestIssuer)
		{
			this.log.trace("Issuer: " + uriRequestIssuer.toString() + "(" + uriRequestIssuer.hashCode() + ")");
		}

		final ExtensionMappingKey key = new ExtensionMappingKey
			(uriRequestAction,
			uriRequestTokenType,
			uriRequestType,
			uriRequestIssuer);
		if (null != uriRequestAction)
		{
			this.log.trace("Action: " + uriRequestAction.toString() + "(" + uriRequestAction.hashCode() + ")");
		} 
		else
		{
			this.log.trace("Action: " + "(null)");
		}
		if (null != uriRequestTokenType)
		{
			this.log.trace(" TokenType: " + uriRequestTokenType.toString() + "(" + uriRequestTokenType.hashCode() + ")");
		}
		else
		{
			this.log.trace(" TokenType: (null)");
		}
		if (null != uriRequestIssuer)
		{
			this.log.trace(" Issuer: " + uriRequestIssuer.toString() + "(" + uriRequestIssuer.hashCode() + ")");
		}
		else
		{
			this.log.trace(" Issuer: (null)");
		}
		if (null != uriRequestType)
		{
			this.log.trace(" RequestType: " + uriRequestType.toString() + "(" + uriRequestType.hashCode() + ")");
		}
		else
		{
			this.log.trace(" RequestType: (null)");
		}

		this.log.trace(" Hashcode: " + key.hashCode());

		final java.util.Map mapExtensionMap = (java.util.Map)mapComponentSettings.get
			("ExtensionMap");
		final String strExtensionConfiguration = (String)mapExtensionMap.get(key);
		return strExtensionConfiguration;
	}
}
