/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.extension;

/**
 * Used for mapping RequestSecurityToken values to the appropriate extension.
 * 
 * @author mikemci at us dot ibm dot com
 *
 */
public class ExtensionMappingKey
{
	private java.net.URI uriAction = null;
	private java.net.URI uriTokenType = null;
	private java.net.URI uriRequestType = null;
	private java.net.URI uriIssuer = null;
	
	public ExtensionMappingKey
		(final java.net.URI uriAction,
		final java.net.URI uriTokenType,
		final java.net.URI uriRequestType,
		final java.net.URI uriIssuer)
	{
		this.uriAction = uriAction;
		this.uriTokenType = uriTokenType;
		this.uriRequestType = uriRequestType;
		this.uriIssuer = uriIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1; //super.hashCode();
		result = PRIME * result + ((this.uriAction == null) ? 0 : this.uriAction.hashCode());
		result = PRIME * result + ((this.uriIssuer == null) ? 0 : this.uriIssuer.hashCode());
		result = PRIME * result + ((this.uriRequestType == null) ? 0 : this.uriRequestType.hashCode());
		result = PRIME * result + ((this.uriTokenType == null) ? 0 : this.uriTokenType.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#equals(java.lang.Object)
	 */
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		//if (!super.equals(obj))
		//	return false;
		if (this.getClass() != obj.getClass()) {
			return false;
		}
		final ExtensionMappingKey other = (ExtensionMappingKey) obj;
		if (this.uriAction == null) {
			if (other.uriAction != null) {
				return false;
			}
		} else if (!this.uriAction.equals(other.uriAction)) {
			return false;
		}
		if (this.uriIssuer == null) {
			if (other.uriIssuer != null) {
				return false;
			}
		} else if (!this.uriIssuer.equals(other.uriIssuer)) {
			return false;
		}
		if (this.uriRequestType == null) {
			if (other.uriRequestType != null) {
				return false;
			}
		} else if (!this.uriRequestType.equals(other.uriRequestType)) {
			return false;
		}
		if (this.uriTokenType == null) {
			if (other.uriTokenType != null) {
				return false;
			}
		} else if (!this.uriTokenType.equals(other.uriTokenType)) {
			return false;
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#getAction()
	 */
	public java.net.URI getAction()
	{
		return this.uriAction;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#setAction(java.lang.String)
	 */
	public void setAction
		(final java.net.URI uriAction)
	{
		this.uriAction = uriAction;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#getIssuer()
	 */
	public java.net.URI getIssuer()
	{
		return this.uriIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#setIssuer(java.lang.String)
	 */
	public void setIssuer
		(final java.net.URI uriIssuer)
	{
		this.uriIssuer = uriIssuer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#getRequestType()
	 */
	public java.net.URI getRequestType()
	{
		return this.uriRequestType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#setRequestType(java.lang.String)
	 */
	public void setRequestType
		(final java.net.URI uriRequestType)
	{
		this.uriRequestType = uriRequestType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#getTokenType()
	 */
	public java.net.URI getTokenType()
	{
		return this.uriTokenType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtensionMappingKey#setTokenType(java.lang.String)
	 */
	public void setTokenType
		(final java.net.URI uriTokenType)
	{
		this.uriTokenType = uriTokenType;
	}
}
