/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.extension;

import java.util.Map;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.xml.ISettingHandler;

/**
 * @author mikemci
 *
 */
public class ExtensionMapKeyHandler implements ISettingHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ExtensionMapKeyHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.binding.axis1x.configuration.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{
		this.log.trace("Setting Name: " + strName + " *Begin ExtensionMapKey*");
		final ISettingHandler handlerMap = (ISettingHandler)mapSettingHandlers.get
			("htf:map");
		if (null == handlerMap)
		{
			String errMsg = MsgHelper.getString(MsgHelper.settinghandler_not_found_for_type, "htf:map");
			this.log.error(errMsg);
			throw new Exception(errMsg);
		}
		final Map mapExtensionMapKeySettings = (Map)handlerMap.getSetting
			(strName,
			strConfigurationBase,
			mapSettingHandlers,
			mapSettingsGlobal,
			settingsParent,
			globalDescriptor,
			settingDescriptor,
			omSetting);
		final java.net.URI uriTokenType = (java.net.URI)mapExtensionMapKeySettings.get
			("TokenType");
		if (null != uriTokenType) {
			this.log.trace("TokenType Value: " + uriTokenType.toString() + " HashCode: " + uriTokenType.hashCode());
		}
		final java.net.URI uriAction = (java.net.URI)mapExtensionMapKeySettings.get
			("Action");
		if (null != uriAction) {
			this.log.trace("Action Value: " + uriAction.toString() + " HashCode: " + uriAction.hashCode());
		}
		final java.net.URI uriRequestType = (java.net.URI)mapExtensionMapKeySettings.get
			("RequestType");
		if (null != uriRequestType) {
			this.log.trace("RequestType Value: " + uriRequestType.toString() + " HashCode: " + uriRequestType.hashCode());
		}
		final java.net.URI uriIssuer = (java.net.URI)mapExtensionMapKeySettings.get
			("Issuer");
		if (null != uriIssuer) {
			this.log.trace("Issuer Value: " + uriIssuer.toString() + " HashCode: " + uriIssuer.hashCode());
		}
		final Object objectResult = new org.eclipse.higgins.sts.server.mapper.extension.ExtensionMappingKey
			(uriAction,
			uriTokenType,
			uriRequestType,
			uriIssuer);
		this.log.trace("ExtensionMappingKey HashCode: " + objectResult.hashCode());
		this.log.trace("Setting Name: " + strName + " *End ExtensionMapKey*");
		return objectResult;

	}
}
