/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.polling;


/**
 * Implements the IConfigurableComponentFactory that creates the SecurityTokenService implementation.
 * 
 * @author mikemci at us dot ibm dot com
 */
public class PollingMapperFactory
	implements org.eclipse.higgins.configuration.api.IConfigurableComponentFactory
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(PollingMapperFactory.class.getName());

	/**
	 * The singleton instance
	 */
	private static PollingMapper theInstance = null;

	/**
	 * Provides access to the singleton instance
	 * 
	 * @return the singleton instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getSingletonInstance()
	{
		if (null == PollingMapperFactory.theInstance)
		{
			try
			{
				PollingMapperFactory.theInstance = new PollingMapper();
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);	
	    		return null;
    		}
		}
		return PollingMapperFactory.theInstance;
	}
	
	/**
	 * Provides access to the new instance
	 * 
	 * @return the new instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getNewInstance()
	{
		return null;
	}
}

