/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.mapper.polling;

import java.util.Map;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.spi.IExtensionMapper;

/**
 * @author mikemci
 *
 */
public class PollingMapper
	implements IExtensionMapper
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(PollingMapper.class.getName());

	boolean bInitialized = false;
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.IExtensionMapper#configure(java.lang.String, java.util.Map)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
	{
		log.trace("PollingMapper::configure");

		this.bInitialized = true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.IExtensionMapper#getConfiguration(org.eclipse.higgins.sts.ISTSRequest, java.util.Map, org.eclipse.higgins.sts.IConstants)
	 */
	public String getConfiguration
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request)
	{
		this.log.trace("PollingMapper::getConfiguration");
		if (!this.bInitialized)
		{
			this.log.error("Not Initialized");
			return null;
		}
		String strExtensionName = null;
		final java.util.ArrayList alExtensions = (java.util.ArrayList)mapComponentSettings.get
			("ExtensionList");
		java.util.Map mapExtensionSettings = (java.util.Map)mapGlobalSettings.get("ComponentSettings");
		for (int i = 0; i < alExtensions.size(); ++i)
		{
			strExtensionName = (String)alExtensions.get(i);
			final org.eclipse.higgins.sts.spi.ITokenExtension extension = (org.eclipse.higgins.sts.spi.ITokenExtension)
				mapGlobalSettings.get(strExtensionName);
			if (extension.canHandle
				(mapGlobalSettings,
				strExtensionName,
				(java.util.Map)mapExtensionSettings.get(strExtensionName),
				mapInvocationSettings,
				constants,
				request))
			{
				break;
			}
			else
			{
				strExtensionName = null;
			}
		}
		return strExtensionName;
	}
}
