/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.metadata;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IMEXResponse;
import org.eclipse.higgins.sts.api.IMetadataExchangeService;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.MEXResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class MetadataExchangeService
implements IMetadataExchangeService {
    private final LogHelper log;
    private boolean bInitialized;
    static /* synthetic */ Class class$0;

    protected MetadataExchangeService() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.metadata.MetadataExchangeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.bInitialized = false;
        this.log.trace((Object)"MetadataExchangeService::MetadataExchangeService");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
        this.log.trace((Object)"MetadataExchangeService::configure");
        this.bInitialized = false;
        String strMetadataExchangeServiceName = strComponentName;
        if (strMetadataExchangeServiceName == null) {
            strMetadataExchangeServiceName = "MetadataExchangeService";
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        Map mapMetadataExchangeServiceSettings = mapComponentSettings;
        if (mapMetadataExchangeServiceSettings == null) {
            mapMetadataExchangeServiceSettings = (Map)mapComponentsSettings.get(strMetadataExchangeServiceName);
        }
        String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        this.log.trace((Object)("ConfigurationBase: " + strConfigurationBase));
        String strMetadataWSDL = null;
        try {
            FileInputStream fisMetadataWSDLFile = (FileInputStream)mapMetadataExchangeServiceSettings.get("MetadataWSDLFile");
            org.w3c.dom.Element domMetadataWSDL = XMLHelper.domFromStream((InputStream)fisMetadataWSDLFile);
            strMetadataWSDL = XMLHelper.toString((org.w3c.dom.Element)domMetadataWSDL);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw e;
        }
        try {
            FileInputStream fisMetadataSchemaFile = (FileInputStream)mapMetadataExchangeServiceSettings.get("MetadataSchemaFile");
            org.w3c.dom.Element domMetadataSchema = XMLHelper.domFromStream((InputStream)fisMetadataSchemaFile);
            String strMetadataSchema = XMLHelper.toString((org.w3c.dom.Element)domMetadataSchema);
            this.log.trace((Object)("MetadataSchema: " + strMetadataSchema));
            mapMetadataExchangeServiceSettings.put("MetadataSchema", domMetadataSchema);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw e;
        }
        try {
            FileInputStream fisSelfSignedSAMLTokenIssuePolicyFile = (FileInputStream)mapMetadataExchangeServiceSettings.get("SelfSignedSAMLTokenIssuePolicyFile");
            int nSelfSignedSAMLTokenIssuePolicySize = fisSelfSignedSAMLTokenIssuePolicyFile.available();
            byte[] byteSelfSignedSAMLTokenIssuePolicy = new byte[nSelfSignedSAMLTokenIssuePolicySize];
            fisSelfSignedSAMLTokenIssuePolicyFile.read(byteSelfSignedSAMLTokenIssuePolicy);
            String strSelfSignedSAMLTokenIssuePolicy = new String(byteSelfSignedSAMLTokenIssuePolicy);
            mapMetadataExchangeServiceSettings.put("SelfSignedSAMLTokenIssuePolicy", strSelfSignedSAMLTokenIssuePolicy);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw e;
        }
        try {
            FileInputStream fisUsernameTokenIssuePolicyFile = (FileInputStream)mapMetadataExchangeServiceSettings.get("UsernameTokenIssuePolicyFile");
            int nUsernameTokenIssuePolicySize = fisUsernameTokenIssuePolicyFile.available();
            byte[] byteUsernameTokenIssuePolicy = new byte[nUsernameTokenIssuePolicySize];
            fisUsernameTokenIssuePolicyFile.read(byteUsernameTokenIssuePolicy);
            String strUsernameTokenIssuePolicy = new String(byteUsernameTokenIssuePolicy);
            mapMetadataExchangeServiceSettings.put("UsernameTokenIssuePolicy", strUsernameTokenIssuePolicy);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw e;
        }
        IBase64Extension base64Extension = (IBase64Extension)mapGlobalSettings.get("Base64Extension");
        X509Certificate certificateIssuer = (X509Certificate)mapGlobalSettings.get("IssuerCertificate");
        byte[] byteIssuerCertificate = null;
        try {
            byteIssuerCertificate = certificateIssuer.getEncoded();
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw e;
        }
        String strIssuerCertificate = base64Extension.encode(byteIssuerCertificate);
        strIssuerCertificate = XMLHelper.stripNewLinesFromString((String)strIssuerCertificate);
        strMetadataWSDL = strMetadataWSDL.replaceAll("urn:TOKENISSUER", ((URI)mapGlobalSettings.get("TokenServiceTrustURI")).toString());
        strMetadataWSDL = strMetadataWSDL.replaceAll("urn:CERTIFICATE", strIssuerCertificate);
        this.log.trace((Object)("MetadataWSDL: " + strMetadataWSDL));
        mapMetadataExchangeServiceSettings.put("MetadataWSDL", strMetadataWSDL);
        this.bInitialized = true;
        this.log.trace((Object)"MetadataExchangeService::initialize DONE");
    }

    public IMEXResponse getMetadata(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, URI uriRequest) throws Exception {
        this.log.trace((Object)"SecurityTokenService::getMetadata");
        MEXResponse mexResponse = new MEXResponse();
        if (!this.bInitialized) {
            this.log.error((Object)"Not Initialized");
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Not initialized.");
            mexResponse.setFault((IFault)fault);
            return mexResponse;
        }
        String strRequestURI = uriRequest.toString();
        String strCredentialType = null;
        if (strRequestURI.endsWith("/services/MetadataUsernameToken")) {
            this.log.trace((Object)"Getting Metadata for UsernamePassword");
            strCredentialType = "UsernamePassword";
        } else if (strRequestURI.endsWith("/services/MetadataSelfSignedSAMLToken")) {
            this.log.trace((Object)"Getting Metadata for SelfSignedSAML");
            strCredentialType = "SelfSignedSAML";
        } else {
            this.log.error((Object)"Unrecognized Metadata URL.");
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Unrecognized Metadata URL.");
            mexResponse.setFault((IFault)fault);
            return mexResponse;
        }
        return this.getMetadata(mapGlobalSettings, strComponentName, mapComponentSettings, mapInvocationSettings, constants, strCredentialType);
    }

    public IMEXResponse getMetadata(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, String strCredentialType) throws Exception {
        this.log.trace((Object)"MetadataExchangeServiceServerBinding::getMetadata(javax.servlet.ServletContext)");
        MEXResponse mexResponse = new MEXResponse();
        URI uriTokenServiceTrust = (URI)mapGlobalSettings.get("TokenServiceTrustURI");
        String strLocalMetadataWSDL = null;
        String strMetadataWSDL = (String)mapComponentSettings.get("MetadataWSDL");
        if (strMetadataWSDL != null) {
            this.log.trace((Object)("Adding Metadata WSDL: " + strCredentialType));
            if (strCredentialType.matches("UsernamePassword")) {
                String strUsernameTokenIssuePolicy = (String)mapComponentSettings.get("UsernameTokenIssuePolicy");
                strLocalMetadataWSDL = strMetadataWSDL.replaceAll("urn:TOKENISSUEPOLICY", strUsernameTokenIssuePolicy);
            } else if (strCredentialType.matches("SelfSignedSAML")) {
                String strSelfSignedSAMLTokenIssuePolicy = (String)mapComponentSettings.get("SelfSignedSAMLTokenIssuePolicy");
                strLocalMetadataWSDL = strMetadataWSDL.replaceAll("urn:TOKENISSUEPOLICY", strSelfSignedSAMLTokenIssuePolicy);
            }
            this.log.trace((Object)("MetadataWSDL: " + strLocalMetadataWSDL));
        }
        String strLocalMetadataSchema = null;
        org.w3c.dom.Element domMetadataSchema = (org.w3c.dom.Element)mapComponentSettings.get("MetadataSchema");
        if (domMetadataSchema != null) {
            this.log.trace((Object)"Adding Metadata Schema");
            strLocalMetadataSchema = XMLHelper.toString((org.w3c.dom.Element)domMetadataSchema);
        }
        String strMetadata = "<Metadata xmlns=\"http://schemas.xmlsoap.org/ws/2004/09/mex\"><MetadataSection Dialect=\"http://schemas.xmlsoap.org/wsdl/\" Identifier=\"" + uriTokenServiceTrust.toString() + "\">" + strLocalMetadataWSDL + "</MetadataSection>" + "<MetadataSection Dialect=\"http://www.w3.org/2001/XMLSchema\" Identifier=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">" + strLocalMetadataSchema + "</MetadataSection>" + "</Metadata>";
        Element elemMetadata = new Element();
        elemMetadata.set((Object)strMetadata);
        mexResponse.setMetadata((IElement)elemMetadata);
        return mexResponse;
    }
}

