/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.metadata;

import java.security.cert.X509Certificate;
import java.util.Map;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Implements the Higgins Security Token Service.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
// TODO: Implement * AppliesTo

public class MetadataExchangeService
	implements org.eclipse.higgins.sts.api.IMetadataExchangeService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(MetadataExchangeService.class.getName());

	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected MetadataExchangeService()
		throws Exception
	{
		this.log.trace("MetadataExchangeService::MetadataExchangeService");
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.ISecurityTokenService#configure(java.util.Map, java.util.Map, java.util.Map, java.util.Map)
	 */ 
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
		throws Exception
	{
		this.log.trace("MetadataExchangeService::configure");
		
		// TODO: Lock / Sequentialize
		this.bInitialized = false;

		String strMetadataExchangeServiceName = strComponentName;
		if (null == strMetadataExchangeServiceName)
		{
			strMetadataExchangeServiceName = "MetadataExchangeService";
		}

		final Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
		Map mapMetadataExchangeServiceSettings = mapComponentSettings;
		if (null == mapMetadataExchangeServiceSettings)
		{
			mapMetadataExchangeServiceSettings = (Map)mapComponentsSettings.get
				(strMetadataExchangeServiceName);
		}
		
		final String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
		this.log.trace("ConfigurationBase: " + strConfigurationBase);
		
		String strMetadataWSDL = null;
		
		try
		{
			final java.io.FileInputStream fisMetadataWSDLFile = (java.io.FileInputStream)mapMetadataExchangeServiceSettings.get
				("MetadataWSDLFile");
			final org.w3c.dom.Element domMetadataWSDL = org.eclipse.higgins.sts.utilities.XMLHelper.domFromStream
				(fisMetadataWSDLFile);
			strMetadataWSDL = org.eclipse.higgins.sts.utilities.XMLHelper.toString
				(domMetadataWSDL);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			throw e;
		}
		
		try
		{
			final java.io.FileInputStream fisMetadataSchemaFile = (java.io.FileInputStream)mapMetadataExchangeServiceSettings.get
				("MetadataSchemaFile");
			final org.w3c.dom.Element domMetadataSchema = org.eclipse.higgins.sts.utilities.XMLHelper.domFromStream
				(fisMetadataSchemaFile);
			final String strMetadataSchema = org.eclipse.higgins.sts.utilities.XMLHelper.toString
				(domMetadataSchema);
	    	this.log.trace("MetadataSchema: " + strMetadataSchema);
	    	mapMetadataExchangeServiceSettings.put("MetadataSchema", domMetadataSchema);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			throw e;
		}

		try
	    {
		    final java.io.FileInputStream fisSelfSignedSAMLTokenIssuePolicyFile = (java.io.FileInputStream)mapMetadataExchangeServiceSettings.get("SelfSignedSAMLTokenIssuePolicyFile");
		    final int nSelfSignedSAMLTokenIssuePolicySize = fisSelfSignedSAMLTokenIssuePolicyFile.available();
		    final byte byteSelfSignedSAMLTokenIssuePolicy [] = new byte[nSelfSignedSAMLTokenIssuePolicySize];
		    fisSelfSignedSAMLTokenIssuePolicyFile.read(byteSelfSignedSAMLTokenIssuePolicy);
			final String strSelfSignedSAMLTokenIssuePolicy = new String(byteSelfSignedSAMLTokenIssuePolicy);
			mapMetadataExchangeServiceSettings.put("SelfSignedSAMLTokenIssuePolicy", strSelfSignedSAMLTokenIssuePolicy);
	    }
	    catch (final Exception e)
	    {
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			throw e;
	    }
	    
	    try
	    {
		    final java.io.FileInputStream fisUsernameTokenIssuePolicyFile = (java.io.FileInputStream)mapMetadataExchangeServiceSettings.get("UsernameTokenIssuePolicyFile");
		    final int nUsernameTokenIssuePolicySize = fisUsernameTokenIssuePolicyFile.available();
		    final byte byteUsernameTokenIssuePolicy [] = new byte[nUsernameTokenIssuePolicySize];
		    fisUsernameTokenIssuePolicyFile.read(byteUsernameTokenIssuePolicy);
		    final String strUsernameTokenIssuePolicy = new String(byteUsernameTokenIssuePolicy);
		    mapMetadataExchangeServiceSettings.put("UsernameTokenIssuePolicy", strUsernameTokenIssuePolicy);
	    }
	    catch (final Exception e)
	    {
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			throw e;
	    }
	    
	    final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension = (org.eclipse.higgins.sts.spi.IBase64Extension)mapGlobalSettings.get
	    	("Base64Extension");

		final X509Certificate certificateIssuer = (X509Certificate)mapGlobalSettings.get("IssuerCertificate");
		byte [] byteIssuerCertificate = null;
		try
		{
			byteIssuerCertificate = certificateIssuer.getEncoded();
		}
		catch (final Exception e)
		{
		   	org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			throw e;
		}
		
		String strIssuerCertificate = base64Extension.encode
			(byteIssuerCertificate);
		strIssuerCertificate = org.eclipse.higgins.sts.utilities.XMLHelper.stripNewLinesFromString
			(strIssuerCertificate);
    	strMetadataWSDL = strMetadataWSDL.replaceAll
    		("urn:TOKENISSUER",
    		((java.net.URI)mapGlobalSettings.get("TokenServiceTrustURI")).toString());
    	strMetadataWSDL = strMetadataWSDL.replaceAll
    		("urn:CERTIFICATE",
    		strIssuerCertificate);

       	this.log.trace("MetadataWSDL: " + strMetadataWSDL);
       	mapMetadataExchangeServiceSettings.put("MetadataWSDL", strMetadataWSDL);

		this.bInitialized = true;
		
		this.log.trace("MetadataExchangeService::initialize DONE");
	}
	
	public org.eclipse.higgins.sts.api.IMEXResponse getMetadata
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final java.net.URI uriRequest) 
		throws Exception
	{
		this.log.trace("SecurityTokenService::getMetadata");
		
		final org.eclipse.higgins.sts.api.IMEXResponse mexResponse = new org.eclipse.higgins.sts.common.MEXResponse();
	
		if (!this.bInitialized)
		{
			this.log.error("Not Initialized");
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Not initialized.");
			mexResponse.setFault(fault);
			return mexResponse;
		}

    	final String strRequestURI = uriRequest.toString();
    	String strCredentialType = null;
	    	if (strRequestURI.endsWith
	            ("/services/MetadataUsernameToken"))
	    	{
	    		this.log.trace("Getting Metadata for UsernamePassword");
	    		strCredentialType = "UsernamePassword";
	    	}
	    	else if (strRequestURI.endsWith
	            ("/services/MetadataSelfSignedSAMLToken"))
	    	{
	    		this.log.trace("Getting Metadata for SelfSignedSAML");
	    		strCredentialType = "SelfSignedSAML";
	    	}
	    	else
	    	{
		    	this.log.error("Unrecognized Metadata URL.");
				final Fault fault = new Fault
					(constants.getWSTrustNamespace(),
					"wst",
					constants.getRequestFailedFaultCode(),
					"The specified request failed",
					"Unrecognized Metadata URL.");
				mexResponse.setFault(fault);
				return mexResponse;
	    	}
        
    	return this.getMetadata
    		(mapGlobalSettings,
    	    strComponentName,
    	   	mapComponentSettings,
    	   	mapInvocationSettings,
    	   	constants,
    	    strCredentialType);
	}
	
    public org.eclipse.higgins.sts.api.IMEXResponse getMetadata
    	(final java.util.Map mapGlobalSettings,
    	final String strComponentName,
   		final java.util.Map mapComponentSettings,
   		final java.util.Map mapInvocationSettings,
   		final IConstants constants,
    	final String strCredentialType)
    	throws Exception
	{
		this.log.trace("MetadataExchangeServiceServerBinding::getMetadata(javax.servlet.ServletContext)");
		
		final org.eclipse.higgins.sts.api.IMEXResponse mexResponse = new org.eclipse.higgins.sts.common.MEXResponse();
		
		final java.net.URI uriTokenServiceTrust = (java.net.URI)mapGlobalSettings.get("TokenServiceTrustURI");

		String strLocalMetadataWSDL = null;
		final String strMetadataWSDL = (String)mapComponentSettings.get("MetadataWSDL");		
		if (null != strMetadataWSDL)
		{
			this.log.trace("Adding Metadata WSDL: " + strCredentialType);
			if (strCredentialType.matches("UsernamePassword"))
			{
				final String strUsernameTokenIssuePolicy = (String)mapComponentSettings.get("UsernameTokenIssuePolicy");
				strLocalMetadataWSDL = strMetadataWSDL.replaceAll
					("urn:TOKENISSUEPOLICY",
					strUsernameTokenIssuePolicy);
			}
			else if (strCredentialType.matches("SelfSignedSAML"))
			{
				final String strSelfSignedSAMLTokenIssuePolicy = (String)mapComponentSettings.get("SelfSignedSAMLTokenIssuePolicy");
				strLocalMetadataWSDL = strMetadataWSDL.replaceAll
					("urn:TOKENISSUEPOLICY",
					strSelfSignedSAMLTokenIssuePolicy);
			}
	    	this.log.trace("MetadataWSDL: " + strLocalMetadataWSDL);
		}

		String strLocalMetadataSchema = null;
		final org.w3c.dom.Element domMetadataSchema = (org.w3c.dom.Element)mapComponentSettings.get("MetadataSchema");
		if (null != domMetadataSchema)
		{
			this.log.trace("Adding Metadata Schema");
			strLocalMetadataSchema = org.eclipse.higgins.sts.utilities.XMLHelper.toString(domMetadataSchema);
		}

		final String strMetadata = "<Metadata xmlns=\"http://schemas.xmlsoap.org/ws/2004/09/mex\">"
			+ "<MetadataSection Dialect=\"http://schemas.xmlsoap.org/wsdl/\" Identifier=\""
			+ uriTokenServiceTrust.toString()
			+ "\">"
			+ strLocalMetadataWSDL
			+ "</MetadataSection>"
			+ "<MetadataSection Dialect=\"http://www.w3.org/2001/XMLSchema\" Identifier=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">"
			+ strLocalMetadataSchema
			+ "</MetadataSection>"
			+ "</Metadata>";
		
		final org.eclipse.higgins.sts.api.IElement elemMetadata = new org.eclipse.higgins.sts.common.Element();
		elemMetadata.set(strMetadata);
		mexResponse.setMetadata(elemMetadata);

		return mexResponse;
	}
}