/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.token.alf;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class ALFClaimHandler
extends TokenHandler {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$server$token$alf$ALFClaimHandler == null ? (class$org$eclipse$higgins$sts$server$token$alf$ALFClaimHandler = ALFClaimHandler.class$("org.eclipse.higgins.sts.server.token.alf.ALFClaimHandler")) : class$org$eclipse$higgins$sts$server$token$alf$ALFClaimHandler).getName());
    QName qnameALFClaim = new QName("http://www.eclipse.org/ALF/1.0/claims", "Claim");
    QName qnameALFClaimType = new QName("http://www.eclipse.org/ALF/1.0/claims", "ClaimType");
    private boolean bConfigured = false;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$server$token$alf$ALFClaimHandler;
    static /* synthetic */ Class class$org$apache$axiom$om$OMElement;

    protected ALFClaimHandler() {
        this.log.trace((Object)"ALFClaimHandler::ALFClaimHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)"ALFClaimHandler::initialize");
        this.bConfigured = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        IDigitalIdentity digitalIdentity;
        this.log.trace((Object)"ALFClaimHandler::invoke");
        if (!this.bConfigured) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Issue handler not configured");
            response.setFault((IFault)fault);
            return;
        }
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        IElement elemClaims = RST.getClaims();
        OMElement omClaims = null;
        if (null != elemClaims) {
            try {
                omClaims = (OMElement)elemClaims.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = ALFClaimHandler.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Unsupported contained object class.");
                response.setFault((IFault)fault);
                return;
            }
        }
        if (null == (digitalIdentity = RST.getDigitalIdentity())) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Digital Subject was not found");
            response.setFault((IFault)fault);
            return;
        }
        Iterator iterClaimTypes = null;
        if (null != omClaims) {
            iterClaimTypes = omClaims.getChildrenWithName(this.qnameALFClaim);
            while (iterClaimTypes.hasNext()) {
                OMElement elemClaim = (OMElement)iterClaimTypes.next();
                OMAttribute attrClaimType = elemClaim.getAttribute(this.qnameALFClaimType);
                if (attrClaimType == null || attrClaimType.getAttributeValue() == null || attrClaimType.getAttributeValue().trim().length() == 0) continue;
                ClaimType claimType = new ClaimType();
                claimType.setDialect(URI.create("http://www.eclipse.org/ALF/1.0/claims"));
                claimType.setName(URI.create(attrClaimType.getAttributeValue()));
                Claim claim = new Claim();
                claim.setType((IClaimType)claimType);
                claim.addValue(elemClaim.getText());
                digitalIdentity.addClaim((IClaim)claim);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

