/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *    Jim Sermersheim (Novell)
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.token.alf;

import java.util.Map;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Handle RSTs and generate RSTRs as SAML Assertions. 
 * Compatible with www.identityblog.com
 * 
 * @author mikemci at us dot ibm dot com
 */
public class ALFClaimHandler
	extends org.eclipse.higgins.sts.server.token.handler.TokenHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ALFClaimHandler.class.getName());
	
	javax.xml.namespace.QName qnameALFClaim = new javax.xml.namespace.QName
		("http://www.eclipse.org/ALF/1.0/claims",
		"Claim");
	
	javax.xml.namespace.QName qnameALFClaimType = new javax.xml.namespace.QName
		("http://www.eclipse.org/ALF/1.0/claims",
		"ClaimType"); 
    
    private boolean bConfigured = false;
	
	/**
	 * Protected constructor, must use ALFClaimHandlerFactory
	 */
	protected ALFClaimHandler()
	{
		this.log.trace("ALFClaimHandler::ALFClaimHandler");
	}
	
    /* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtension#configure(java.util.Hashtable)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
	{
		this.log.trace("ALFClaimHandler::initialize");

		this.bConfigured = true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtension#invoke
     */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
	{
		this.log.trace("ALFClaimHandler::invoke");
		
		if (!this.bConfigured)
		{
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Issue handler not configured");
			response.setFault(fault);
			return;		
		}
		
		// TODO: Properly namespace qualify LocalNames throughout
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
		// TODO: Deal with collections?
		
		final org.eclipse.higgins.sts.api.IElement elemClaims = RST.getClaims();
		org.apache.axiom.om.OMElement omClaims = null;

		if (null != elemClaims)
		{
			try
			{
				omClaims = (org.apache.axiom.om.OMElement)elemClaims.getAs
					(org.apache.axiom.om.OMElement.class);
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);
				final Fault fault = new Fault
					(constants.getWSTrustNamespace(),
					"wst",
					constants.getRequestFailedFaultCode(),
					"The specified request failed",
					"Unsupported contained object class.");
				response.setFault(fault);
				return;			
			}
		}
		
		final org.eclipse.higgins.sts.api.IDigitalIdentity digitalIdentity = RST.getDigitalIdentity();
		if (null == digitalIdentity)
	   	{
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Node was not found");
			response.setFault(fault);
			return;
	   	}
		java.util.Iterator iterClaimTypes = null;
		if (null != omClaims)
		{
			iterClaimTypes = omClaims.getChildrenWithName(this.qnameALFClaim);
			while (iterClaimTypes.hasNext())
			{
				final org.apache.axiom.om.OMElement elemClaim = (org.apache.axiom.om.OMElement)iterClaimTypes.next();
				final org.apache.axiom.om.OMAttribute attrClaimType = elemClaim.getAttribute(this.qnameALFClaimType);
				if ((attrClaimType == null)
					|| (attrClaimType.getAttributeValue() == null)
					|| (attrClaimType.getAttributeValue().trim().length() == 0)) {
					// skip claims with empty claim type attributes
					continue;
				}
				final org.eclipse.higgins.sts.api.IClaimType claimType = new org.eclipse.higgins.sts.common.ClaimType();
				claimType.setDialect(java.net.URI.create("http://www.eclipse.org/ALF/1.0/claims"));
				claimType.setName(java.net.URI.create(attrClaimType.getAttributeValue()));
				final org.eclipse.higgins.sts.api.IClaim claim = new org.eclipse.higgins.sts.common.Claim();
				claim.setType(claimType);
				claim.addValue(elemClaim.getText());
				digitalIdentity.addClaim(claim);
			}
		}
	}
}