/**
 * 
 */
package org.eclipse.higgins.sts.server.token.compound;

import java.util.Map;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;

/**
 * @author mikemci
 *
 */
public class CompoundHandler
	extends org.eclipse.higgins.sts.server.token.handler.TokenHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(CompoundHandler.class.getName());

	boolean bConfigured = false;
		
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.ITokenExtension#configure(java.lang.String, java.util.Map)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
	{
		this.log.trace("CompoundHandler::configure");
		this.bConfigured = true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.ITokenExtension#invoke(org.eclipse.higgins.sts.ISTSRequest, org.eclipse.higgins.sts.ISTSResponse, java.util.Map, org.eclipse.higgins.sts.IConstants)
	 */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
	{
		this.log.trace("CompoundHandler::invoke");
		if (!this.bConfigured)
		{
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Issue handler not configured");
			response.setFault(fault);
			return;		
		}

		final Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");

		final java.util.List listExtensionNames = (java.util.List)mapComponentSettings.get
			("ExtensionList");
		if (null == listExtensionNames)
		{
				final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Configuration Error: ExtensionList not Found");
			response.setFault(fault);
			return;				
		}
		
		this.log.trace("Iterating Through Extensions");
		for (int i = 0; i < listExtensionNames.size(); ++i)
		{
			final String strTokenExtensionName = (String)listExtensionNames.get(i);
			this.log.trace("Extension: " + strTokenExtensionName);
			
			final java.util.Map mapTokenExtensionConfiguration = (java.util.Map)mapComponentsSettings.get
				(strTokenExtensionName);
			if (null == mapTokenExtensionConfiguration)
			{
				final Fault fault = new Fault
					(constants.getWSTrustNamespace(),
					"wst",
					constants.getRequestFailedFaultCode(),
					"The specified request failed",
					"Issue handler not configured");
				response.setFault(fault);
				return;				
			}

			final org.eclipse.higgins.sts.spi.ITokenExtension extension = (org.eclipse.higgins.sts.spi.ITokenExtension)mapGlobalSettings.get
				(strTokenExtensionName);
			
			extension.invoke
				(mapGlobalSettings,
				strTokenExtensionName,
				mapTokenExtensionConfiguration,
				mapInvocationSettings,
				constants,
				request,
				response);
			if (null != response.getFault()) {
				break;
			}
		}
		
	}
}
