/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.token.encrypt;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.sts.api.IAppliesTo;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.RequestSecurityTokenResponse;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class TokenEncryptHandler
extends TokenHandler {
    private final LogHelper log;
    private boolean bConfigured;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected TokenEncryptHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.token.encrypt.TokenEncryptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.bConfigured = false;
        this.log.trace((Object)"TokenEncryptHandler::TokenEncryptHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)"TokenEncryptHandler::configure");
        this.bConfigured = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        this.log.trace((Object)("TokenEncryptHandler::invoke: " + strComponentName));
        if (!this.bConfigured) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Issue handler not configured");
            response.setFault((IFault)fault);
            return;
        }
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        IAppliesTo appliesToRequest = RST.getAppliesTo();
        OMElement omAppliesToIdentity = null;
        this.log.trace((Object)"Checking for AppliesTo");
        if (appliesToRequest != null) {
            this.log.trace((Object)"Found AppliesTo");
            IEndpointReference eprAppliesTo = appliesToRequest.getEndpointReference();
            List listOthers = eprAppliesTo.getAnyOtherElements();
            int i = 0;
            while (i < listOthers.size()) {
                String strLocalName;
                IElement elemOther = (IElement)listOthers.get(i);
                OMElement omOther = null;
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.apache.axiom.om.OMElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    omOther = (OMElement)elemOther.getAs((Class)clazz);
                }
                catch (Exception e) {
                    ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                }
                if (omOther != null && (strLocalName = omOther.getLocalName()).equals("Identity")) {
                    this.log.trace((Object)"Found AppliesTo/Identity");
                    omAppliesToIdentity = omOther;
                    break;
                }
                ++i;
            }
        }
        OMElement omAppliesToIdentityKeyInfo = null;
        if (omAppliesToIdentity != null) {
            QName qnameKeyInfo = new QName(constants.getXMLSignatureNamespace().toString(), "KeyInfo");
            Iterator iterAppliesToIdentityKeyInfo = omAppliesToIdentity.getChildrenWithName(qnameKeyInfo);
            if (iterAppliesToIdentityKeyInfo.hasNext()) {
                this.log.trace((Object)"Found Identity/KeyInfo");
                omAppliesToIdentityKeyInfo = (OMElement)iterAppliesToIdentityKeyInfo.next();
            }
        } else {
            this.log.trace((Object)"AppliesTo/Identity Not Found");
        }
        OMElement elemAppliesToIdentityKeyInfoX509Data = null;
        if (omAppliesToIdentityKeyInfo != null) {
            QName qnameX509Data = new QName(constants.getXMLSignatureNamespace().toString(), "X509Data");
            Iterator iterAppliesToIdentityKeyInfoX509Data = omAppliesToIdentityKeyInfo.getChildrenWithName(qnameX509Data);
            if (iterAppliesToIdentityKeyInfoX509Data.hasNext()) {
                this.log.trace((Object)"Found KeyInfo/X509Data");
                elemAppliesToIdentityKeyInfoX509Data = (OMElement)iterAppliesToIdentityKeyInfoX509Data.next();
            }
        } else {
            this.log.trace((Object)"Identity/KeyInfo Not Found");
        }
        OMElement elemAppliesToIdentityKeyInfoX509DataX509Certificate = null;
        if (elemAppliesToIdentityKeyInfoX509Data != null) {
            QName qnameX509Certificate = new QName(constants.getXMLSignatureNamespace().toString(), "X509Certificate");
            Iterator iterAppliesToIdentityKeyInfoX509DataX509Certificate = elemAppliesToIdentityKeyInfoX509Data.getChildrenWithName(qnameX509Certificate);
            if (iterAppliesToIdentityKeyInfoX509DataX509Certificate.hasNext()) {
                this.log.trace((Object)"Found X509Data/X509Certificate");
                elemAppliesToIdentityKeyInfoX509DataX509Certificate = (OMElement)iterAppliesToIdentityKeyInfoX509DataX509Certificate.next();
            }
        } else {
            this.log.trace((Object)"KeyInfo/X509Data Not Found");
        }
        String strAppliesToIdentityCertificate = null;
        if (elemAppliesToIdentityKeyInfoX509DataX509Certificate == null) {
            this.log.trace((Object)"X509Data/X509Certificate Not Found");
            return;
        }
        strAppliesToIdentityCertificate = elemAppliesToIdentityKeyInfoX509DataX509Certificate.getText();
        List listRSTR = response.getRequestSecurityTokenResponseCollection();
        RequestSecurityTokenResponse RSTR = (RequestSecurityTokenResponse)listRSTR.get(0);
        IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
        IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
        try {
            StringBuffer stringBuffer = new StringBuffer("Pre-Encrypt Token: ");
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log.trace((Object)stringBuffer.append((String)elemRequestedSecurityToken.getAs((Class)clazz)).toString());
            IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion", elemRequestedSecurityToken, strAppliesToIdentityCertificate);
            RSTR.setRequestedSecurityToken(elemEncryptedRequestedSecurityToken);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "XML Encryption operation failed.");
            response.setFault((IFault)fault);
        }
    }
}

