/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *    Jim Sermersheim (Novell)
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.token.encrypt;

import java.util.Map;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Handle RSTs and generate RSTRs as SAML Assertions. 
 * Compatible with www.identityblog.com
 * 
 * @author mikemci at us dot ibm dot com
 */
public class TokenEncryptHandler
	extends org.eclipse.higgins.sts.server.token.handler.TokenHandler
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(TokenEncryptHandler.class.getName());
    
    private boolean bConfigured = false;
	
	/**
	 * Protected constructor, must use TokenEncryptHandlerFactory
	 */
	protected TokenEncryptHandler()
	{
		this.log.trace("TokenEncryptHandler::TokenEncryptHandler");
	}
	
   /* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtension#configure(java.util.Hashtable)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings)
	{
		this.log.trace("TokenEncryptHandler::configure");
		
		this.bConfigured = true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.IExtension#invoke
     */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
	{
		org.eclipse.higgins.sts.api.IEndpointReference eprAppliesTo = null;
		this.log.trace("TokenEncryptHandler::invoke: " + strComponentName);
		
		if (!this.bConfigured)
		{
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Issue handler not configured");
			response.setFault(fault);
			return;
		}
		
		// TODO: Properly namespace qualify LocalNames throughout
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
		// TODO: Deal with collections?
		
		final org.eclipse.higgins.sts.api.IAppliesTo appliesToRequest = RST.getAppliesTo(); 		
//		org.apache.axiom.om.OMElement omAppliesToIdentity = null;
		this.log.trace("Checking for AppliesTo");
		if (appliesToRequest != null)
		{
			this.log.trace("Found AppliesTo");
			eprAppliesTo = appliesToRequest.getEndpointReference();
/*
			final java.util.List listOthers = eprAppliesTo.getAnyOtherElements();
			for (int i = 0; i < listOthers.size(); ++i)
			{
				final org.eclipse.higgins.sts.api.IElement elemOther = (org.eclipse.higgins.sts.api.IElement)listOthers.get(i);
				org.apache.axiom.om.OMElement omOther = null;
				try
				{
					omOther = (org.apache.axiom.om.OMElement)elemOther.getAs
						(org.apache.axiom.om.OMElement.class);
				}
				catch (final Exception e)
				{
		    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
						(this.log,
						e);
				}
				if (null != omOther)
				{
					final String strLocalName = omOther.getLocalName();
					if (strLocalName.equals("Identity"))
					{
						this.log.trace("Found AppliesTo/Identity");
						omAppliesToIdentity = omOther;
						break;
					}
				}
			}
*/
		}

/*
		org.apache.axiom.om.OMElement omAppliesToIdentityKeyInfo = null;
		if (omAppliesToIdentity != null)
		{
			final javax.xml.namespace.QName qnameKeyInfo = new javax.xml.namespace.QName
				(constants.getXMLSignatureNamespace().toString(),
				"KeyInfo");
			final java.util.Iterator iterAppliesToIdentityKeyInfo = omAppliesToIdentity.getChildrenWithName
				(qnameKeyInfo);
			if (iterAppliesToIdentityKeyInfo.hasNext())
			{
				this.log.trace("Found Identity/KeyInfo");
				omAppliesToIdentityKeyInfo = (org.apache.axiom.om.OMElement)iterAppliesToIdentityKeyInfo.next();
			}	
		}
		else
		{
			this.log.trace("AppliesTo/Identity Not Found");
		}

		org.apache.axiom.om.OMElement elemAppliesToIdentityKeyInfoX509Data = null;
		if (omAppliesToIdentityKeyInfo != null)
		{
			final javax.xml.namespace.QName qnameX509Data = new javax.xml.namespace.QName
				(constants.getXMLSignatureNamespace().toString(),
				"X509Data");
			final java.util.Iterator iterAppliesToIdentityKeyInfoX509Data = omAppliesToIdentityKeyInfo.getChildrenWithName
				(qnameX509Data);
			if (iterAppliesToIdentityKeyInfoX509Data.hasNext())
			{
				this.log.trace("Found KeyInfo/X509Data");
				elemAppliesToIdentityKeyInfoX509Data = (org.apache.axiom.om.OMElement)iterAppliesToIdentityKeyInfoX509Data.next();
			}	
		}
		else
		{
			this.log.trace("Identity/KeyInfo Not Found");
		}

		org.apache.axiom.om.OMElement elemAppliesToIdentityKeyInfoX509DataX509Certificate = null;
		if (elemAppliesToIdentityKeyInfoX509Data != null)
		{
			final javax.xml.namespace.QName qnameX509Certificate = new javax.xml.namespace.QName
				(constants.getXMLSignatureNamespace().toString(),
				"X509Certificate");
			final java.util.Iterator iterAppliesToIdentityKeyInfoX509DataX509Certificate = elemAppliesToIdentityKeyInfoX509Data.getChildrenWithName
				(qnameX509Certificate);
			if (iterAppliesToIdentityKeyInfoX509DataX509Certificate.hasNext())
			{
				this.log.trace("Found X509Data/X509Certificate");
				elemAppliesToIdentityKeyInfoX509DataX509Certificate = (org.apache.axiom.om.OMElement)iterAppliesToIdentityKeyInfoX509DataX509Certificate.next();
			}
		}
		else
		{
			this.log.trace("KeyInfo/X509Data Not Found");
		}
*/

		String strAppliesToIdentityCertificate = null;
/*
		if (elemAppliesToIdentityKeyInfoX509DataX509Certificate != null)
		{
			strAppliesToIdentityCertificate = elemAppliesToIdentityKeyInfoX509DataX509Certificate.getText();
		}
		else
		{
			this.log.trace("X509Data/X509Certificate Not Found");
			return;
		}
*/
		if (eprAppliesTo == null || (strAppliesToIdentityCertificate = eprAppliesTo.getIdentityCertificate()) == null)
		{
			this.log.trace("X509Data/X509Certificate Not Found");
			return;
		}
		
		final java.util.List listRSTR = response.getRequestSecurityTokenResponseCollection();
		final org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.common.RequestSecurityTokenResponse)listRSTR.get(0);
		final org.eclipse.higgins.sts.api.IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
		final org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get
			("XMLSecurityExtension");

	    /*
	    if (null == strAppliesToIdentityCertificate)
	    	strAppliesToIdentityCertificate = "MIIEsjCCApoCAQAwDQYJKoZIhvcNAQEEBQAwga8xCzAJBgNVBAYTAkNIMQ8wDQYDVQQIEwZadXJpY2gxDzANBgNVBAcTBlp1cmljaDEhMB8GA1UEChMYQWJoaUNlcnRpZmljYXRlQXV0aG9yaXR5MRUwEwYDVQQLEwxGaXJzdFR5cGUgQ0ExITAfBgNVBAMTGEFiaGlDZXJ0aWZpY2F0ZUF1dGhvcml0eTEhMB8GCSqGSIb3DQEJARYSYWJzQHp1cmljaC5pYm0uY29tMB4XDTA3MDUwNzEzMDAwNloXDTA3MDgxNTEzMDAwNlowgY0xCzAJBgNVBAYTAkNIMQ8wDQYDVQQIEwZadXJpY2gxDzANBgNVBAcTBlp1cmljaDEQMA4GA1UEChMHSUJNIFpSTDESMBAGA1UECxMJYWJoaSB0ZXN0MRMwEQYDVQQDEwphYmhpbGFwdG9wMSEwHwYJKoZIhvcNAQkBFhJhYmhpQGNzYWlsLm1pdC5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCskkmbBSXMRT9FuoE+hn0XvSKCJhedXG6ktgnjqODbDXlWHqDW+Jxj/N7CD1Nxry0lIsKNVcgJ8QXpX21aTDH3lMgdAZVyQYkVA24fGolV6fRFSybwaZ5/IxTW3H29wiZJhSKii5jSFfA/XPDTEFucT6u4VWR81dXCtd528T4vMXbF+QuWhfn5u5MZBncsWZr9YC5cKeV5Z6/qx9LpnfjHKeTNAlscv93YDYavkKt6kJX6hV/zZ3bIiJ90RxUE8UiVbY5PORRfY7uHU+Ga0MTbOj0Y0VGr++DQfrYDm1Prm0IRWFm4pjkNRZTmEZRxDtJ+IbNFfQC/SrcCSwO+e+odAgMBAAEwDQYJKoZIhvcNAQEEBQADggIBAMVyOhAHcw4iZnsjneSFWLSveEutSicl6nzjL7rRm9vQjZYna4VCYlUnnoCQoqms82KKxYohlvU1zFS90x7xKE5Of20NPIfzFSuUsxBQOtsDto+DCPoAAk3HmXcUQS/l2ZGJPeL4W6FEJrx4ewwMdN5LnrtqbaBMGJPonDWYqQHv+kPyc0a8djq3C3vFN1MfYIVSMDser7NLqgdqKjNKP00KeuiWoN72c5bgsRl+/S+QuVaZAgLkOVzN4r3RX+jIZe2TJgYzOlCuUC8/PFnFLGcukpIv2aUzGXx8mc7yhboInwbBlleN6xJnDWLwRivA9Tf6WrymH1L6KjPBBIFq9S17dXQyFRGy0BNVHaLEu3jBk8nv0cnrjI2bCBiH9rxnmqrq5VUy0gCHxlnNNKDx7cyf98/BlbtKh43t9gb3goaKUSYWO8mkA6eT6AAIpjCWFP+K8Y3R4T9jhXBfCROTa/fpzKtN9uIMMgV6oKTwnB+ATEhGhkzkSfnymz5H0orYA2gkU8OimcZCQTAtSLkXyiyE8u3O61vR5SEyb2diVIdCkqwK8dQT4NMX2LZwsXULUV7z8fclKlvImC++r1DwBDsVtbwwlE9DxviL9sBtS2MG+oZmYA0YwrIOqOvnjI7avxFV7MzzOWRC+06WNJAnHVlFCdiR1b9Q7kteqDZ0RxzC";
	    */
	    try
    	{
		    this.log.trace("Pre-Encrypt Token: " + (String)elemRequestedSecurityToken.getAs(String.class));
		    
		    final org.eclipse.higgins.sts.api.IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement
	    		("saml:Assertion",
	    		elemRequestedSecurityToken,
	    		strAppliesToIdentityCertificate);
			RSTR.setRequestedSecurityToken
				(elemEncryptedRequestedSecurityToken);
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"XML Encryption operation failed.");
			response.setFault(fault);
		}
	}
}