/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.token.identity;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.common.AuthNSelfIssuedMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IInformationCardReference;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.IUsernameToken;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.DigitalIdentity;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class DigitalIdentityHandler
extends TokenHandler {
    private final LogHelper log;
    private final QName qnameIdentityClaimType;
    private final QName qnameIdentityClaimURI;
    private final URI uriPPI;
    private boolean bConfigured;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected DigitalIdentityHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.token.identity.DigitalIdentityHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.qnameIdentityClaimType = new QName(null, "ClaimType");
        this.qnameIdentityClaimURI = new QName(null, "Uri");
        this.uriPPI = URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
        this.bConfigured = false;
        this.log.trace((Object)"DigitalIdentityHandler::DigitalIdentityHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)("DigitalIdentityHandler::configure: " + strComponentName));
        this.bConfigured = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        this.log.trace((Object)("DigitalIdentityHandler::invoke: " + strComponentName));
        if (!this.bConfigured) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Issue handler not configured");
            response.setFault((IFault)fault);
            return;
        }
        DigitalIdentity digitalIdentity = new DigitalIdentity();
        String strTrustedStore = (String)mapGlobalSettings.get("LDAPTrustedStore");
        String strTrustedStorePassword = (String)mapGlobalSettings.get("LDAPTrustedStorePassword");
        if (strTrustedStore != null) {
            String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
            this.log.trace((Object)("ConfigurationBase: " + strConfigurationBase));
            System.setProperty("javax.net.ssl.trustStore", String.valueOf(strConfigurationBase) + "/" + strTrustedStore);
        }
        if (strTrustedStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", strTrustedStorePassword);
        }
        URI uriDefaultContextRef = (URI)mapComponentSettings.get("DefaultContextRef");
        this.log.trace((Object)("DefaultContextRef: " + uriDefaultContextRef.toString()));
        String strTrustedDelegator = (String)mapComponentSettings.get("TrustedDelegator");
        this.log.trace((Object)("TrustedDelegator: " + strTrustedDelegator));
        URI uriSubjectNameIdentifierAttribute = (URI)mapComponentSettings.get("SubjectNameIdentifierAttribute");
        this.log.trace((Object)("SubjectNameIdentifierAttribute: " + uriSubjectNameIdentifierAttribute.toString()));
        digitalIdentity.setSubjectNameIdentifierURI(uriSubjectNameIdentifierAttribute);
        boolean bSubjectNameIdentifierClaim = false;
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        IdASRegistry IdAS = (IdASRegistry)mapGlobalSettings.get("IdentityAttributeService");
        AuthNSelfIssuedMaterials credential = null;
        ISecurityInformation securityInformation = request.getSecurityInformation();
        IElement elemClaims = RST.getClaims();
        OMElement omClaims = null;
        if (elemClaims != null) {
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.apache.axiom.om.OMElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                omClaims = (OMElement)elemClaims.getAs((Class)clazz);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Unsupported contained object class.");
                response.setFault((IFault)fault);
                return;
            }
        }
        Iterator iterClaimTypes = null;
        ArrayList<URI> alIdentityClaims = new ArrayList<URI>();
        if (omClaims != null) {
            iterClaimTypes = omClaims.getChildrenWithName(this.qnameIdentityClaimType);
            while (iterClaimTypes.hasNext()) {
                OMElement elemClaimType = (OMElement)iterClaimTypes.next();
                String strAttributeURI = elemClaimType.getAttributeValue(this.qnameIdentityClaimURI);
                URI uriAttribute = URI.create(strAttributeURI);
                if (this.uriPPI.equals(uriAttribute)) {
                    digitalIdentity.setIncludePPIClaim(true);
                    continue;
                }
                if (uriSubjectNameIdentifierAttribute != null && uriSubjectNameIdentifierAttribute.equals(uriAttribute)) {
                    bSubjectNameIdentifierClaim = true;
                }
                this.log.trace((Object)("Adding Identity Attribute: " + uriAttribute.toString()));
                alIdentityClaims.add(uriAttribute);
            }
        }
        if (uriSubjectNameIdentifierAttribute != null && !bSubjectNameIdentifierClaim) {
            this.log.trace((Object)("Adding Identity Attribute: " + uriSubjectNameIdentifierAttribute.toString()));
            alIdentityClaims.add(uriSubjectNameIdentifierAttribute);
        }
        IDigitalSubject digitalSubject = null;
        URI uriContextRef = null;
        IInformationCardReference informationCardReference = RST.getInformationCardReference();
        if (informationCardReference != null) {
            uriContextRef = informationCardReference.getCardId();
        } else {
            if (uriDefaultContextRef == null) {
                uriContextRef = constants.getIssuerSelf();
            }
            uriContextRef = uriDefaultContextRef;
        }
        this.log.trace((Object)("ContextRef: " + uriContextRef.toString()));
        IContextId cid = null;
        List listFactories = null;
        try {
            cid = ContextIdFactory.fromConfiguration((String)uriContextRef.toString());
            listFactories = IdAS.getContextFactories(cid);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
            response.setFault((IFault)fault);
            return;
        }
        this.log.trace((Object)"Iterating thru ContextFactories");
        int j = 0;
        while (j < listFactories.size()) {
            IContextFactory contextFactory = (IContextFactory)listFactories.get(j);
            try {
                Fault fault;
                this.log.trace((Object)("ContextFactory: " + contextFactory.getClass().getName()));
                this.log.trace((Object)("createContext: " + uriContextRef.toString()));
                IContext context = contextFactory.createContext(cid);
                if (securityInformation == null) {
                    this.log.trace((Object)"getSecurityInformation returned null");
                } else {
                    IUsernameToken usernameToken = securityInformation.getUsernameToken();
                    String strModulus = securityInformation.getModulus();
                    String strExponent = securityInformation.getExponent();
                    String strPPID = securityInformation.getPrivatePersonalIdentifier();
                    if (usernameToken != null) {
                        this.log.trace((Object)("Creating Username/Password Credential: " + usernameToken.getUsername() + "/XXXXXX"));
                        try {
                            credential = new AuthNNamePasswordMaterials(context, usernameToken.getUsername(), usernameToken.getPassword());
                        }
                        catch (Exception e) {
                            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                            Fault fault2 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
                            response.setFault((IFault)fault2);
                            return;
                        }
                    } else if (strModulus != null && strExponent != null) {
                        this.log.trace((Object)"Creating PPID/Modulus/Exponent Credential");
                        try {
                            credential = new AuthNSelfIssuedMaterials(context, strPPID, strModulus, strExponent);
                        }
                        catch (Exception e) {
                            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                            Fault fault3 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
                            response.setFault((IFault)fault3);
                            return;
                        }
                    } else {
                        this.log.trace((Object)"No Credential");
                        Fault fault4 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "No credential found.");
                        response.setFault((IFault)fault4);
                        return;
                    }
                }
                if (credential == null) {
                    fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Credential was not found");
                    response.setFault((IFault)fault);
                    return;
                }
                if (context != null) {
                    Fault fault5;
                    String strCUID = null;
                    this.log.trace((Object)"before IContext::open");
                    try {
                        strCUID = context.open(credential);
                    }
                    catch (Exception e) {
                        ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                        fault5 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
                        response.setFault((IFault)fault5);
                        return;
                    }
                    catch (Throwable t) {
                        ExceptionHelper.Log((LogHelper)this.log, (Throwable)t);
                        fault5 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", t.getLocalizedMessage());
                        response.setFault((IFault)fault5);
                        return;
                    }
                    this.log.trace((Object)"after IContext::open");
                    this.log.trace((Object)"before IContext::getSubject");
                    digitalSubject = context.getSubject(strCUID);
                    this.log.trace((Object)"after IContext::getSubject");
                    this._displaySubjectInfo(digitalSubject);
                    if (digitalSubject != null) {
                        int i = 0;
                        while (i < alIdentityClaims.size()) {
                            URI uriAttribute = (URI)alIdentityClaims.get(i);
                            this.log.trace((Object)("Adding Claim: " + uriAttribute.toString()));
                            ClaimType claimType = new ClaimType();
                            claimType.setName(uriAttribute);
                            Claim claim = new Claim();
                            claim.setType((IClaimType)claimType);
                            IAttribute attribute = digitalSubject.getAttribute(uriAttribute);
                            if (attribute != null) {
                                Iterator iterAttributeValues = attribute.getValues();
                                while (iterAttributeValues.hasNext()) {
                                    IAttributeValue attributeValue = (IAttributeValue)iterAttributeValues.next();
                                    if (attributeValue.isSimple()) {
                                        ISimpleAttrValue value = (ISimpleAttrValue)attributeValue;
                                        if (value == null) continue;
                                        String strValue = value.getLexical();
                                        this.log.trace((Object)("Adding Claim Value: " + strValue));
                                        claim.addValue(strValue);
                                        continue;
                                    }
                                    this.log.error((Object)"Unexpected complex value");
                                }
                                digitalIdentity.addClaim((IClaim)claim);
                            } else {
                                this.log.error((Object)"Could not find claim value");
                            }
                            ++i;
                        }
                        this.log.trace((Object)"Calling setDigitalIdentity");
                        RST.setDigitalIdentity((IDigitalIdentity)digitalIdentity);
                        return;
                    }
                    this.log.trace((Object)"digitalSubject is null");
                    Fault fault6 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "digitalSubject is null");
                    response.setFault((IFault)fault6);
                    return;
                }
                this.log.trace((Object)"context is null");
                fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "context is null");
                response.setFault((IFault)fault);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            }
            ++j;
        }
        this.log.trace((Object)"Done iterating thru ContextFactories");
        Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Digital Subject was not found");
        response.setFault((IFault)fault);
    }

    private void _displaySubjectInfo(IDigitalSubject subject) throws IdASException {
        Iterator attrIter = subject.getAttributes();
        System.out.println(subject.getSubjectID());
        System.out.println(subject.getType());
        while (attrIter.hasNext()) {
            IAttribute attr = (IAttribute)attrIter.next();
            Iterator propValueIter = attr.getValues();
            System.out.println(attr.getAttrID());
            while (propValueIter.hasNext()) {
                IAttributeValue propVal = (IAttributeValue)propValueIter.next();
                if (propVal.isSimple()) {
                    Object val = ((ISimpleAttrValue)propVal).getData();
                    if (val instanceof String) {
                        System.out.println(val);
                        continue;
                    }
                    System.out.println("Unknown: " + val.toString());
                    continue;
                }
                System.out.println("Unknown Complex : ");
            }
        }
    }
}

