/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *    Jim Sermersheim (Novell)
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.token.identity;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Handle RSTs and generate RSTRs as SAML Assertions. 
 * Compatible with www.identityblog.com
 * 
 * @author mikemci at us dot ibm dot com
 */
public class DigitalIdentityHandler
	extends org.eclipse.higgins.sts.server.token.handler.TokenHandler
{
	final private org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(DigitalIdentityHandler.class.getName());
	
	private java.net.URI uriSAMLAssertion = java.net.URI.create
		("urn:oasis:names:tc:SAML:1.0:assertion");
	
	private java.net.URI uriXMLSignature = java.net.URI.create
		("http://www.w3.org/2000/09/xmldsig#");

	private javax.xml.namespace.QName qnameAttribute = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "Attribute");
	
	private javax.xml.namespace.QName qnameAttributeName = new javax.xml.namespace.QName
		("AttributeName");
	
	private javax.xml.namespace.QName qnameAttributeValue = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "AttributeValue");

	private javax.xml.namespace.QName qnameSubject = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "Subject");
	
	private javax.xml.namespace.QName qnameSubjectConfirmation = new javax.xml.namespace.QName
		(uriSAMLAssertion.toString(), "SubjectConfirmation");
	
	private javax.xml.namespace.QName qnameKeyInfo = new javax.xml.namespace.QName
		(uriXMLSignature.toString(), "KeyInfo");
	
	private javax.xml.namespace.QName qnameKeyValue = new javax.xml.namespace.QName
		(uriXMLSignature.toString(), "KeyValue");
	
	private javax.xml.namespace.QName qnameRSAKeyValue = new javax.xml.namespace.QName
		(uriXMLSignature.toString(), "RSAKeyValue");
	
	private javax.xml.namespace.QName qnameModulus = new javax.xml.namespace.QName
		(uriXMLSignature.toString(), "Modulus");
	
	private javax.xml.namespace.QName qnameExponent = new javax.xml.namespace.QName
		(uriXMLSignature.toString(), "Exponent");

   	final private javax.xml.namespace.QName qnameIdentityClaimType = new javax.xml.namespace.QName
		(null,
		"ClaimType");
	
	final private javax.xml.namespace.QName qnameIdentityClaimURI = new javax.xml.namespace.QName
		(null,
		"Uri");
	
	final private java.net.URI uriPPI = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");

    private boolean bConfigured = false;
	
	/**
	 * Protected constructor, must use DigitalIdentityHandlerFactory
	 */
	protected DigitalIdentityHandler()
	{
		this.log.trace("DigitalIdentityHandler::DigitalIdentityHandler");
	}
	
    /* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityTokenServiceExtension#configure(java.util.Hashtable)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
	{
		this.log.trace("DigitalIdentityHandler::configure: " + strComponentName);
		
		this.bConfigured = true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityTokenServiceExtension#invoke
     */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
	{
		this.log.trace("DigitalIdentityHandler::invoke: " + strComponentName);
		
		if (!this.bConfigured)
		{
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Issue handler not configured");
			response.setFault(fault);
			return;		
		}	
		
		final org.eclipse.higgins.sts.api.IDigitalIdentity digitalIdentity = new org.eclipse.higgins.sts.common.DigitalIdentity();

		final String strTrustedStore = (String)mapGlobalSettings.get("LDAPTrustedStore");
		final String strTrustedStorePassword = (String)mapGlobalSettings.get("LDAPTrustedStorePassword");
		if (null != strTrustedStore)
		{
			final String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
			this.log.trace("ConfigurationBase: " + strConfigurationBase);
			System.setProperty("javax.net.ssl.trustStore", strConfigurationBase + "/" + strTrustedStore);
		}
		if (null != strTrustedStorePassword) {
			System.setProperty("javax.net.ssl.trustStorePassword", strTrustedStorePassword);
		}	

		final java.net.URI uriDefaultContextRef = (java.net.URI)mapComponentSettings.get
			("DefaultContextRef");
		this.log.trace("DefaultContextRef: " + uriDefaultContextRef.toString());
		
		final String strTrustedDelegator = (String)mapComponentSettings.get
    		("TrustedDelegator");
		this.log.trace("TrustedDelegator: " + strTrustedDelegator);

		final java.net.URI uriSubjectNameIdentifierAttribute = (java.net.URI)mapComponentSettings.get
			("SubjectNameIdentifierAttribute");
		this.log.trace("SubjectNameIdentifierAttribute: " + uriSubjectNameIdentifierAttribute.toString());
		digitalIdentity.setSubjectNameIdentifierURI(uriSubjectNameIdentifierAttribute);
		boolean bSubjectNameIdentifierClaim = false;

		// TODO: Properly namespace qualify LocalNames throughout
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
		// TODO: Deal with collections?
		
		//final IdASRegistry IdAS = IdASRegistry.getInstance();
		final org.eclipse.higgins.idas.registry.IdASRegistry IdAS = (org.eclipse.higgins.idas.registry.IdASRegistry)mapGlobalSettings.get("IdentityAttributeService");
		
		org.eclipse.higgins.idas.api.IAuthNAttributesMaterials credential = null;
	   	final ISecurityInformation securityInformation = request.getSecurityInformation();		
	   			
		final org.eclipse.higgins.sts.api.IElement elemClaims = RST.getClaims();
		org.apache.axiom.om.OMElement omClaims = null;
		if (null != elemClaims)
		{
			try
			{
				omClaims = (org.apache.axiom.om.OMElement)elemClaims.getAs
					(org.apache.axiom.om.OMElement.class);
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);
				final Fault fault = new Fault
					(constants.getWSTrustNamespace(),
					"wst",
					constants.getRequestFailedFaultCode(),
					"The specified request failed",
					"Unsupported contained object class.");
				response.setFault(fault);
				return;			
			}
		}		
		
		java.util.Iterator iterClaimTypes = null;
		final java.util.ArrayList alIdentityClaims = new java.util.ArrayList();
		if (null != omClaims)
		{
			iterClaimTypes = omClaims.getChildrenWithName
				(this.qnameIdentityClaimType);
			while (iterClaimTypes.hasNext())
			{
				final org.apache.axiom.om.OMElement elemClaimType = (org.apache.axiom.om.OMElement)iterClaimTypes.next();
		  		final String strAttributeURI = elemClaimType.getAttributeValue(this.qnameIdentityClaimURI);
		  		final java.net.URI uriAttribute = java.net.URI.create(strAttributeURI);				
				if (this.uriPPI.equals(uriAttribute))
				{
					digitalIdentity.setIncludePPIClaim(true);
					continue;
				}
				if (null != uriSubjectNameIdentifierAttribute)
			   	{
					if (uriSubjectNameIdentifierAttribute.equals(uriAttribute))
					{
						bSubjectNameIdentifierClaim = true;
					}
			   	}
				this.log.trace("Adding Identity Attribute: " + uriAttribute.toString());
		  		alIdentityClaims.add(uriAttribute);
			}
		}
		if ((null != uriSubjectNameIdentifierAttribute) && !bSubjectNameIdentifierClaim)
	   	{
			this.log.trace("Adding Identity Attribute: " + uriSubjectNameIdentifierAttribute.toString());
			alIdentityClaims.add(uriSubjectNameIdentifierAttribute);
	   	}

  		//java.util.Iterator iterClaims = digitalIdentity.getClaims();

		IEntity entity = null;
		java.net.URI uriContextRef = null;
	   	final org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference = RST.getInformationCardReference();
	   	if (null != informationCardReference)
	   	{
	   		uriContextRef = informationCardReference.getCardId();
	   	}
	   	else
	   	{
	   		if (null == uriDefaultContextRef) {
				uriContextRef = constants.getIssuerSelf();
			}
	   		uriContextRef = uriDefaultContextRef;
	   	}	
	   	
   		this.log.trace("ContextRef: " + uriContextRef.toString());
   		org.eclipse.higgins.idas.api.IContextId cid = null;
   		java.util.List listFactories = null;
   		try
   		{
   			String strContextRef = uriContextRef.toString();
   			if (strContextRef.startsWith("file://"))
   			{
   				int nQuery = strContextRef.indexOf("?id=");
   				if (-1 != nQuery)
   					strContextRef = strContextRef.substring(nQuery + 4);
   	   			strContextRef = "urn:" + strContextRef;
   			}
   			int nParam = strContextRef.indexOf("&");
   			if (-1 != nParam)
   				strContextRef = strContextRef.substring(0, nParam);
   			cid = org.eclipse.higgins.idas.registry.contextid.ContextIdFactory.fromConfiguration(strContextRef);
	   		listFactories = IdAS.getContextFactories(cid);
   		}
   		catch (Exception e)
   		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getFailedAuthenticationFaultCode(),
				"Authentication failed",
				e.getLocalizedMessage());
			response.setFault(fault);
		   	return;   			
   		}
	   	this.log.trace("Iterating thru ContextFactories");
	   	for (int j = 0; j < listFactories.size(); ++j)
	   	{
	   		final org.eclipse.higgins.idas.api.IContextFactory contextFactory = (org.eclipse.higgins.idas.api.IContextFactory)listFactories.get(j);
	   		try
	   		{
	   			this.log.trace("ContextFactory: " + contextFactory.getClass().getName());
	   			this.log.trace("createContext: " + uriContextRef.toString());
	   			final org.eclipse.higgins.idas.api.IContext context = contextFactory.createContext
	   				(cid);
	   		   	if (null == securityInformation)
	   		   	{
	   		   		this.log.trace("getSecurityInformation returned null");
	   		   	}
	   		   	else
	   		   	{
	   			   	final org.eclipse.higgins.sts.api.ISAMLToken samlToken = (org.eclipse.higgins.sts.api.ISAMLToken)securityInformation.getFirst(org.eclipse.higgins.sts.api.ISAMLToken.class);
	   			   	String strModulus = null;
	   			   	String strExponent = null;
	   				String strPPID = null;
	   			   	if (null != samlToken)
	   			   	{
		   			   	final org.eclipse.higgins.sts.api.IElement elemAttributeStatement = samlToken.getAttributeStatement();
	   			   		final org.apache.axiom.om.OMElement omAttributeStatement = (org.apache.axiom.om.OMElement)elemAttributeStatement.getAs(org.apache.axiom.om.OMElement.class);
	   			   		final org.apache.axiom.om.OMElement omSubject = omAttributeStatement.getFirstChildWithName(qnameSubject);
	   			   		final org.apache.axiom.om.OMElement omSubjectConfirmation = omSubject.getFirstChildWithName(qnameSubjectConfirmation);
	   			   		final org.apache.axiom.om.OMElement omKeyInfo = omSubjectConfirmation.getFirstChildWithName(qnameKeyInfo);
	   			   		final org.apache.axiom.om.OMElement omKeyValue = omKeyInfo.getFirstChildWithName(qnameKeyValue);
	   			   		final org.apache.axiom.om.OMElement omRSAKeyValue = omKeyValue.getFirstChildWithName(qnameRSAKeyValue);
	   			   		final org.apache.axiom.om.OMElement omModulus = omRSAKeyValue.getFirstChildWithName(qnameModulus);
	   			   		final org.apache.axiom.om.OMElement omExponent = omRSAKeyValue.getFirstChildWithName(qnameExponent);
		   			   	strModulus = omModulus.getText();
		   			   	strExponent = omExponent.getText();
		   			   	final java.util.Iterator iterAttributes = omAttributeStatement.getChildrenWithName(qnameAttribute);
		   			   	while (iterAttributes.hasNext())
		   			   	{
		   			   		final org.apache.axiom.om.OMElement omAttribute = (org.apache.axiom.om.OMElement)iterAttributes.next();
		   			   		final String strAttributeName = omAttribute.getAttributeValue(qnameAttributeName);
		   			   		if (strAttributeName.equals("privatepersonalidentifier"))
		   			   		{
		   			   			final org.apache.axiom.om.OMElement omAttributeValue = omAttribute.getFirstChildWithName(qnameAttributeValue);
		   			   			strPPID = omAttributeValue.getText();
		   			   		}
		   			   	}
		   		   		this.log.trace("Creating PPID/Modulus/Exponent Credential");
		   			   		
	   		   			try
	   		   			{
	   						credential = new org.eclipse.higgins.idas.common.AuthNSelfIssuedMaterials
	   		   					(context, strPPID, strModulus, strExponent);
	   		   			}
	   	   				catch (final Exception e)
	   	   				{
	   	   					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
	   	   						(this.log,
	   	   						e);
	   	   					final Fault fault = new Fault
	   		   					(constants.getWSTrustNamespace(),
	   		   					"wst",
	   		   					constants.getFailedAuthenticationFaultCode(),
	   		   					"Authentication failed",
	   		   					e.getLocalizedMessage());
	   		   				response.setFault(fault);
	   		   			   	return;
	   	   				}
	   			   	}
	   			   	final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = (org.eclipse.higgins.sts.api.IUsernameToken)securityInformation.getFirst(org.eclipse.higgins.sts.api.IUsernameToken.class);
	   		   		if (null != usernameToken)
	   		   		{
	   		   			this.log.trace("Creating Username/Password Credential: " + usernameToken.getUsername() +"/XXXXXX");
	   		   			try
	   		   			{
	   		   				credential = new org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials
	   		   					(context,
	   		   					usernameToken.getUsername(),
	   		   					usernameToken.getPassword());
	   		   			}
	   	   				catch (final Exception e)
	   	   				{
	   	   					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
	   	   						(this.log,
	   	   						e);
	   	   					final Fault fault = new Fault
	   		   					(constants.getWSTrustNamespace(),
	   		   					"wst",
	   		   					constants.getFailedAuthenticationFaultCode(),
	   		   					"Authentication failed",
	   		   					e.getLocalizedMessage());
	   		   				response.setFault(fault);
	   		   			   	return;
	   	   				}
	   		   		}
	   		   		final org.eclipse.higgins.sts.api.IBinarySecurityToken binaryToken = (org.eclipse.higgins.sts.api.IBinarySecurityToken)securityInformation.getFirst(org.eclipse.higgins.sts.api.IBinarySecurityToken.class);
	   		   		if (null != binaryToken)
	   		   		{
	   		   			this.log.trace("Creating X.509 Credential");
	   		   			try
	   		   			{
	   		   				java.security.cert.X509Certificate certificate = org.eclipse.higgins.sts.utilities.CertificateHelper.fromString
	   		   					(binaryToken.getEncodedValue());
	   		   				java.security.MessageDigest mdSHA1 = java.security.MessageDigest.getInstance("SHA-1");
	   		   				byte [] byteDigest = mdSHA1.digest(certificate.getEncoded());
	   		   				credential = new org.eclipse.higgins.idas.common.AuthNX509CertificateMaterials(byteDigest);
	   		   			}
	   	   				catch (final Exception e)
	   	   				{
	   	   					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
	   	   						(this.log,
	   	   						e);
	   	   					final Fault fault = new Fault
	   		   					(constants.getWSTrustNamespace(),
	   		   					"wst",
	   		   					constants.getFailedAuthenticationFaultCode(),
	   		   					"Authentication failed",
	   		   					e.getLocalizedMessage());
	   		   				response.setFault(fault);
	   		   			   	return;
	   	   				}
	   		   		}
	   		   	}
	   		   	
	   		   	if (null == credential)
	   		   	{
	   				final Fault fault = new Fault
	   					(constants.getWSTrustNamespace(),
	   					"wst",
	   					constants.getFailedAuthenticationFaultCode(),
	   					"Authentication failed",
	   					"Credential was not found");
	   				response.setFault(fault);
	   				return;
	   		   	}
	   			
	   			if (null != context)
	   			{
	   			   	String strCUID = null;
	   				this.log.trace("before IContext::open");
	   				try
	   				{
	   					strCUID = context.open(credential);
	   				}
	   				catch (final Exception e)
	   				{
	   					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
	   						(this.log,
	   						e);
	   					final Fault fault = new Fault
		   					(constants.getWSTrustNamespace(),
		   					"wst",
   		   					constants.getFailedAuthenticationFaultCode(),
   		   					"Authentication failed",
		   					e.getLocalizedMessage());
		   				response.setFault(fault);
		   			   	return;
	   				}
	   				catch (final Throwable t)
	   				{
	   					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
	   						(this.log,
	   						t);
	   					final Fault fault = new Fault
		   					(constants.getWSTrustNamespace(),
		   					"wst",
   		   					constants.getFailedAuthenticationFaultCode(),
   		   					"Authentication failed",
		   					t.getLocalizedMessage());
		   				response.setFault(fault);
		   			   	return;
	   				}
	   				this.log.trace("after IContext::open");
	   				this.log.trace("before IContext::getSubject");
	   				/*
	   				digitalSubject = context.getSubject
	   					(strCUID,
	   					alIdentityClaims.iterator());	   
	   				*/
	   				entity = context.getEntity
	   					(strCUID);		   				
	   				this.log.trace("after IContext::getSubject");
	   				_displaySubjectInfo(entity);
	   				
	   				if (null != entity)
	   				{
	   					for (int i = 0; i < alIdentityClaims.size(); ++i)
	   					{
	   						final java.net.URI uriAttribute = (java.net.URI)alIdentityClaims.get(i);
	   						
	   				  		this.log.trace("Adding Claim: " + uriAttribute.toString());

	   				  		final org.eclipse.higgins.sts.api.IClaimType claimType = new org.eclipse.higgins.sts.common.ClaimType();
	   				  		claimType.setName(uriAttribute);
	   				  		final org.eclipse.higgins.sts.api.IClaim claim = new org.eclipse.higgins.sts.common.Claim();
	   				  		claim.setType(claimType);
	   						final org.eclipse.higgins.idas.api.IAttribute attribute = entity.getAttribute(uriAttribute);
	   						if (null != attribute)
	   						{
		   						final java.util.Iterator iterAttributeValues = attribute.getValues();
		   						while (iterAttributeValues.hasNext())
		   						{
		   							final org.eclipse.higgins.idas.api.IAttributeValue attributeValue = (org.eclipse.higgins.idas.api.IAttributeValue)iterAttributeValues.next();
		   							if (attributeValue.isSimple())
		   							{
		   								final org.eclipse.higgins.idas.api.ISimpleAttrValue value = (org.eclipse.higgins.idas.api.ISimpleAttrValue)attributeValue;
		   								if (null != value)
		   								{
		   									final String strValue = value.getLexical();
		   									this.log.trace("Adding Claim Value: " + strValue);	   			  					
		   									claim.addValue(strValue);
		   								}
		   							}
		   							else
		   							{
		   								this.log.error("Unexpected complex value");
		   							}
		   						}			  		
		   				  		digitalIdentity.addClaim(claim);
	   						}
	   						else
	   						{
	   							this.log.error("Could not find claim value");
	   						}
						}

	   					this.log.trace("Calling setDigitalIdentity");
	   					RST.setDigitalIdentity
	   						(digitalIdentity);
	   					return;
	   				}
	   				else
	   				{
	   					this.log.trace("digitalSubject is null");
	   					final Fault fault = new Fault
		   					(constants.getWSTrustNamespace(),
		   					"wst",
   		   					constants.getFailedAuthenticationFaultCode(),
   		   					"Authentication failed",
		   					"digitalSubject is null");
		   				response.setFault(fault);
		   			   	return;
	   				}
	   			}
	   			else
	   			{
	   				this.log.trace("context is null");
   					final Fault fault = new Fault
	   					(constants.getWSTrustNamespace(),
	   					"wst",
	   					constants.getFailedAuthenticationFaultCode(),
	   					"Authentication failed",
	   					"context is null");
	   				response.setFault(fault);	   				
	   			}
	   		}
	   		catch (final Exception e)
	   		{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);
	    		continue;
	   		}
	   	}
	   	this.log.trace("Done iterating thru ContextFactories");
	   	
	   	final Fault fault = new Fault
			(constants.getWSTrustNamespace(),
			"wst",
			constants.getRequestFailedFaultCode(),
			"The specified request failed",
			"Node was not found");
		response.setFault(fault);
	}
	
	private void _displaySubjectInfo
		(IEntity subject) throws IdASException
	{
		Iterator attrIter = subject.getAttributes();
		System.out.println(subject.getEntityID());
		System.out.println(subject.getEntityType());

		while (attrIter.hasNext())
		{
			IAttribute attr = (IAttribute) attrIter.next();
			Iterator propValueIter = attr.getValues();
			System.out.println(attr.getAttrID());

			while (propValueIter.hasNext())
			{
				IAttributeValue propVal = (IAttributeValue) propValueIter.next();
				if (propVal.isSimple())
				{
					Object val =((ISimpleAttrValue) propVal).getData();
					if (val instanceof String)
						System.out.println(val);
					else
						System.out.println("Unknown: " + val.toString());
				}
				else
				{
					System.out.println("Unknown Complex : ");
				}
			}
		}	
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}
}