/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.token.self;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.DigitalIdentity;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class SelfIdentityHandler
extends TokenHandler {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$server$token$self$SelfIdentityHandler == null ? (class$org$eclipse$higgins$sts$server$token$self$SelfIdentityHandler = SelfIdentityHandler.class$("org.eclipse.higgins.sts.server.token.self.SelfIdentityHandler")) : class$org$eclipse$higgins$sts$server$token$self$SelfIdentityHandler).getName());
    private final QName qnameIdentityClaimType = new QName(null, "ClaimType");
    private final QName qnameIdentityClaimURI = new QName(null, "Uri");
    private final URI uriPPI = URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
    private boolean bConfigured = false;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$server$token$self$SelfIdentityHandler;
    static /* synthetic */ Class class$org$apache$axiom$om$OMElement;

    protected SelfIdentityHandler() {
        this.log.trace((Object)"SelfIdentityHandler::SelfIdentityHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) {
        this.log.trace((Object)("SelfIdentityHandler::configure: " + strComponentName));
        this.bConfigured = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        this.log.trace((Object)("SelfIdentityHandler::invoke: " + strComponentName));
        if (!this.bConfigured) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Issue handler not configured");
            response.setFault((IFault)fault);
            return;
        }
        DigitalIdentity digitalIdentity = new DigitalIdentity();
        URI uriSubjectNameIdentifierAttribute = (URI)mapComponentSettings.get("SubjectNameIdentifierAttribute");
        this.log.trace((Object)("SubjectNameIdentifierAttribute: " + uriSubjectNameIdentifierAttribute.toString()));
        digitalIdentity.setSubjectNameIdentifierURI(uriSubjectNameIdentifierAttribute);
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        IElement elemClaims = RST.getClaims();
        OMElement omClaims = null;
        if (null != elemClaims) {
            try {
                omClaims = (OMElement)elemClaims.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = SelfIdentityHandler.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Unsupported contained object class.");
                response.setFault((IFault)fault);
                return;
            }
        }
        Iterator iterClaimTypes = null;
        if (null != omClaims) {
            iterClaimTypes = omClaims.getChildrenWithName(this.qnameIdentityClaimType);
            while (iterClaimTypes.hasNext()) {
                OMElement elemClaimType = (OMElement)iterClaimTypes.next();
                String strAttributeURI = elemClaimType.getAttributeValue(this.qnameIdentityClaimURI);
                URI uriAttribute = URI.create(strAttributeURI);
                if (this.uriPPI.equals(uriAttribute)) {
                    digitalIdentity.setIncludePPIClaim(true);
                    continue;
                }
                this.log.trace((Object)("Adding Identity Attribute: " + uriAttribute.toString()));
                ClaimType claimType = new ClaimType();
                claimType.setName(uriAttribute);
                Claim claim = new Claim();
                claim.setType((IClaimType)claimType);
                String strValue = elemClaimType.getText();
                this.log.trace((Object)("Adding Claim Value: " + strValue));
                claim.addValue(strValue);
                digitalIdentity.addClaim((IClaim)claim);
            }
            this.log.trace((Object)"Calling setDigitalIdentity");
            RST.setDigitalIdentity((IDigitalIdentity)digitalIdentity);
        }
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

